package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sb.CerLearnAuthRecord;
import com.bcxin.ars.service.sb.CerLearnAuthRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * 资格证/等级证学习认证记录Controller
 * 
 * @author lin
 * @date 2020-09-08
 */
@Controller
@RequestMapping("/cerLearnAuthRecord")
public class CerLearnAuthRecordController {
    Logger logger = LoggerFactory.getLogger(CerLearnAuthRecordController.class);

    @Autowired
    private CerLearnAuthRecordService cerLearnAuthRecordService;

    /**
     * 保存
     * @param cerLearnAuthRecord
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(CerLearnAuthRecord cerLearnAuthRecord){
        AjaxResult result = new AjaxResult();
        try {
            cerLearnAuthRecordService.save(cerLearnAuthRecord);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

}
