package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SafetySearchDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Safety;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.SafetyService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;

@Controller
@RequestMapping("safety")
public class SafetyController {

	Logger logger = LoggerFactory.getLogger(SafetyController.class);
	
	@Autowired
	private SafetyService safetyService;

	@Autowired
	private SecurityPersonService personService;
	
	@Autowired
	private ArsUtil arsUtil;
	

	
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(@Valid Safety safety) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				result.setMsg("更新成功");
				safetyService.saveOrUpdate(safety);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Safety safety) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				safetyService.delete(safety);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
