// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------

/** When your routing table is too long, you can split it into small modules **/

import Layout from '@/layout';

const marketingRouter = {
  path: '/marketing',
  component: Layout,
  redirect: '/coupon/list',
  name: 'Marketing',
  meta: {
    title: '营销',
    icon: 'clipboard',
  },
  children: [
    {
      path: 'sign',
      component: () => import('@/views/marketing/sign'),
      name: 'Sign',
      meta: { title: '签到', icon: '' },
      children: [
        {
          path: 'config',
          component: () => import('@/views/marketing/sign/config/index'),
          name: 'signConfig',
          hidden: true,
          meta: { title: '签到配置', icon: '' },
        },
        {
          path: 'record',
          component: () => import('@/views/marketing/sign/record/index'),
          name: 'signRecord',
          hidden: true,
          meta: { title: '签到记录', icon: '' },
        },
      ],
    },
    {
      path: 'integral',
      component: () => import('@/views/marketing/integral/index'),
      name: 'Integral',
      meta: { title: '积分', icon: '' },
      children: [
        {
          path: 'integralconfig',
          component: () => import('@/views/marketing/integral/config/index'),
          name: 'integralConfig',
          meta: { title: '积分配置', icon: '' },
        },
        {
          path: 'integrallog',
          component: () => import('@/views/marketing/integral/integralLog/index'),
          name: 'integralLog',
          meta: { title: '积分日志', icon: '' },
        },
      ],
    },
    {
      path: 'seckill',
      component: () => import('@/views/marketing/seckill/index'),
      name: 'Seckill',
      meta: { title: '秒杀', icon: '' },
      children: [
        {
          path: 'config',
          component: () => import('@/views/marketing/seckill/seckillConfig/index'),
          name: 'SeckillConfig',
          meta: { title: '秒杀配置', icon: '' },
        },
        {
          path: 'list/:timeId?',
          component: () => import('@/views/marketing/seckill/seckillList/index'),
          name: 'SeckillList',
          meta: { title: '秒杀商品', icon: '' },
        },
        {
          path: 'seckillActivity',
          component: () => import('@/views/marketing/seckill/seckillActivity/index'),
          name: 'SeckillActivity',
          meta: { title: '秒杀活动', icon: '' },
        },
        {
          path: 'creatSeckill/:id?/:type?',
          component: () => import('@/views/marketing/seckill/seckillActivity/creatSeckill'),
          name: 'CreatSeckill',
          meta: { title: '添加秒杀商品', icon: '', noCache: true, activeMenu: `/marketing/seckill/seckillActivity` },
        },
      ],
    },
    {
      path: 'atmosphere',
      name: 'atmosphere',
      meta: {
        title: '活动氛围',
        noCache: true,
      },
      redirect: 'noRedirect',
      component: () => import('@/views/marketing/atmosphere/index'),
      children: [
        {
          path: 'list',
          name: `atmosphereList`,
          meta: {
            title: '氛围列表',
            noCache: true,
          },
          component: () => import('@/views/marketing/atmosphere/atmosphereList/list'),
        },
        {
          path: 'add/:id?',
          name: `addAtmosphere`,
          meta: {
            title: '添加活动氛围',
            noCache: true,
            activeMenu: `/marketing/atmosphere/list`,
          },
          component: () => import('@/views/marketing/atmosphere/atmosphereList/addAtmosphere'),
        },
      ],
    },
    {
      path: 'border',
      name: 'border',
      meta: { title: '活动边框', icon: '' },
      redirect: 'noRedirect',
      component: () => import('@/views/marketing/border/index'),
      children: [
        {
          path: 'list',
          name: `borderList`,
          meta: {
            title: '活动边框列表',
            noCache: true,
          },
          component: () => import('@/views/marketing/atmosphere/atmosphereList/list'),
        },
        {
          path: 'add/:id?',
          name: `addBorder`,
          meta: {
            title: '添加活动边框',
            noCache: true,
            activeMenu: `/marketing/border/list`,
          },
          component: () => import('@/views/marketing/atmosphere/atmosphereList/addAtmosphere'),
        },
      ],
    },
    {
      path: 'broadcast',
      name: 'Broadcast',
      meta: {
        title: '直播',
        noCache: true
      },
      redirect: 'noRedirect',
      component: () => import('@/views/marketing/broadcast/index'),
      children: [
        {
          path: 'list',
          name: 'BroadcastList',
          meta: {
            title: '直播间管理',
            noCache: true
          },
          component: () => import('@/views/marketing/broadcast/list/index')
        },
        {
          path: 'product',
          name: 'BroadcastProduct',
          meta: {
            title: '直播商品列表',
            noCache: true
          },
          component: () => import('@/views/marketing/broadcast/product/index')
        }
      ]
    },
  ],
};

export default marketingRouter;
