// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------

import request from '@/utils/request';

/**
 * @description 分销设置 -- 详情
 */
export function configApi () {
  return request({
    url: '/admin/platform/retail/store/config/get',
    method: 'get',
  });
}

/**
 * @description 分销设置 -- 表单提交
 */
export function configUpdateApi (data) {
  return request({
    url: '/admin/platform/retail/store/config/save',
    method: 'post',
    data,
  });
}

/**
 * @description 分销员 -- 列表
 */
export function promoterListApi (params) {
  return request({
    url: '/admin/platform/retail/store/people/list',
    method: 'get',
    params,
  });
}

/**
 * @description 根据条件获取下级推广用户列表
 */
export function spreadListApi (params) {
  return request({
    url: '/admin/platform/retail/store/sub/user/list',
    method: 'get',
    params,
  });
}

/**
 * @description 推广人订单 -- 列表
 */
export function spreadOrderListApi (params) {
  return request({
    url: '/admin/platform/retail/store/promotion/order/list',
    method: 'get',
    params,
  });
}

/**
 * @description 推广人 -- 清除上级推广人
 */
export function spreadClearApi (id) {
  return request({
    url: `/admin/platform/retail/store/clean/spread/${id}`,
    method: 'get',
  });
}

/**
 * @description 查询分销商品列表
 */
export function getDistributionGoodsApi (params) {
  return request({
    url: `/admin/platform/bcx/brokerage/config/product/list`,
    method: 'GET',
    params,
  });
}

/**
 * @description 开启/取消分销状态
 */
export function setDistributionStatusApi (data) {
  return request({
    url: `/admin/platform/bcx/brokerage/config/set/product`,
    method: 'POST',
    data,
  });
}

/**
 * @description 业绩报表列表 1、分销员
 */
export function earningFxyListApi (params) {
  return request({
    url: `/front/user/performance/report/fxy/list`,
    method: 'GET',
    params,
  });
}

/**
 * @description 业绩报表统计(分销商端查看员工的时候，调用这个接口)
 */
export function reportFxyStatisticsApi (params) {
  return request({
    url: `/front/user/performance/report/fxy/statistics`,
    method: 'GET',
    params,
  });
}

/**
 * @description 业绩报表统计(渠道端、分销商端、分销员端，调用这个接口)
 */
export function reportStatisticsApi (params) {
  return request({
    url: `/front/user/performance/report/statistics`,
    method: 'GET',
    params,
  });
}

/**
 * @description 业绩账单统计(分销商端查看员工的时候，调用这个接口)
 */
export function billFxyStatisticsApi (params) {
  return request({
    url: `/front/user/settle/bill/fxy/statistics`,
    method: 'GET',
    params,
  });
}

/**
 * @description 业绩账单统计(渠道端、分销商端、分销员端，调用这个接口)
 */
export function billStatisticsApi (params) {
  return request({
    url: `/front/user/settle/bill/statistics`,
    method: 'GET',
    params,
  });
}

/**
 * @description 业绩报表列表 2、分销商 3、渠道商
 */
export function earningListApi (params) {
  return request({
    url: `/front/user/performance/report/list`,
    method: 'GET',
    params,
  });
}

/**
 * @description 账单详情
 */
export function earningSettleListApi (params) {
  return request({
    url: `/front/user/performance/report/settle/bill/list`,
    method: 'GET',
    params,
  });
}

/**
 * @description 分销员业绩账单
 */
export function distributorPerformanceBillApi (params) {
  return request({
    url: `/front/user/settle/bill/fxy/list`,
    method: 'GET',
    params,
  });
}

/**
 * @description 分销商账单
 */
export function companyPerformanceBillApi (params) {
  return request({
    url: `/front/user/settle/bill/list`,
    method: 'GET',
    params,
  });
}

/**
 * @description 渠道商账单
 */
export function channelPerformanceBillApi (params) {
  return request({
    url: `/front/user/settle/bill/list`,
    method: 'GET',
    params,
  });
}

/**
 * @description 业绩账单详情
 */
export function getSettleBillDetailApi (params) {
  return request({
    url: `/front/user/settle/bill/detail/${params.id}`,
    method: 'GET',
    params,
  });
}

/**
 * @description 结算单 1、分销员 2、分销商 3、渠道商 4、部门 5、部门成员
 */
export function getSettlementDocApi (type, params) {
  let url = type === 1 ? `/admin/platform/bcx/settle/fxy/list` : type === 2 ? `/admin/platform/bcx/settle/fxs/list` : type === 3 ? `/admin/platform/bcx/settle/channel/list` : type === 4 ? `/admin/platform/bcx/settle/department/list` : `/admin/platform/bcx/settle/department/member/list`;

  return request({
    url,
    method: 'GET',
    params
  });
}

/**
 * @description 获取结算单生成数据
 */
export function getSettleDocInfoApi (data) {
  return request({
    url: `/admin/platform/bcx/settle/get/settle/info`,
    method: 'POST',
    data
  });
}

/**
 * @description 确认结算
 */
export function confirmSettleApi (data) {
  return request({
    url: `/admin/platform/bcx/settle/do/settle`,
    method: 'POST',
    data
  });
}

/**
 * @description 结算单撤销
 */
export function revokeApi (params) {
  return request({
    url: `/admin/platform/bcx/settle/cancel/${params.id}`,
    method: 'POST',
    params
  });
}

/**
 * @description 生成结算单
 */
export function generateSettleApi (data) {
  return request({
    url: `/admin/platform/bcx/settle/bill/generate/settle`,
    method: 'POST',
    data,
  });
}


/**
 * @description 获取账单结算数据
 */
export function getSettleDataApi (data) {
  return request({
    url: `/admin/platform/bcx/settle/bill/get/settle/info`,
    method: 'POST',
    data,
  });
}

/**
 * @description 业绩报表列表批量导出excel 1、分销员 2、分销商 3、渠道商 4、部门 5、部门成员
 */
export function batchExportApi (key, params) {
  let url =
    key === 1
      ? `/admin/platform/bcx/performance/report/fxy/list/excel`
      : key === 2
        ? `/admin/platform/bcx/performance/report/fxs/list/excel`
        : key === 3
          ? `/admin/platform/bcx/performance/report/channel/list/excel`
          : key === 4
            ? `/admin/platform/bcx/performance/report/department/list/excel`
            : `/admin/platform/bcx/performance/report/department/member/list/excel`;

  return request({
    url,
    method: 'GET',
    params,
    responseType: 'blob',
  });
}


/**
 * @description 上传凭证和发票
 */
export function uploadInvoiceAndProofApi (data) {
  return request({
    url: `/admin/platform/bcx/settle/upload/attachments`,
    method: 'POST',
    data
  });
}

export function batchExporSettltApi (key, params) {
  let url =
    key === 1
      ? `/admin/platform/bcx/settle/fxy/list/excel`
      : key === 2
        ? `/admin/platform/bcx/settle/fxs/list/excel`
        : key === 3
          ? `/admin/platform/bcx/settle/channel/list/excel`
          : key === 4
            ? `/admin/platform/bcx/settle/department/list/excel`
            : `/admin/platform/bcx/settle/department/member/list/excel`;

  return request({
    url,
    method: 'GET',
    params,
    responseType: 'blob',
  });
}

/**
 * @description 结算单详情
 */
export function getSettleDocDetailApi (params) {
  return request({
    url: `/admin/platform/bcx/settle/detail/${params.id}`,
    method: 'GET',
    params
  });
}


// 分销系统-用户业绩报表控制层-佣金列表:
export function test1 (params) {
  return request({
    url: `/front/user/performance/report/list`,
    method: 'GET',
    params
  });
}
// 分销系统-用户业绩报表控制层-账单佣金列表:
export function test2 (params) {
  return request({
    url: `/front/user/performance/report/settle/bill/list`,
    method: 'GET',
    params
  });
}
