(function () {
  const isInUniApp = /uni-app/i.test(navigator.userAgent);

  const plusReadyCallback = [];

  const handlePlusReady = () => {
    while (plusReadyCallback.length) {
      plusReadyCallback.pop()();
    }
  }

  const initPlusReadyCallback = (callback) => {
    if (!isInUniApp) return;
    if (window.plus) {
      callback();
    } else {
      plusReadyCallback.push(callback);
    }
  }

  window.initPlusReadyCallback = initPlusReadyCallback;

  function handleSetStatusBarHeight() {
    const statusBarHeight = plus.navigator.getStatusbarHeight();
    document.body.style.setProperty('--status-bar-height', statusBarHeight + 'px');
  }

  initPlusReadyCallback(handleSetStatusBarHeight);

  if (isInUniApp) {
    if (window.plus) {
      handlePlusReady();
    } else {
      document.addEventListener('plusready', handlePlusReady, false);
    }
  }

  window.__plus_postmsg__ = (event) => {
    const s = isInUniApp;
    if (!s || !window.plus) return;
    const o = [];
    var n = plus.webview.currentWebview();
    var t = n.parent();
    o.push(t.id);
    var a = {
      options: {
        timestamp: +new Date
      },
      name: "postMessage",
      arg: {
        event
      }
    };

    plus.webview.postMessageToUniNView({
      type: "WEB_INVOKE_APPSERVICE",
      args: {
        data: a,
        webviewIds: o
      }
    }, "__uniapp__service")
  }
})();