import message from "@/utils/message";

// #ifdef APP
import { getWifiInfo } from "@/utils/wifi";
// #endif

export const useWifiInfo = () => {
  const wifiInfo = ref(null);
  const isWifiInfoLoading = ref(false);

  const refreshWifiInfo = async () => {
    if (isWifiInfoLoading.value) return;
    isWifiInfoLoading.value = true;

    // #ifdef APP
    const info = await getWifiInfo() as any;
    if (!info) {
      wifiInfo.value = null;
      message.error('获取 WIFI 信息失败', 'none');
    } else {
      wifiInfo.value = info.wifi;
    }
    isWifiInfoLoading.value = false;
    // #endif

    // #ifdef H5
    window.plus && window.__refresh_wifi_info__();
    // #endif
  }

  const updateWifiInfo = (info: any) => {
    isWifiInfoLoading.value = false;
    if (info) {
      wifiInfo.value = info;
    } else {
      wifiInfo.value = null;
      message.error('获取 WIFI 信息失败', 'none');
    }
  }

  const initWifiInfoCallback = () => {
    window.__init_wifi_callback__(updateWifiInfo);
  }
  
  onLoad(() => {
    // #ifdef H5
    initWifiInfoCallback();
    // #endif

    refreshWifiInfo();
  })
  
  onUnmounted(() => {
    // #ifdef H5
    window.__remove_wifi_callback__(updateWifiInfo);
    // #endif
  })

  return {
    wifiInfo,
    isWifiInfoLoading,
    refreshWifiInfo
  };
}