package com.bcxin.rbac.domain.services.commands.users;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class AssignUserCommand extends CommandAbstract {
    private final String subjectReferencedId;
    private final Collection<UserCommandItem> items;

    public AssignUserCommand(String subjectReferencedId, Collection<UserCommandItem> items) {
        this.subjectReferencedId = subjectReferencedId;
        this.items = items;
    }

    public static AssignUserCommand create(String subjectReferencedId,Collection<UserCommandItem> items) {
        AssignUserCommand command = new AssignUserCommand(subjectReferencedId, items);
        return command;
    }

    @Getter
    public static class UserCommandItem extends CommandAbstract {
        private final String referencedId;
        private final String name;
        private final Collection<String> roleIds;

        public UserCommandItem(String referencedId, String name, Collection<String> roleIds) {
            this.referencedId = referencedId;
            this.name = name;
            this.roleIds = roleIds;
        }

        public static UserCommandItem create(String referencedId, String name, Collection<String> roleIds) {
            return new UserCommandItem(referencedId,name,roleIds);
        }
    }
}
