package com.bcxin.rbac.domain.repositories.custom;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.rbac.domain.entities.RbacCustomRoleEntity;
import org.springframework.data.repository.query.Param;

import java.util.Optional;

public interface RbacCustomRoleRepository extends EntityRepository<RbacCustomRoleEntity, Long> {

    Optional<RbacCustomRoleEntity> findByOrganizationIdAndRoleName(String organizationId, String roleName);

    Optional<RbacCustomRoleEntity> findByOrganizationIdAndSeq(String organizationId, Integer seq);

    long findMaxSeqByOrganizationId(@Param("organizationId") String organizationId);
}