package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 权限应用用户关联表
 */
@Data
@Table(name = "rbac_permit_app_user")
@Entity
public class RbacPermitAppUserEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键id
     */
    @Id
    private Long id;
    /**
     * 企业id
     */
    @Column(name = "organization_id")
    private String organizationId;
    /**
     * 权限应用id
     */
    @Column(name = "permit_app_id")
    private Long permitAppId;
    /**
     * 职员id
     */
    @Column(name = "tenant_employee_id")
    private String tenantEmployeeId;
    /**
     * 应用代码
     */
    @Column(name = "app_code")
    private String appCode;
    /**
     * 应用权限类型，1：web权限，2：app权限，3：都有
     */
    @Column(name = "permit_type")
    private Integer permitType;
    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;
    /**
     * 创建人id
     */
    @Column(name = "create_user_id")
    private String createUserId;
    /**
     * 更新时间
     */
    @Column(name = "update_time")
    private Date updateTime;
    /**
     * 更新人id
     */
    @Column(name = "update_user_id")
    private String updateUserId;



    public static RbacPermitAppUserEntity create(Long id, String organizationId, Long permitAppId, String tenantEmployeeId,
                                                 String appCode, Integer permitType, String createUserId) {
        RbacPermitAppUserEntity role = new RbacPermitAppUserEntity();
        role.setId(id);
        role.setOrganizationId(organizationId);
        role.setPermitAppId(permitAppId);
        role.setTenantEmployeeId(tenantEmployeeId);
        role.setAppCode(appCode);
        role.setPermitType(permitType);
        role.setCreateTime(new Date());
        role.setCreateUserId(createUserId);
        return role;
    }
}
