/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.emus.FerryTaskStatusEnum;
import com.bcxin.ferry.common.utils.DateUtil;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.common.utils.ObsUtil;
import com.bcxin.ferry.configs.FerryChannelConfig;
import com.bcxin.ferry.configs.FerrySwitchConfig;
import com.bcxin.ferry.configs.SchedulingConfig;
import com.bcxin.ferry.dao.mapper.FerryTaskMapper;
import com.bcxin.ferry.dtos.baiduutil.ChangeLogsRequestDto;
import com.bcxin.ferry.dtos.baiduutil.FerryTaskPullResult;
import com.bcxin.ferry.entity.FerryTaskEntity;
import com.bcxin.ferry.service.RetryService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FerryTaskService
extends ServiceImpl<FerryTaskMapper, FerryTaskEntity> {
    private static final Logger log = LoggerFactory.getLogger(FerryTaskService.class);
    @Autowired
    private SchedulingConfig schedulingConfig;
    @Autowired
    private RetryService retryService;
    @Autowired
    private IdGeneratorSnowflake snowflake;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private FerryChannelConfig ferryChannelConfig;
    @Autowired
    private FerrySwitchConfig ferrySwitchConfig;

    @Transactional
    public void createFerryTask(String regionCode) {
        log.info("\u5f00\u59cb\u521b\u5efa\u6446\u6e21\u4efb\u52a1\uff0cregionCode\uff1a{}", (Object)regionCode);
        Date nowTime = new Date();
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getRegionCode, (Object)regionCode);
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        lqw.last("limit 1");
        List list = lqw.list();
        FerryTaskEntity lastTask = CollectionUtil.isNotEmpty((Collection)list) ? (FerryTaskEntity)list.get(0) : null;
        log.info(lastTask == null ? "\u6ca1\u6709\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1" : "\u6700\u8fd1\u4e00\u6b21\u7684\u4efb\u52a1\u6570\u636e\u4e3a\uff1a" + JSONObject.toJSONString((Object)lastTask));
        if (lastTask != null && lastTask.getTaskStatus().intValue() != FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode()) {
            log.info("\u6700\u8fd1\u4e00\u6b21\u6446\u6e21\u4efb\u52a1\u672a\u5b8c\u6210");
            long intervalTime = 0x6DDD00L;
            long differenceTime = nowTime.getTime() - lastTask.getCreateTime().getTime();
            if (differenceTime >= intervalTime) {
                log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u521b\u5efa\u65f6\u95f4>=2\u5c0f\u65f6\uff0c\u8fdb\u884c\u8865\u507f\uff0c\u590d\u5236\u4e00\u4e2a\u4efb\u52a1\u51fa\u6765\uff0c\u91cd\u65b0\u6446\u6e21");
                String requestId = "";
                boolean isNeedRetryPull = false;
                if (lastTask.getTaskStatus().intValue() == FerryTaskStatusEnum.BEGIN_PULL.getCode()) {
                    log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u72b6\u6001\u662f\uff1a{}\uff0c\u6240\u4ee5\u9700\u8981\u91cd\u65b0\u62c9\u53d6", (Object)FerryTaskStatusEnum.BEGIN_PULL.getDefaultMessage());
                    isNeedRetryPull = true;
                } else {
                    log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u72b6\u6001\u662f\uff1a{}\uff0c\u4e0d\u7528\u9700\u8981\u91cd\u65b0\u62c9\u53d6\uff0c\u76f4\u63a5\u590d\u5236\u6446\u6e21\u5305\u5373\u53ef", (Object)FerryTaskStatusEnum.BEGIN_PULL.getDefaultMessage());
                    requestId = "" + this.snowflake.snowflakeId();
                    String oldZip = lastTask.getPackageUrl().concat(File.separator).concat(lastTask.getRequestId()).concat(".zip");
                    String newZip = lastTask.getPackageUrl().concat(File.separator).concat(requestId).concat(".zip");
                    FileUtil.copy((String)oldZip, (String)newZip, (boolean)true);
                    log.info("\u6587\u4ef6\u590d\u5236\u5b8c\u6210\uff0coldZip\uff1a{}, newZip\uff1a{}", (Object)oldZip, (Object)newZip);
                    if (lastTask.getRequestId().contains("zw")) {
                        requestId = requestId.concat("zw");
                    }
                }
                lastTask.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode()));
                lastTask.setFerryResult("\u521b\u5efa\u65f6\u95f4>=2\u5c0f\u65f6\uff0c\u8fdb\u884c\u8865\u507f\uff0c\u590d\u5236\u4e00\u4e2a\u4efb\u52a1\u51fa\u6765\uff0c\u91cd\u65b0\u6446\u6e21");
                lastTask.setUpdateTime(new Date());
                this.updateById((Object)lastTask);
                FerryTaskEntity ferryTaskEntity = new FerryTaskEntity();
                ferryTaskEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
                ferryTaskEntity.setRegionCode(regionCode);
                ferryTaskEntity.setStartTime(lastTask.getStartTime());
                ferryTaskEntity.setEndTime(lastTask.getEndTime());
                ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.BEGIN_PULL.getCode()));
                ferryTaskEntity.setCreateTime(nowTime);
                ferryTaskEntity.setUpdateTime(nowTime);
                if (!isNeedRetryPull) {
                    ferryTaskEntity.setRequestId(requestId);
                    ferryTaskEntity.setPackageUrl(lastTask.getPackageUrl());
                    ferryTaskEntity.setPullResult("retry_ferry");
                    ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.PULL_COMPLETE.getCode()));
                }
                this.save((Object)ferryTaskEntity);
                if (isNeedRetryPull) {
                    this.updateEndTimeFromPullResult(ferryTaskEntity);
                }
            } else {
                log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u521b\u5efa\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u5dee\uff1a{} \u6beb\u79d2\uff0c<2\u5c0f\u65f6\uff0c\u65e0\u9700\u8865\u507f", (Object)differenceTime);
            }
        } else {
            log.info("\u6700\u8fd1\u4e00\u6b21\u6446\u6e21\u4efb\u52a1\u5df2\u5b8c\u6210 || \u6ca1\u6709\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1");
            Date pullDataBeginTime = DateUtil.getMinuteZeroTime((Date)nowTime);
            int after = this.schedulingConfig.getCreateFerryTask().getTimeInterval();
            long intervalTime = 3600000L;
            if (lastTask != null) {
                pullDataBeginTime = lastTask.getEndTime();
                if (nowTime.getTime() - pullDataBeginTime.getTime() > intervalTime) {
                    log.info("\u6700\u8fd1\u4e00\u6b21\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u95f4\u9694>1\u5c0f\u65f6\uff0c\u9700\u8981\u7ffb\u500d\u62c9\u53d6", (Object)lastTask.getEndTime(), (Object)nowTime);
                    log.info("\u539f\u672c\u62c9\u53d6\uff1a{}\u5206\u949f", (Object)after);
                    log.info("\u73b0\u5728\u62c9\u53d6\uff1a{}\u5206\u949f", (Object)(after *= 2));
                }
            }
            Date pullDataEndTime = DateUtil.getAfterNumMinuteTime((Date)pullDataBeginTime, (int)after);
            log.info("\u65b0\u7684\u4efb\u52a1\u62c9\u53d6\u6570\u636e\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u62c9\u53d6\u6570\u636e\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)DateUtil.formatDateTime((Date)pullDataBeginTime), (Object)DateUtil.formatDateTime((Date)pullDataEndTime));
            if (pullDataEndTime.getTime() >= nowTime.getTime()) {
                log.info("\u65b0\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4 >= \u5f53\u524d\u65f6\u95f4\uff0c\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1\uff0c\u7b49\u5f85\u4e0b\u6b21\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8");
            } else {
                log.info("\u65b0\u4efb\u52a1\u7684\u7ed3\u675f\u65f6\u95f4 < \u5f53\u524d\u65f6\u95f4\uff0c\u53ef\u4ee5\u521b\u5efa\u65b0\u7684\u4efb\u52a1");
                FerryTaskEntity ferryTaskEntity = new FerryTaskEntity();
                ferryTaskEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
                ferryTaskEntity.setRegionCode(regionCode);
                ferryTaskEntity.setStartTime(DateUtil.getBeforeNumMinuteTime((Date)pullDataBeginTime, (int)1));
                ferryTaskEntity.setEndTime(pullDataEndTime);
                ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.BEGIN_PULL.getCode()));
                ferryTaskEntity.setCreateTime(nowTime);
                ferryTaskEntity.setUpdateTime(nowTime);
                this.save((Object)ferryTaskEntity);
                this.updateEndTimeFromPullResult(ferryTaskEntity);
            }
        }
    }

    @Transactional
    public void queryPullIsComplete() {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getTaskStatus, (Object)FerryTaskStatusEnum.BEGIN_PULL.getCode());
        lqw.isNull(FerryTaskEntity::getRequestId);
        lqw.isNull(FerryTaskEntity::getPackageUrl);
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryTaskEntity ferryTaskEntity : list) {
                try {
                    FerryTaskPullResult result = this.retryService.postToBaiduutilServerPullResult(ferryTaskEntity);
                    if (result.getTaskStatus() == null) continue;
                    FerryTaskEntity ferryTask = (FerryTaskEntity)this.getById((Serializable)result.getId());
                    if ("govout-to-govin".equals(ferryTask.getRegionCode()) || "govin-to-govout".equals(ferryTask.getRegionCode())) {
                        ferryTask.setRequestId(result.getRequestId().concat("zw"));
                    } else {
                        ferryTask.setRequestId(result.getRequestId());
                    }
                    ferryTask.setPackageUrl(result.getPackageUrl());
                    ferryTask.setPullResult(result.getPullResult());
                    ferryTask.setTaskStatus(result.getTaskStatus());
                    ferryTask.setUpdateTime(new Date());
                    this.updateById((Object)ferryTask);
                }
                catch (Exception e) {
                    log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u67e5\u8be2\u62c9\u53d6\u72b6\u6001\u51fa\u9519\uff0cregionCode\uff1a{}, requestId\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", new Object[]{ferryTaskEntity.getRegionCode(), ferryTaskEntity.getRequestId(), e.getMessage(), e});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void queryPullComplete() {
        Date nowTime = new Date();
        log.info("\u5f53\u524d\u65f6\u95f4\u6233\uff1a{}", (Object)nowTime.getTime());
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getTaskStatus, (Object)FerryTaskStatusEnum.PULL_COMPLETE.getCode());
        lqw.isNotNull(FerryTaskEntity::getRequestId);
        lqw.isNotNull(FerryTaskEntity::getPackageUrl);
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryTaskEntity ferryTaskEntity : list) {
                String lockKey = "REDISSON_LOCK_QUERY_FERRY_TASK_STATUS_" + ferryTaskEntity.getId().toString();
                log.info("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001-\u62c9\u53d6\u5b8c\u6210\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
                RLock lock = this.redissonClient.getLock(lockKey);
                lock.lock(900L, TimeUnit.SECONDS);
                log.info("\u53d6\u5230\u9501");
                try {
                    boolean isDownloadComplete = false;
                    String ferryPackageUrl = ferryTaskEntity.getPackageUrl().concat(File.separator).concat(ferryTaskEntity.getRequestId());
                    String zipPath = ferryPackageUrl.concat(".zip");
                    if (!ferryTaskEntity.getRegionCode().contains("gov") && !"retry_ferry".equals(ferryTaskEntity.getPullResult())) {
                        log.info("\u4e92\u8054\u7f51 && \u4e0d\u662f\u91cd\u8bd5\u6446\u6e21\uff0c\u9700\u8981\u4e0b\u8f7dzip\u5305");
                        boolean downloadFileResult = ObsUtil.downloadFile((String)zipPath, (String)zipPath.substring(zipPath.indexOf("baidu/")));
                        if (downloadFileResult) {
                            isDownloadComplete = true;
                        } else {
                            log.error("\u4e0b\u8f7d\u6446\u6e21\u5305\u5931\u8d25");
                        }
                    } else {
                        log.info("\u4e0d\u662f\u4e92\u8054\u7f51 || \u662f\u91cd\u8bd5\u6446\u6e21\uff0c\u4e0d\u9700\u8981\u9700\u8981\u4e0b\u8f7dzip\u5305");
                        isDownloadComplete = true;
                        if (zipPath.contains("zw")) {
                            log.info("\u5982\u679c\u662f\u6446\u6e21\u5230\u653f\u52a1\u7f51\u7684\uff0c\u6216\u8005\u653f\u52a1\u7f51\u62c9\u53d6\u7684\uff0c\u6446\u6e21\u5305\u6587\u4ef6\u9700\u8981\u589e\u52a0zw");
                            File file = new File(zipPath.replace("zw", ""));
                            FileUtil.copy((File)file, (File)new File(zipPath), (boolean)true);
                        }
                    }
                    if (!isDownloadComplete) continue;
                    log.info("\u5f00\u59cb\u590d\u5236\u6587\u4ef6\u5230\u76ee\u6807\u670d\u52a1\u5668\u4e0a");
                    String targetFilePath = this.ferryChannelConfig.getSendPath().concat(File.separator).concat(DateUtil.formatDate((Date)nowTime)).concat(File.separator).concat(ferryTaskEntity.getRequestId()).concat(".zip");
                    this.copyFileToFerryChannel(zipPath, targetFilePath);
                    if (this.ferrySwitchConfig.getWaitLastTask() != null && this.ferrySwitchConfig.getWaitLastTask().booleanValue()) {
                        log.info("\u9700\u8981\u7b49\u5f85\u4e0a\u4e2a\u6446\u6e21\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u518d\u7ee7\u7eed\u6446\u6e21\u4e0b\u4e00\u4e2a\u4efb\u52a1\uff0c\u4efb\u52a1\u72b6\u6001\u6539\u4e3a\uff1a{}", (Object)FerryTaskStatusEnum.PUT_SEND_COMPLETE.getDefaultMessage());
                        ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.PUT_SEND_COMPLETE.getCode()));
                    } else {
                        log.info("\u4e0d\u9700\u8981\u7b49\u5f85\u4e0a\u4e2a\u6446\u6e21\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u518d\u7ee7\u7eed\u6446\u6e21\u4e0b\u4e00\u4e2a\u4efb\u52a1\uff0c\u4efb\u52a1\u72b6\u6001\u6539\u4e3a\uff1a{}", (Object)FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getDefaultMessage());
                        ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode()));
                    }
                    ferryTaskEntity.setUpdateTime(nowTime);
                    this.updateById((Object)ferryTaskEntity);
                    log.info("\u590d\u5236\u6587\u4ef6\u7ed3\u675f");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001-\u62c9\u53d6\u5b8c\u6210\u4efb\u52a1\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    if (lock.isLocked()) {
                        lock.unlock();
                    }
                    log.info("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001-\u62c9\u53d6\u5b8c\u6210\u4efb\u52a1\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
                }
            }
        } else {
            log.info("\u6ca1\u6709\u62c9\u53d6\u5b8c\u6210\u7684\u4efb\u52a1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void queryPutSendComplete() {
        Date nowTime = new Date();
        log.info("\u5f53\u524d\u65f6\u95f4\u6233\uff1a{}", (Object)nowTime.getTime());
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getTaskStatus, (Object)FerryTaskStatusEnum.PUT_SEND_COMPLETE.getCode());
        lqw.orderByDesc(FerryTaskEntity::getCreateTime);
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryTaskEntity ferryTaskEntity : list) {
                String lockKey = "REDISSON_LOCK_QUERY_FERRY_TASK_STATUS_" + ferryTaskEntity.getId().toString();
                log.info("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001-\u653e\u5165\u53d1\u9001\u6587\u4ef6\u5939\u5b8c\u6210\u4efb\u52a1\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
                RLock lock = this.redissonClient.getLock(lockKey);
                lock.lock(900L, TimeUnit.SECONDS);
                log.info("\u53d6\u5230\u9501");
                try {
                    log.info("\u4efb\u52a1tasId\uff1a{}", (Object)ferryTaskEntity.getId());
                    FerryTaskEntity task = (FerryTaskEntity)this.getById((Serializable)ferryTaskEntity.getId());
                    if (task.getTaskStatus().intValue() == FerryTaskStatusEnum.PUT_SEND_COMPLETE.getCode() && nowTime.getTime() - task.getUpdateTime().getTime() > 3600000L) {
                        log.info("\u5f00\u59cb\u91cd\u65b0\u4f20\u8f93\u6587\u4ef6");
                        String zipPath = task.getPackageUrl().concat(File.separator).concat(task.getRequestId()).concat(".zip");
                        String targetFilePath = this.ferryChannelConfig.getSendPath().concat(File.separator).concat(DateUtil.formatDate((Date)task.getUpdateTime())).concat(File.separator).concat(task.getRequestId()).concat(".zip");
                        this.copyFileToFerryChannel(zipPath, targetFilePath);
                        log.info("\u91cd\u65b0\u4f20\u8f93\u6587\u4ef6\u7ed3\u675f");
                        continue;
                    }
                    log.info("\u4efb\u52a1tasId\uff1a{}\uff0c\u5df2\u7ecf\u5b8c\u6210\u4e86\uff0c\u4e0d\u9700\u8981\u91cd\u65b0\u4f20\u8f93\u6587\u4ef6", (Object)ferryTaskEntity.getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001-\u653e\u5165\u53d1\u9001\u6587\u4ef6\u5939\u5b8c\u6210\u4efb\u52a1\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    if (lock.isLocked()) {
                        lock.unlock();
                    }
                    log.info("\u67e5\u8be2\u6446\u6e21\u4efb\u52a1\u72b6\u6001-\u653e\u5165\u53d1\u9001\u6587\u4ef6\u5939\u5b8c\u6210\u4efb\u52a1\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
                }
            }
        } else {
            log.info("\u6ca1\u6709\u653e\u5165\u53d1\u9001\u6587\u4ef6\u5939\u5b8c\u6210\u7684\u4efb\u52a1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileToFerryChannel(String sourceFilePath, String targetFilePath) {
        if (StringUtils.isNotBlank((CharSequence)this.ferryChannelConfig.getTargetType()) && "local".equals(this.ferryChannelConfig.getTargetType())) {
            log.info("\u901a\u9053\u5728\u672c\u673a");
            FileUtil.copy((String)sourceFilePath, (String)targetFilePath, (boolean)true);
            log.info("\u590d\u5236\u6587\u4ef6\u5230\u901a\u9053\u6587\u4ef6\u5939\u5b8c\u6210");
        } else {
            log.info("\u901a\u9053\u5728\u5176\u4ed6\u670d\u52a1\u5668");
            StringBuilder result = new StringBuilder("");
            Process process = null;
            InputStream ins = null;
            String command = String.format("scp -P %s %s %s@%s:%s", this.ferryChannelConfig.getTargetPort(), sourceFilePath, this.ferryChannelConfig.getTargetUsername(), this.ferryChannelConfig.getTargetIp(), targetFilePath);
            log.info("\u901a\u8fc7\u547d\u4ee4\u884c\u6267\u884cshell\u811a\u672c\uff0c\u547d\u4ee4\uff1a{}", (Object)command);
            try {
                process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
                process.waitFor();
                ins = process.getErrorStream();
                byte[] b = new byte[100];
                int num = 0;
                while ((num = ins.read(b)) != -1) {
                    result.append(new String(b, "gb2312"));
                }
                log.info("\u901a\u8fc7\u547d\u4ee4\u884c\u6267\u884cshell\u811a\u672c\uff0c\u547d\u4ee4\uff1a{}\uff0c\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)command, (Object)result);
            }
            catch (Exception e) {
                log.error("\u547d\u4ee4\u884c\u6267\u884c\u811a\u672c\u5931\u8d25\uff0ccommand\uff1a{}\uff0c{}", new Object[]{command, e.getMessage(), e});
                e.printStackTrace();
            }
            finally {
                try {
                    assert (ins != null);
                    ins.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                process.destroy();
            }
        }
    }

    @Transactional
    public void updateFerryTaskComplete(String requestId) {
        FerryTaskEntity ferryTaskEntity;
        log.info("\u4fee\u6539\u6446\u6e21\u4efb\u52a1\u5b8c\u6210\uff0crequestId\uff1a{}", (Object)requestId);
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryTaskEntity::getRequestId, (Object)requestId);
        lqw.last("limit 1");
        List list = lqw.list();
        FerryTaskEntity ferryTaskEntity2 = ferryTaskEntity = CollectionUtil.isNotEmpty((Collection)list) ? (FerryTaskEntity)list.get(0) : null;
        if (ferryTaskEntity != null) {
            ferryTaskEntity.setTaskStatus(Integer.valueOf(FerryTaskStatusEnum.FERRY_TASK_COMPLETE.getCode()));
            ferryTaskEntity.setFerryResult("\u6446\u6e21\u5b8c\u6210");
            ferryTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)ferryTaskEntity);
        }
    }

    private void updateEndTimeFromPullResult(FerryTaskEntity ferryTaskEntity) {
        ChangeLogsRequestDto changeLogsRequestDto = this.retryService.postToBaiduutilServerPull(ferryTaskEntity);
        if (changeLogsRequestDto != null) {
            ferryTaskEntity.setEndTime(changeLogsRequestDto.getEndTime());
            ferryTaskEntity.setPullResult("\u6839\u636e\u6446\u6e21\u4efb\u52a1\uff0c\u66f4\u65b0\u670d\u52a1\u5668\u65f6\u95f4\u4e3a\u7ed3\u675f\u65f6\u95f4");
            this.updateById((Object)ferryTaskEntity);
            log.info("\u6839\u636e\u6446\u6e21\u4efb\u52a1\uff0c\u66f4\u65b0\u7ed3\u675f\u65f6\u95f4\uff0cferryTaskEntity\uff1a{}", (Object)ferryTaskEntity);
        }
    }
}

