/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class QueryReceiveTaskComplete {
    private static final Logger log = LoggerFactory.getLogger(QueryReceiveTaskComplete.class);
    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;

    @Scheduled(cron="${scheduling-config.query-receive-task-complete.cron}")
    public void queryReceiveTaskComplete() {
        log.info("===================================\u5b9a\u65f6\u67e5\u8be2\u63a5\u6536\u4efb\u52a1\u72b6\u6001-\u6446\u6e21\u5b8c\u6210===================================");
        this.ferryReceiveTaskService.queryReceiveTaskIsComplete();
        List ferryReceiveTaskList = this.ferryReceiveTaskService.queryReceiveTaskComplete();
        if (CollectionUtil.isNotEmpty((Collection)ferryReceiveTaskList)) {
            for (FerryReceiveTaskEntity receiveTaskEntity : ferryReceiveTaskList) {
                try {
                    this.ferryReceiveTaskService.sendCompleteFile(receiveTaskEntity);
                }
                catch (Exception e) {
                    log.error("\u751f\u6210.complete\u6587\u4ef6\uff0c\u5e76\u56de\u8c03\u51fa\u9519\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        log.info("===================================\u67e5\u8be2\u63a5\u6536\u4efb\u52a1\u72b6\u6001-\u6446\u6e21\u5b8c\u6210\u7ed3\u675f===================================");
    }
}

