/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import com.bcxin.ferry.common.emus.FerryReceiveTaskStatusEnum;
import com.bcxin.ferry.common.utils.ObsUtil;
import com.bcxin.ferry.configs.ReceiveConfig;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import com.bcxin.ferry.service.FerryTaskService;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DetectionReceiveFile {
    private static final Logger log = LoggerFactory.getLogger(DetectionReceiveFile.class);
    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Autowired
    private ReceiveConfig receiveConfig;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private FerryTaskService ferryTaskService;
    @Value(value="${spring.profiles.active}")
    private String activeFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${scheduling-config.detection-receive-file.cron}")
    public void detectionReceiveFile() {
        log.info("===================================\u5b9a\u65f6\u68c0\u6d4b\u63a5\u6536\u6446\u6e21\u6587\u4ef6===================================");
        String lockKey = "REDISSON_LOCK_DETECTION_RECEIVE_FILE";
        log.info("\u68c0\u6d4b\u63a5\u6536\u6446\u6e21\u6587\u4ef6\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(900L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            List fileList = FileUtil.loopFiles((String)this.receiveConfig.getDetectionUrl());
            if (CollectionUtil.isNotEmpty((Collection)fileList)) {
                log.info("\u68c0\u6d4b\u5230\u65b0\u6587\u4ef6\uff0c\u4e2a\u6570\uff1a{}", (Object)fileList.size());
                for (File file : fileList) {
                    String fileName = file.getName();
                    try {
                        log.info("\u65b0\u6587\u4ef6\uff0cfileName\uff1a{}", (Object)fileName);
                        String requestId = fileName.substring(0, fileName.indexOf("."));
                        log.info("\u65b0\u6587\u4ef6\uff0crequestId\uff1a{}", (Object)requestId);
                        if (fileName.contains(".complete")) {
                            log.info("\u6446\u6e21\u4efb\u52a1\u6267\u884c\u6210\u529f\u901a\u77e5");
                            this.ferryTaskService.updateFerryTaskComplete(requestId);
                        } else {
                            FerryReceiveTaskEntity ferryReceiveTaskEntity = this.ferryReceiveTaskService.receiveRequest(requestId);
                            if (ferryReceiveTaskEntity.getTaskStatus().intValue() == FerryReceiveTaskStatusEnum.RECEIVE_REQUEST.getCode()) {
                                log.info("requestId\uff1a{}\uff0c\u662f\u65b0\u589e\u63a5\u6536\u4efb\u52a1", (Object)requestId);
                                if (this.activeFile.contains("out")) {
                                    log.info("\u653f\u52a1\u63a5\u6536\u6587\u4ef6\u540e");
                                    if (requestId.contains("zw")) {
                                        log.info("\u6446\u6e21\u5230\u653f\u52a1\u7f51\uff0c\u4e5f\u662f\u76f4\u63a5\u590d\u5236");
                                        FileUtil.copy((File)file, (File)new File(ferryReceiveTaskEntity.getPackageUrl()), (boolean)true);
                                    } else {
                                        log.info("\u6446\u6e21\u5230\u4e92\u8054\u7f51\uff0c\u9700\u8981\u4e0a\u4f20obs");
                                        ObsUtil.uploadFile((File)file, (String)"baidu/push/".concat(fileName));
                                    }
                                } else {
                                    log.info("\u5185\u7f51\u63a5\u6536\u6587\u4ef6\u540e\uff0c\u76f4\u63a5\u590d\u5236");
                                    FileUtil.copy((File)file, (File)new File(ferryReceiveTaskEntity.getPackageUrl()), (boolean)true);
                                }
                                log.info("\u6267\u884c\u63a8\u9001\u6570\u636e");
                                this.ferryReceiveTaskService.pushData(ferryReceiveTaskEntity);
                            } else if (ferryReceiveTaskEntity.getTaskStatus().intValue() == FerryReceiveTaskStatusEnum.FERRY_COMPLETE.getCode() || ferryReceiveTaskEntity.getTaskStatus().intValue() == FerryReceiveTaskStatusEnum.CALLBACK_COMPLETE.getCode()) {
                                log.info("requestId\uff1a{}\uff0c\u662f\u5df2\u63a5\u6536\u4efb\u52a1\uff0c\u9700\u8981\u91cd\u65b0\u8fd4\u56decomplete\u6587\u4ef6", (Object)requestId);
                                this.ferryReceiveTaskService.sendCompleteFile(ferryReceiveTaskEntity);
                            } else {
                                log.info("requestId\uff1a{}\uff0c\u672a\u5b8c\u6210\u6446\u6e21\uff0c\u8df3\u8fc7", (Object)requestId);
                            }
                        }
                        FileUtil.del((File)file);
                    }
                    catch (Exception e) {
                        log.error("\u68c0\u6d4b\u6587\u4ef6\uff1a{}\uff0c\u51fa\u9519\uff0c{}", new Object[]{fileName, e.getMessage(), e});
                    }
                }
            } else {
                log.info("\u65e0\u65b0\u6446\u6e21\u8fdb\u6765\u7684\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u68c0\u6d4b\u63a5\u6536\u6446\u6e21\u6587\u4ef6\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u68c0\u6d4b\u63a5\u6536\u6446\u6e21\u6587\u4ef6\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
        log.info("===================================\u5b9a\u65f6\u68c0\u6d4b\u63a5\u6536\u6446\u6e21\u6587\u4ef6\u7ed3\u675f===================================");
    }
}

