/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.dtos.response.result;

import com.bcxin.ferry.common.emus.StatusCode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRespResult {
    private int code;
    private long timestamp;
    private String msg;

    protected AbstractRespResult() {
        this.code = StatusCode.succeed.getCode();
        this.msg = StatusCode.succeed.getDefaultMessage();
        this.timestamp = System.currentTimeMillis();
    }

    protected AbstractRespResult(int code, String message) {
        this.code = code;
        this.msg = StringUtils.isBlank((CharSequence)message) ? "" : message;
        this.timestamp = System.currentTimeMillis();
    }

    protected AbstractRespResult(StatusCode statusCode, String message) {
        if (statusCode == null) {
            statusCode = StatusCode.succeed;
        }
        this.code = statusCode.getCode();
        this.msg = StringUtils.isBlank((CharSequence)message) ? statusCode.getDefaultMessage() : message;
        this.timestamp = System.currentTimeMillis();
    }

    @JsonIgnore
    public boolean isSucceed() {
        return this.code == StatusCode.succeed.getCode();
    }

    public int getCode() {
        return this.code;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMsg() {
        return this.msg;
    }
}

