/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.common.utils;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdGeneratorSnowflake {
    private static final Logger log = LoggerFactory.getLogger(IdGeneratorSnowflake.class);
    private long workerId = 0L;
    private final long datacenterId = 1L;
    private final Snowflake snowflake = IdUtil.getSnowflake((long)this.workerId, (long)1L);

    @PostConstruct
    public void init() {
        try {
            this.workerId = NetUtil.ipv4ToLong((String)NetUtil.getLocalhostStr());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized long snowflakeId() {
        long id = this.snowflake.nextId();
        long random = RandomUtil.randomLong((long)1L, (long)1000L);
        return id + random;
    }

    public synchronized long snowflakeId(long workerId, long datacenterId) {
        Snowflake snowflake = IdUtil.getSnowflake((long)workerId, (long)datacenterId);
        return snowflake.nextId();
    }
}

