/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.common.exception;

import cn.hutool.core.bean.BeanException;
import cn.hutool.core.convert.ConvertException;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.emus.StatusCode;
import com.bcxin.ferry.common.exception.AssertException;
import com.bcxin.ferry.common.exception.RemoteException;
import com.bcxin.ferry.common.exception.TaskException;
import com.bcxin.ferry.common.exception.TokenException;
import com.bcxin.ferry.common.exception.ValidatedException;
import com.bcxin.ferry.common.utils.ExceptionUtils;
import com.bcxin.ferry.dtos.response.result.ErrorRespResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.SignatureException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ErrorRespResult noFoundException(HttpServletRequest request, NoHandlerFoundException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.notfound, "\u8bbf\u95ee\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
    }

    private ErrorRespResult packageResponse(HttpServletRequest request, Exception ex, StatusCode statusCode, String errorMessage) {
        this.printMessage(request, (Throwable)ex);
        this.saveMessage(request, (Throwable)ex);
        return ErrorRespResult.fail((StatusCode)statusCode, (String)errorMessage, (String)this.printDebugMessage(request, (Throwable)ex));
    }

    private void printMessage(HttpServletRequest request, Throwable ex) {
        String path = request.getRequestURI();
        if (ex == null) {
            logger.error("\u5168\u5c40\u5f02\u5e38\uff1apath:[{}] - [\u672a\u77e5\u5f02\u5e38]\u3002", (Object)path);
            return;
        }
        String className = ex.getClass().getName();
        logger.error("\u5168\u5c40\u5f02\u5e38\uff1apath:[{}] - class:[{}] - ex:[{}] ", new Object[]{path, className, ex.getMessage()});
    }

    private void saveMessage(HttpServletRequest request, Throwable ex) {
        String body = "";
        BufferedReader reader = null;
        try {
            String line;
            reader = request.getReader();
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            body = stringBuilder.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String printDebugMessage(HttpServletRequest request, Throwable ex) {
        String path = request.getRequestURI();
        HashMap<String, String> debugMsg = new HashMap<String, String>();
        debugMsg.put("path", path);
        debugMsg.put("exception", ExceptionUtils.getExceptionMessage((Throwable)ex));
        return JSONObject.toJSONString(debugMsg);
    }

    @ExceptionHandler(value={ArrayIndexOutOfBoundsException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult arrayIndexOutOfBoundsException(HttpServletRequest request, ArrayIndexOutOfBoundsException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef:\u4e1a\u52a1\u6240\u9700\u6570\u636e\u5bf9\u8c61\u5904\u7406\u9519\u8bef");
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult httpMessageNotReadableException(HttpServletRequest request, HttpMessageNotReadableException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.parameterError, "\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult bindException(HttpServletRequest request, BindException ex) {
        BindingResult bindingResult = ex.getBindingResult();
        return this.validException(request, (Exception)ex, bindingResult);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult validationException(HttpServletRequest request, ValidationException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef:\u6570\u636e\u6821\u9a8c\u5668\u6267\u884c\u9519\u8bef");
    }

    @ExceptionHandler(value={ConvertException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult convertException(HttpServletRequest request, ConvertException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef:\u81ea\u52a8\u6570\u636e\u8f6c\u6362\u9519\u8bef");
    }

    @ExceptionHandler(value={BeanException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult beanException(HttpServletRequest request, BeanException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef:\u4e1a\u52a1\u5904\u7406\u8d44\u6e90\u7f3a\u5931");
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult ioException(HttpServletRequest request, IOException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "IO\u6d41\u64cd\u4f5c\u5f02\u5e38");
    }

    @ExceptionHandler(value={TokenException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ErrorRespResult tokenException(HttpServletRequest request, TokenException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.tokenError, "\u9519\u8bef\u7684\u7528\u6237\u4ee4\u724c");
    }

    @ExceptionHandler(value={AssertException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult assertException(HttpServletRequest request, AssertException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.assertError, ex.getMessage());
    }

    @ExceptionHandler(value={TaskException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult taskException(HttpServletRequest request, TaskException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, ex.getMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult nullPointerException(HttpServletRequest request, NullPointerException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.assertError, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef:\u4e1a\u52a1\u5904\u7406\u6240\u9700\u8d44\u6e90\u7f3a\u5931\uff08NP\uff09");
    }

    @ExceptionHandler(value={ValidatedException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult validatedException(HttpServletRequest request, ValidatedException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.parameterError, ex.getMessage());
    }

    @ExceptionHandler(value={IllegalAccessException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult illegalAccessException(HttpServletRequest request, IllegalAccessException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.assertError, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef:\u672a\u6388\u6743\u4e1a\u52a1\u5bf9\u8c61\u8bbf\u95ee\u6743\u9650");
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult constraintViolationException(HttpServletRequest request, ConstraintViolationException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.parameterError, "\u53c2\u6570\u6821\u9a8c\u9519\u8bef");
    }

    @ExceptionHandler(value={CannotGetJdbcConnectionException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult cannotGetJdbcConnectionException(HttpServletRequest request, CannotGetJdbcConnectionException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
    }

    @ExceptionHandler(value={SQLNonTransientConnectionException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult sqlNonTransientConnectionException(HttpServletRequest request, SQLNonTransientConnectionException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
    }

    @ExceptionHandler(value={SQLIntegrityConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult integrityConstraintViolationException(HttpServletRequest request, SQLIntegrityConstraintViolationException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult dataIntegrityViolationException(HttpServletRequest request, DataIntegrityViolationException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
    }

    @ExceptionHandler(value={DataAccessException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult dataAccessException(HttpServletRequest request, DataAccessException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.serviceError, "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult illegalArgumentException(HttpServletRequest request, IllegalArgumentException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.parameterError, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef:\u4e1a\u52a1\u5904\u7406\u6240\u9700\u53c2\u6570\u9519\u8bef");
    }

    @ExceptionHandler(value={SignatureException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult signatureException(HttpServletRequest request, SignatureException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.signatureError, "\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
    }

    @ExceptionHandler(value={NoSuchMethodException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ErrorRespResult noSuchMethodException(HttpServletRequest request, NoSuchMethodException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.notfound, "\u8bbf\u95ee\u7684\u8d44\u6e90\u4e0d\u5b58\u5728\uff08404\uff09");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult httpRequestMethodNotSupportedException(HttpServletRequest request, HttpRequestMethodNotSupportedException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.methodNotAllowed, "\u9519\u8bef\u7684\u8bf7\u6c42\u65b9\u5f0f");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult methodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException ex) {
        BindingResult bindingResult = ex.getBindingResult();
        return this.validException(request, (Exception)ex, bindingResult);
    }

    private ErrorRespResult validException(HttpServletRequest request, Exception ex, BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            return ErrorRespResult.fail((StatusCode)StatusCode.parameterError, (String)"\u53c2\u6570\u6821\u9a8c\u5931\u8d25\u3002");
        }
        List fieldErrorList = bindingResult.getFieldErrors();
        StringBuilder info = new StringBuilder("\u53c2\u6570\u6821\u9a8c\u5931\u8d25:");
        boolean hasMoreError = fieldErrorList.size() > 1;
        for (int i = 0; i < fieldErrorList.size(); ++i) {
            if (hasMoreError) {
                info.append(i + 1).append(":");
            }
            if (StringUtils.isBlank((CharSequence)((FieldError)fieldErrorList.get(i)).getDefaultMessage())) continue;
            if (((FieldError)fieldErrorList.get(i)).getDefaultMessage().startsWith("Failed to convert")) {
                info.append("\u53c2\u6570\u7c7b\u578b\u9519\u8bef\u3002");
                continue;
            }
            info.append(((FieldError)fieldErrorList.get(i)).getDefaultMessage());
            if (((FieldError)fieldErrorList.get(i)).getDefaultMessage().endsWith("\u3002")) continue;
            info.append("\u3002");
        }
        return this.packageResponse(request, ex, StatusCode.parameterError, info.toString());
    }

    @ExceptionHandler(value={RemoteException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult remoteException(HttpServletRequest request, RemoteException ex) {
        return this.packageResponse(request, (Exception)ex, StatusCode.remoteError, ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult exception(HttpServletRequest request, Exception exception) {
        return this.otherException(request, exception);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ErrorRespResult runtimeException(HttpServletRequest request, Exception exception) {
        return this.otherException(request, exception);
    }

    private ErrorRespResult otherException(HttpServletRequest request, Exception exception) {
        if (exception == null) {
            return ErrorRespResult.fail((StatusCode)StatusCode.unknown, (String)"\u672a\u77e5\u9519\u8bef\uff08\u9519\u8bef\u4fe1\u606f\u7f3a\u5931\uff09\u3002");
        }
        logger.error("\u672a\u77e5\u9519\u8bef\uff1a[{}]", (Object)exception.getClass().getName());
        String clazz = exception.getClass().getName();
        if (clazz.startsWith("java.sql")) {
            return this.packageResponse(request, exception, StatusCode.serviceError, "\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38");
        }
        return this.packageResponse(request, exception, StatusCode.unknown, String.format("\u672a\u77e5\u9519\u8bef\uff1a[%s]", exception.getMessage()));
    }
}

