/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.common.exception;

import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRuntimeException
extends RuntimeException {
    private String detailMessage;

    public AbstractRuntimeException(String detailMessage) {
        this.detailMessage = detailMessage;
    }

    public AbstractRuntimeException(Throwable e) {
        super(e);
        if (e != null) {
            this.detailMessage = e.getMessage();
        }
    }

    public AbstractRuntimeException(String detailMessage, Throwable e) {
        super(e);
        this.detailMessage = detailMessage;
    }

    public AbstractRuntimeException(String detailMessageFormat, Object ... args) {
        this.detailMessage = this.formatMessage(detailMessageFormat, args);
    }

    public AbstractRuntimeException(Throwable e, String detailMessageFormat, Object ... args) {
        super(e);
        this.detailMessage = this.formatMessage(detailMessageFormat, args);
    }

    protected static boolean isSubClass(Object subObject, Class<?> parentClass) {
        if (subObject == null || parentClass == null) {
            return false;
        }
        return parentClass.isAssignableFrom(subObject.getClass());
    }

    private String formatMessage(String detailMessageFormat, Object ... args) {
        try {
            if (StringUtils.isBlank((CharSequence)detailMessageFormat)) {
                return "";
            }
            if (args == null || args.length == 0) {
                return detailMessageFormat;
            }
            return String.format(detailMessageFormat, args);
        }
        catch (Exception e) {
            return StringUtils.isNotBlank((CharSequence)detailMessageFormat) ? detailMessageFormat : "";
        }
    }

    @Override
    public String getMessage() {
        return this.detailMessage;
    }
}

