package com.bcxin.ferry.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * description：查询接收任务状态-摆渡完成
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class QueryReceiveTaskComplete {

    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;

    @Scheduled(cron = "${scheduling-config.query-receive-task-complete.cron}")
    public void queryReceiveTaskComplete() {
        log.info("===================================定时查询接收任务状态-摆渡完成===================================");
        //查询摆渡工具服务是否推送完成
        ferryReceiveTaskService.queryReceiveTaskIsComplete();
        //查询是否有接收明细文件完成的任务
        List<FerryReceiveTaskEntity> ferryReceiveTaskList = ferryReceiveTaskService.queryReceiveTaskComplete();
        if (CollectionUtil.isNotEmpty(ferryReceiveTaskList)) {
            for (FerryReceiveTaskEntity receiveTaskEntity : ferryReceiveTaskList) {
                //回调
                try {
                    ferryReceiveTaskService.sendCompleteFile(receiveTaskEntity);
                } catch (Exception e) {
                    log.error("生成.complete文件，并回调出错，{}", e.getMessage(), e);
                }
            }
        }
        log.info("===================================查询接收任务状态-摆渡完成结束===================================");
    }

}
