CREATE TABLE `ferry_task` (
      `id` bigint(20) NOT NULL COMMENT '主键id',
      `request_id` varchar(50) DEFAULT NULL COMMENT '请求id',
      `region_code` varchar(50) DEFAULT NULL COMMENT '区域代码',
      `start_time` datetime DEFAULT NULL COMMENT '拉取开始时间',
      `end_time` datetime DEFAULT NULL COMMENT '拉取结束时间',
      `package_url` varchar(255) DEFAULT NULL COMMENT '摆渡包文件目录url',
      `pull_result` mediumtext COMMENT '拉取结果',
      `file_total_count` int(11) DEFAULT NULL COMMENT '文件总数',
      `file_ferry_count` int(11) DEFAULT NULL COMMENT '文件已摆渡总数',
      `task_status` tinyint(4) DEFAULT NULL COMMENT '摆渡任务状态，1-开始拉取，2-拉取完成，3-扫描摆渡文件完成，4-生成任务文件完成，5-摆渡任务文件开始，6-摆渡任务文件完成，7-摆渡明细文件开始，8-摆渡明细文件结束，9-摆渡任务完成，-1-摆渡失败',
      `ferry_result` mediumtext COMMENT '摆渡结果',
      `create_time` datetime DEFAULT NULL COMMENT '创建时间',
      `update_time` datetime DEFAULT NULL COMMENT '更新时间',
      PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='摆渡任务表';

CREATE TABLE `ferry_receive_task` (
      `id` bigint(20) NOT NULL COMMENT '主键id',
      `ferry_task_id` bigint(20) DEFAULT NULL COMMENT '摆渡任务id',
      `request_id` varchar(30) DEFAULT NULL COMMENT '请求id',
      `package_url` varchar(255) DEFAULT NULL COMMENT '摆渡包文件目录url',
      `file_total_count` int(11) DEFAULT NULL COMMENT '文件总数',
      `file_receive_count` int(11) DEFAULT NULL COMMENT '文件已接收总数',
      `task_status` tinyint(4) DEFAULT NULL COMMENT '接收任务状态，1-接收请求，2-解析任务文件，3-初始化任务信息，4-回调请求端，5-接收明细文件开始，6-接收明细文件完成，7-合并文件开始，8-合并文件完成，9-执行推送操作，10-摆渡完成，11-回调完成',
      `receive_result` mediumtext COMMENT '接收结果',
      `create_time` datetime DEFAULT NULL COMMENT '创建时间',
      `update_time` datetime DEFAULT NULL COMMENT '更新时间',
      PRIMARY KEY (`id`),
      KEY `index_ferry_receive_task_ferry_task_id` (`ferry_task_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='接收任务表';

