/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.ExamEnrollmentCriteriaEntity;
import com.bcxin.tenant.bcx.domains.entities.MetaModuleEntity;
import com.bcxin.tenant.bcx.domains.repositories.ExamEnrollmentCriteriaRepository;
import com.bcxin.tenant.bcx.domains.repositories.MetaModuleRepository;
import com.bcxin.tenant.bcx.domains.services.ExamEnrollmentCriteriaService;
import com.bcxin.tenant.bcx.domains.services.MetaPageService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.ExamEnrollmentCriterias.CreateExamEnrollmentCriteriaCommand;
import com.bcxin.tenant.bcx.domains.services.commands.ExamEnrollmentCriterias.UpdateExamEnrollmentCriteriaCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.CreateMetaPageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.UpdateMetaPageCommand;
import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ForbidTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.UnAuthorizedTenantException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExamEnrollmentCriteriaServiceImpl
implements ExamEnrollmentCriteriaService {
    private static final Logger logger = LoggerFactory.getLogger(ExamEnrollmentCriteriaServiceImpl.class);
    private final MetaPageService metaPageService;
    private final ExamEnrollmentCriteriaRepository examEnrollmentCriteriaRepository;
    private final MetaModuleRepository moduleRepository;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public ExamEnrollmentCriteriaServiceImpl(MetaPageService metaPageService, ExamEnrollmentCriteriaRepository examEnrollmentCriteriaRepository, MetaModuleRepository moduleRepository, UnitWork unitWork, IdWorker idWorker) {
        this.metaPageService = metaPageService;
        this.examEnrollmentCriteriaRepository = examEnrollmentCriteriaRepository;
        this.moduleRepository = moduleRepository;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    @Override
    public String dispatch(CreateExamEnrollmentCriteriaCommand command) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        MetaModuleEntity moduleEntity = (MetaModuleEntity)this.moduleRepository.getById("000000000000000002");
        if (moduleEntity == null) {
            throw new ForbidTenantException("\u627e\u4e0d\u5230\u6b64\u7cfb\u7edf\u6a21\u5757, \u65e0\u6cd5\u8fdb\u884c\u81ea\u5b9a\u4e49\u62a5\u540d\u6761\u4ef6\u9875\u9762\u521b\u5efa");
        }
        if (!moduleEntity.getProjectId().equals("1")) {
            throw new ForbidTenantException("\u627e\u4e0d\u5230\u6b64\u7cfb\u7edf\u9879\u76ee");
        }
        AtomicReference pageId = new AtomicReference();
        this.unitWork.executeTran(() -> {
            String id = this.metaPageService.dispatch(CreateMetaPageCommand.create("1", "000000000000000002", command.getName(), command.getNote(), command.getDefaultFormJson(), command.getSlug(), command.getLogo(), PageType.Form, PageBusinessType.ExamEnrollmentCriteria, "dynamic_exam_enrollment_00001", command.isEnableBPMFlow(), command.isEnableAnonymousAccess(), command.isSync2Identity(), command.getBeginTime(), command.getEndTime(), command.getAttachment(), command.getLimitedCount()));
            pageId.set(id);
            ExamEnrollmentCriteriaEntity entity = ExamEnrollmentCriteriaEntity.create((String)pageId.get(), command.getSubjectType(), command.getSubjectNumber(), userModel);
            entity.change(command.getName(), command.getNote(), userModel);
            this.examEnrollmentCriteriaRepository.insert(entity);
        });
        return (String)pageId.get();
    }

    @Override
    public void dispatch(UpdateExamEnrollmentCriteriaCommand command) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        ExamEnrollmentCriteriaEntity entity = (ExamEnrollmentCriteriaEntity)this.examEnrollmentCriteriaRepository.getById(command.getId());
        if (entity == null) {
            throw new UnAuthorizedTenantException();
        }
        if (!entity.getReferenceNumber().equalsIgnoreCase(userModel.getOrganizationId())) {
            throw new ForbidTenantException(String.format("\u4e0d\u5141\u8bb8\u64cd\u4f5c\u975e\u672c\u7ec4\u7ec7(%s)\u7684\u6570\u636e(%s)", userModel.getOrganizationId(), entity.getReferenceNumber()));
        }
        this.unitWork.executeTran(() -> {
            entity.change(command.getName(), command.getNote(), userModel);
            this.examEnrollmentCriteriaRepository.update(entity);
            this.metaPageService.dispatch(UpdateMetaPageCommand.create(entity.getId(), command.getName(), command.getNote(), command.getSlug(), command.getLogo(), PageType.Form, PageBusinessType.ExamEnrollmentCriteria, "dynamic_exam_enrollment_00001", command.isEnableBPMFlow(), command.isEnableAnonymousAccess(), command.isSync2Identity(), command.getBeginTime(), command.getEndTime(), command.getAttachment(), command.getLimitedCount()));
        });
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        ExamEnrollmentCriteriaEntity entity = (ExamEnrollmentCriteriaEntity)this.examEnrollmentCriteriaRepository.getById(command.getId());
        if (entity == null) {
            throw new NoFoundTenantException();
        }
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        if (!userModel.getOrganizationId().equals(entity.getReferenceNumber())) {
            throw new ForbidTenantException("\u65e0\u6743\u9650\u5220\u9664\u8be5\u8868\u5355");
        }
        this.unitWork.executeTran(() -> this.examEnrollmentCriteriaRepository.delete(entity));
    }
}

