/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.domains.entities.MetaPageEntity;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageDataJsonSnapshot;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.DataApprovedStatus;
import com.bcxin.tenant.bcx.infrastructures.enums.DataConfirmStatus;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="dynamic_page_data", autoResultMap=true)
public class DynamicPageDataEntity
extends EntityAbstract
implements Aggregate {
    private static final Logger logger = LoggerFactory.getLogger(DynamicPageDataEntity.class);
    @TableId
    private String id;
    @TableField(value="page_id")
    private String pageId;
    @TableField(value="version")
    private long version;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="last_updated_time")
    private Timestamp lastUpdatedTime;
    @TableField(value="creator_id")
    private String creatorId;
    @TableField(value="last_updater_id")
    private String lastUpdaterId;
    @TableField(value="domain_id")
    private String domainId;
    @TableField(value="data_json")
    private String dataJson;
    @TableField(value="business_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private PageBusinessType businessType;
    @TableField(value="confirm_status", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private DataConfirmStatus confirmStatus;
    @TableField(value="approved_status", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private DataApprovedStatus approvedStatus;
    @TableField(value="last_approved_user_id")
    private String lastApprovedUserId;
    @TableField(value="last_approved_user_name")
    private String lastApprovedUserName;
    @TableField(value="last_approved_time")
    private Timestamp lastApprovedTime;
    @TableField(exist=false)
    private DynamicPageDataJsonSnapshot jsonSnapshot;

    public DynamicPageDataEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setCreatorId("#1");
        this.setDomainId("#1");
        this.setApprovedStatus(DataApprovedStatus.Init);
        this.setConfirmStatus(DataConfirmStatus.Init);
    }

    public DynamicPageDataEntity(String id, String domainId, String creatorId, MetaPageEntity page) {
        this();
        this.setId(id);
        this.setPageId(page.getId());
        this.setCreatorId(creatorId);
        this.setDomainId(domainId);
        this.setVersion(page.getVersion());
        this.setBusinessType(page.getBusinessType());
    }

    public void change(DynamicPageDataJsonSnapshot snapshot, JsonProvider jsonProvider, TenantEmployeeContext.TenantUserModel userModel) {
        this.setJsonSnapshot(snapshot);
        this.setDataJson(jsonProvider.getJson((Object)snapshot));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        String userId = null;
        if (userModel != null) {
            userId = userModel.getId();
        }
        this.setLastUpdaterId(userId);
    }

    public static DynamicPageDataEntity create(String id, TenantEmployeeContext.TenantUserModel userModel, MetaPageEntity page) {
        String organizationId = null;
        String userId = null;
        if (userModel != null) {
            organizationId = userModel.getOrganizationId();
            userId = userModel.getId();
        }
        return new DynamicPageDataEntity(id, organizationId, userId, page);
    }

    public static DynamicPageDataEntity createForMappingData(String id, String pageId, long version, PageBusinessType businessType, DynamicPageDataJsonSnapshot snapshot, String domainId, String lastUpdaterId, String creatorId, Timestamp createdTime, Timestamp lastUpdatedTime, JsonProvider jsonProvider) {
        DynamicPageDataEntity entity = new DynamicPageDataEntity();
        entity.setId(id);
        entity.setVersion(version);
        entity.setPageId(pageId);
        entity.setCreatorId(creatorId);
        entity.setDomainId(domainId);
        entity.setBusinessType(businessType);
        entity.setCreatedTime(createdTime);
        entity.setLastUpdaterId(lastUpdaterId);
        entity.setLastUpdatedTime(lastUpdatedTime);
        entity.setJsonSnapshot(snapshot);
        entity.setDataJson(jsonProvider.getJson((Object)snapshot));
        return entity;
    }

    public String getId() {
        return this.id;
    }

    public String getPageId() {
        return this.pageId;
    }

    public long getVersion() {
        return this.version;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getDataJson() {
        return this.dataJson;
    }

    public PageBusinessType getBusinessType() {
        return this.businessType;
    }

    public DataConfirmStatus getConfirmStatus() {
        return this.confirmStatus;
    }

    public DataApprovedStatus getApprovedStatus() {
        return this.approvedStatus;
    }

    public String getLastApprovedUserId() {
        return this.lastApprovedUserId;
    }

    public String getLastApprovedUserName() {
        return this.lastApprovedUserName;
    }

    public Timestamp getLastApprovedTime() {
        return this.lastApprovedTime;
    }

    public DynamicPageDataJsonSnapshot getJsonSnapshot() {
        return this.jsonSnapshot;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setLastUpdaterId(String lastUpdaterId) {
        this.lastUpdaterId = lastUpdaterId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public void setBusinessType(PageBusinessType businessType) {
        this.businessType = businessType;
    }

    public void setConfirmStatus(DataConfirmStatus confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public void setApprovedStatus(DataApprovedStatus approvedStatus) {
        this.approvedStatus = approvedStatus;
    }

    public void setLastApprovedUserId(String lastApprovedUserId) {
        this.lastApprovedUserId = lastApprovedUserId;
    }

    public void setLastApprovedUserName(String lastApprovedUserName) {
        this.lastApprovedUserName = lastApprovedUserName;
    }

    public void setLastApprovedTime(Timestamp lastApprovedTime) {
        this.lastApprovedTime = lastApprovedTime;
    }

    public void setJsonSnapshot(DynamicPageDataJsonSnapshot jsonSnapshot) {
        this.jsonSnapshot = jsonSnapshot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicPageDataEntity)) {
            return false;
        }
        DynamicPageDataEntity other = (DynamicPageDataEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$pageId = this.getPageId();
        String other$pageId = other.getPageId();
        if (this$pageId == null ? other$pageId != null : !this$pageId.equals(other$pageId)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        String this$lastUpdaterId = this.getLastUpdaterId();
        String other$lastUpdaterId = other.getLastUpdaterId();
        if (this$lastUpdaterId == null ? other$lastUpdaterId != null : !this$lastUpdaterId.equals(other$lastUpdaterId)) {
            return false;
        }
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
            return false;
        }
        String this$dataJson = this.getDataJson();
        String other$dataJson = other.getDataJson();
        if (this$dataJson == null ? other$dataJson != null : !this$dataJson.equals(other$dataJson)) {
            return false;
        }
        PageBusinessType this$businessType = this.getBusinessType();
        PageBusinessType other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        DataConfirmStatus this$confirmStatus = this.getConfirmStatus();
        DataConfirmStatus other$confirmStatus = other.getConfirmStatus();
        if (this$confirmStatus == null ? other$confirmStatus != null : !this$confirmStatus.equals(other$confirmStatus)) {
            return false;
        }
        DataApprovedStatus this$approvedStatus = this.getApprovedStatus();
        DataApprovedStatus other$approvedStatus = other.getApprovedStatus();
        if (this$approvedStatus == null ? other$approvedStatus != null : !this$approvedStatus.equals(other$approvedStatus)) {
            return false;
        }
        String this$lastApprovedUserId = this.getLastApprovedUserId();
        String other$lastApprovedUserId = other.getLastApprovedUserId();
        if (this$lastApprovedUserId == null ? other$lastApprovedUserId != null : !this$lastApprovedUserId.equals(other$lastApprovedUserId)) {
            return false;
        }
        String this$lastApprovedUserName = this.getLastApprovedUserName();
        String other$lastApprovedUserName = other.getLastApprovedUserName();
        if (this$lastApprovedUserName == null ? other$lastApprovedUserName != null : !this$lastApprovedUserName.equals(other$lastApprovedUserName)) {
            return false;
        }
        Timestamp this$lastApprovedTime = this.getLastApprovedTime();
        Timestamp other$lastApprovedTime = other.getLastApprovedTime();
        if (this$lastApprovedTime == null ? other$lastApprovedTime != null : !((Object)this$lastApprovedTime).equals(other$lastApprovedTime)) {
            return false;
        }
        DynamicPageDataJsonSnapshot this$jsonSnapshot = this.getJsonSnapshot();
        DynamicPageDataJsonSnapshot other$jsonSnapshot = other.getJsonSnapshot();
        return !(this$jsonSnapshot == null ? other$jsonSnapshot != null : !((Object)((Object)this$jsonSnapshot)).equals((Object)other$jsonSnapshot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicPageDataEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $pageId = this.getPageId();
        result = result * 59 + ($pageId == null ? 43 : $pageId.hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        String $lastUpdaterId = this.getLastUpdaterId();
        result = result * 59 + ($lastUpdaterId == null ? 43 : $lastUpdaterId.hashCode());
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        String $dataJson = this.getDataJson();
        result = result * 59 + ($dataJson == null ? 43 : $dataJson.hashCode());
        PageBusinessType $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        DataConfirmStatus $confirmStatus = this.getConfirmStatus();
        result = result * 59 + ($confirmStatus == null ? 43 : $confirmStatus.hashCode());
        DataApprovedStatus $approvedStatus = this.getApprovedStatus();
        result = result * 59 + ($approvedStatus == null ? 43 : $approvedStatus.hashCode());
        String $lastApprovedUserId = this.getLastApprovedUserId();
        result = result * 59 + ($lastApprovedUserId == null ? 43 : $lastApprovedUserId.hashCode());
        String $lastApprovedUserName = this.getLastApprovedUserName();
        result = result * 59 + ($lastApprovedUserName == null ? 43 : $lastApprovedUserName.hashCode());
        Timestamp $lastApprovedTime = this.getLastApprovedTime();
        result = result * 59 + ($lastApprovedTime == null ? 43 : ((Object)$lastApprovedTime).hashCode());
        DynamicPageDataJsonSnapshot $jsonSnapshot = this.getJsonSnapshot();
        result = result * 59 + ($jsonSnapshot == null ? 43 : ((Object)((Object)$jsonSnapshot)).hashCode());
        return result;
    }

    public String toString() {
        return "DynamicPageDataEntity(id=" + this.getId() + ", pageId=" + this.getPageId() + ", version=" + this.getVersion() + ", createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", creatorId=" + this.getCreatorId() + ", lastUpdaterId=" + this.getLastUpdaterId() + ", domainId=" + this.getDomainId() + ", dataJson=" + this.getDataJson() + ", businessType=" + this.getBusinessType() + ", confirmStatus=" + this.getConfirmStatus() + ", approvedStatus=" + this.getApprovedStatus() + ", lastApprovedUserId=" + this.getLastApprovedUserId() + ", lastApprovedUserName=" + this.getLastApprovedUserName() + ", lastApprovedTime=" + this.getLastApprovedTime() + ", jsonSnapshot=" + this.getJsonSnapshot() + ")";
    }
}

