/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.converters;

import com.bcxin.tenant.bcx.domains.entities.valueTypes.GeoPointValueType;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.io.ByteOrderValues;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.OutStream;
import com.vividsolutions.jts.io.OutputStreamOutStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GeoPointConverter {
    private int byteOrder = 2;
    private PrecisionModel precisionModel = new PrecisionModel();
    private CoordinateSequenceFactory coordinateSequenceFactory = CoordinateArraySequenceFactory.instance();
    private int outputDimension = 2;

    public GeoPointValueType from(byte[] bytes) {
        GeoPointValueType geoPointValueType;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            GeoPointValueType geoPoint;
            byte[] sridBytes = new byte[4];
            inputStream.read(sridBytes);
            int srid = ByteOrderValues.getInt((byte[])sridBytes, (int)this.byteOrder);
            GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, srid, this.coordinateSequenceFactory);
            WKBReader wkbReader = new WKBReader(geometryFactory);
            Geometry geometry = wkbReader.read((InStream)new InputStreamInStream((InputStream)inputStream));
            Point point = (Point)geometry;
            geoPointValueType = geoPoint = new GeoPointValueType(point.getX(), point.getY());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException | IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        inputStream.close();
        return geoPointValueType;
    }

    public byte[] to(GeoPointValueType geoPoint) {
        byte[] byArray;
        if (geoPoint == null) {
            return null;
        }
        Coordinate coordinate = new Coordinate(geoPoint.getLat(), geoPoint.getLon());
        CoordinateArraySequence coordinateArraySequence = new CoordinateArraySequence(new Coordinate[]{coordinate}, 2);
        Point point = new Point((CoordinateSequence)coordinateArraySequence, new GeometryFactory());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            byte[] sridBytes = new byte[4];
            ByteOrderValues.putInt((int)point.getSRID(), (byte[])sridBytes, (int)this.byteOrder);
            outputStream.write(sridBytes);
            WKBWriter wkbWriter = new WKBWriter(this.outputDimension, this.byteOrder);
            wkbWriter.write((Geometry)point, (OutStream)new OutputStreamOutStream((OutputStream)outputStream));
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        outputStream.close();
        return byArray;
    }
}

