/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.dubbo.common.configs.filters;

import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.TrafficTagValueType;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.support.ConsumerContextFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"}, order=-99999)
public class CustomConsumerContextFilter
extends ConsumerContextFilter {
    private static final Logger logger = LoggerFactory.getLogger(CustomConsumerContextFilter.class);

    public CustomConsumerContextFilter(ApplicationModel applicationModel) {
        super(applicationModel);
        System.err.println("CustomConsumerContextFilter");
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        TenantContext tenantContext = TenantContext.getInstance();
        TenantEmployeeContext.TenantUserModel userModel = tenantContext.getUserContext().get();
        invocation.setAttachment("API.CURRENT_TENANT_USER_INFO", (Object)userModel);
        Object tag = tenantContext.getAttachValue("FLOW_TAG_NAME");
        if (tag != null) {
            RpcContext.getClientAttachment().setAttachment("dubbo.tag", tag);
        }
        Result result = super.invoke(invoker, invocation);
        RpcContextAttachment contextAttachment = RpcContext.getServerContext();
        TrafficTagValueType tagValueType = (TrafficTagValueType)contextAttachment.getObjectAttachment("PROVIDER_FLOW_TAG_NAME");
        if (tagValueType != null) {
            TenantContext.getInstance().addAttachValues("PROVIDER_FLOW_TAG_NAME", (Object)tagValueType);
        }
        return result;
    }
}

