package com.bcxin.tenant.bcx.domains.wrappers;

import com.bcxin.tenant.bcx.domains.constants.DynamicConstants;
import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageTableMappingDataSnapshot;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.DoActionType;
import com.bcxin.tenant.bcx.infrastructures.enums.DynamicMappingType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ArgumentTenantException;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Getter
@Setter(AccessLevel.PROTECTED)
public class DynamicDataWrapper implements Serializable {
    private DynamicMappingType mappingType;
    private DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot dsl;
    private DoActionType actionType;
    private Map<String, Object> params = new HashMap<>();
    private int pageIndex=1;
    private int pageSize=10;
    private boolean ignorePage = false;
    private String actionDsl;
    private String queryCondition;

    public String getFullQueryConditionDsl() {
        final String CONDITION_PLACE_HOLDER = "[[CONDITION_PLACE_HOLDER]]";
        if (dsl.getQueryDsl().contains(CONDITION_PLACE_HOLDER)) {
            return dsl.getQueryDsl().replace(CONDITION_PLACE_HOLDER, getQueryCondition());
        }

        return String.format("%s %s", dsl.getQueryDsl(), getQueryCondition());
    }

    private TenantEmployeeContext.TenantUserModel currentUser;

    public DynamicDataWrapper() {
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_DOMAIN_ID, DynamicConstants.DEFAULT_EMPTY_VALUE);
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_CREATOR_ID, DynamicConstants.DEFAULT_EMPTY_VALUE);
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_LAST_UPDATER_ID, DynamicConstants.DEFAULT_EMPTY_VALUE);

        Timestamp now = Timestamp.from(Instant.now());
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_CREATED_TIME, now);
        this.getParams().put(DynamicConstants.DYNAMIC_SYS_CREATED_TIME, now);
    }

    public static DynamicDataWrapper create(DynamicPageTableMappingDataSnapshot tableMapping,
                                            DynamicPageDataEntity entity,
                                            JsonProvider jsonProvider,
                                            DoActionType actionType
    ) {
        if (entity == null) {
            throw new ArgumentTenantException("系统参数异常");
        }

        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setMappingType(tableMapping.getMappingType());
        tableMapping.buildAndFillWrapper(wrapper, entity, jsonProvider);
        wrapper.setActionType(actionType);
        wrapper.setActionDsl(tableMapping.getActionDsl(actionType));

        return wrapper;
    }

    public static DynamicDataWrapper createForGetAndDeleteAction(
            DynamicPageTableMappingDataSnapshot tableMapping,
                                                           String pageId, String id) {
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setMappingType(tableMapping.getMappingType());
        wrapper.getParams().put("pageId", pageId);
        wrapper.getParams().put("id", id);

        return wrapper;
    }

    public static DynamicDataWrapper createForSearch(
            DynamicPageTableMappingDataSnapshot tableMapping,
            Map<String,Object> params,
            boolean ignorePage,
            int pageIndex,
            int pageSize) {
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setIgnorePage(ignorePage);
        wrapper.setPageIndex(pageIndex);
        wrapper.setPageSize(pageSize);

        wrapper.setMappingType(tableMapping.getMappingType());

        StringBuilder sb = new StringBuilder();
        if (params != null && !CollectionUtils.isEmpty(params)) {
            for (String key : params.keySet()) {
                /**
                 * todo: 待完善..
                 */
                if(DynamicConstants.DYNAMIC_SYS_PAGE_ID.equals(key)) {
                    wrapper.addParam(key,params.get(key));
                    continue;
                }
                Object value = params.get(key);

                String paramKey = key.replace(".", "_");
                wrapper.addParam(paramKey,params.get(key));
                if (value != null) {
                    if (value instanceof String) {
                        if(StringUtils.hasLength((String) value)) {
                            sb.append(" and ").append(key).append(" like ").append("concat(#{params." + paramKey + "},'%') ");
                        }
                    } else if (value instanceof List<?>) {
                        List valueCollection = (List<?>) value;
                        if(key.contains("time")) {
                            Object beginValue = valueCollection.get(0);
                            Object endValue = valueCollection.get(1);
                            if (beginValue != null) {
                                String beginKey = String.format("%s_From", paramKey);
                                wrapper.addParam(beginKey, beginValue);
                                sb.append(" and ").append(key).append(" >= ").append("#{params." + beginKey + "}");
                            }
                            if (endValue != null) {
                                String endKey = String.format("%s_To", paramKey);
                                wrapper.addParam(endKey, endValue);
                                sb.append(" and ").append(key).append(" <= ").append("#{params." + endKey + "}");
                            }
                        }else {
                            StringBuilder sbCondition = new StringBuilder();
                            for (var index = 0; index < valueCollection.size(); index++) {
                                String itemKey = String.format("%s_%s", paramKey, index);
                                if (sbCondition.length() > 0) {
                                    sbCondition.append(",");
                                }
                                sbCondition.append("#{params." + itemKey + "}");
                                wrapper.addParam(itemKey, valueCollection.get(index));
                            }
                            sb.append(" and ").append(key).append(" in ").append("(" + sbCondition + ")");
                        }
                    } else {
                        sb.append(" and ").append(key).append(" = ").append("#{params." + paramKey + "}");
                    }
                }
            }
        }
        wrapper.setQueryCondition(sb.toString());

        return wrapper;
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

    public void addParams(Map<String, Object> params) {
        this.params.putAll(params);
    }

    public void assignCurrentUser(TenantEmployeeContext.TenantUserModel user) {
        this.currentUser = user;
    }
}
