package com.bcxin.tenant.bcx.domains.services.commands.dynamics;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Map;

@Getter
public class CreateDynamicPageDataCommand extends CommandAbstract {
    private final String pageId;
    private final Map<String, Object> items;

    public CreateDynamicPageDataCommand(String pageId, Map<String, Object> items) {
        this.pageId = pageId;
        this.items = items;
    }

    public static CreateDynamicPageDataCommand create(String pageId, Map<String, Object> items) {
        return new CreateDynamicPageDataCommand(pageId, items);
    }
}
