package com.bcxin.tenant.bcx.domains.services.commands.dynamics;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.DoActionType;
import lombok.Getter;

import java.util.Map;

@Getter
public class ActionDynamicPageDataCommand extends CommandAbstract {
    private final String id;
    private final String pageId;
    private final DoActionType actionType;
    private final Map<String, Object> items;

    public ActionDynamicPageDataCommand(String id, String pageId,
                                        DoActionType actionType,
                                        Map<String, Object> items) {
        this.id = id;
        this.pageId = pageId;
        this.actionType = actionType;
        this.items = items;
    }

    public static ActionDynamicPageDataCommand create(String id, String pageId,
                                                      DoActionType actionType,
                                                      Map<String, Object> items) {
        return new ActionDynamicPageDataCommand(id, pageId, actionType, items);
    }
}
