package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.entities.MetaPageVersionEntity;
import com.bcxin.tenant.bcx.infrastructures.repositories.RepositoryBase;

import java.util.List;

/**
 * 页面版本仓储接口
 */
public interface MetaPageVersionRepository extends RepositoryBase<MetaPageVersionEntity> {
    /**
     * 根据页面ID获取所有版本
     */
    List<MetaPageVersionEntity> getByPageId(String pageId);
    
    /**
     * 根据页面ID和版本号获取特定版本
     */
    MetaPageVersionEntity getByPageIdAndVersion(String pageId, long version);
}

