package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName(value = "meta_modules",autoResultMap = true)
public class MetaModuleEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "project_id")
    private String projectId;

    /**
     * 创造者类型: 0-平台, 1-租户, 2-用户
     */
    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;

    /**
     * 创建者标识(平台组织Id/租户Id/用户Id)
     */
    @TableField(value = "reference_number")
    private String referenceNumber;

    /**
     * 创作者Id
     */
    @TableField(value = "creator_id")
    private String creatorId;

    /**
     * 最后修改人Id
     */
    @TableField(value = "last_updater_id")
    private String lastUpdaterId;

    /**
     * 是否已删除: 0-未删除, 1-已删除
     */
    @TableField(value = "deleted")
    private boolean deleted;

    @TableField(value = "last_updated_Time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    public static MetaModuleEntity create(String id, String projectId, String name,
                                          MetaCreatorReferenceType referenceType,
                                          String referenceNumber,
                                          String creatorId) {
        MetaModuleEntity entity = new MetaModuleEntity();
        entity.id = id;
        entity.projectId = projectId;
        entity.name = name;
        entity.referenceType = referenceType;
        entity.referenceNumber = referenceNumber;
        entity.creatorId = creatorId;
        entity.deleted = false; // 默认未删除
        return entity;
    }

    public void change(String name, TenantEmployeeContext.TenantUserModel userModel) {
        this.name = name;
        this.lastUpdaterId = userModel.getId();
        this.lastUpdatedTime = new Timestamp(System.currentTimeMillis());
    }

    /**
     * 逻辑删除
     */
    public void changeMarkAsDeleted(TenantEmployeeContext.TenantUserModel userModel) {
        this.deleted = true;
        this.lastUpdaterId = userModel.getId();
        this.lastUpdatedTime = new Timestamp(System.currentTimeMillis());
    }
}
