package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.AnalyticsLogType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "analytics_log")
@Data
public class AnalyticsLogEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "dispatcher_id")
    private String dispatcherId;

    @TableField(value = "dispatcher_name")
    private String dispatcherName;

    @TableField(value = "type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private AnalyticsLogType type;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "reference_number")
    private String referenceNumber;

    @TableField(value = "reference_name")
    private String referenceName;

    @TableField(value = "params")
    private String params;

    public AnalyticsLogEntity(){
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static AnalyticsLogEntity create(String dispatcherId,
                                            String dispatcherName,
                                            AnalyticsLogType type,
                                            String organizationId,
                                            String referenceNumber,
                                            String referenceName,
                                            String params
                                            ){
        AnalyticsLogEntity entity = new AnalyticsLogEntity();
        entity.setDispatcherId(dispatcherId);
        entity.setDispatcherName(dispatcherName);
        entity.setType(type);
        entity.setOrganizationId(organizationId);
        entity.setReferenceNumber(referenceNumber);
        entity.setReferenceName(referenceName);
        entity.setParams(params);

        return entity;
    }

}
