package com.bcxin.tenant.bcx.domains.criterias;

import com.bcxin.tenant.bcx.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.DynamicConditionFieldValueType;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Getter
public class DynamicPageDataCriteria extends CriteriaAbstract {
    private final String pageId;
    private final String mappingId;

    private final Collection<DynamicConditionFieldValueType> fields;

    protected DynamicPageDataCriteria(int pageIndex, int pageSize, String pageId,String mappingId, Collection<DynamicConditionFieldValueType> fields) {
        super(pageIndex, pageSize);
        this.pageId = pageId;
        this.fields = fields;
        this.mappingId = mappingId;
    }

    public static DynamicPageDataCriteria create(int pageIndex, int pageSize,String pageId, Collection<DynamicConditionFieldValueType> fields) {
        return new DynamicPageDataCriteria(pageIndex, pageSize, pageId, null,fields);
    }

    public static DynamicPageDataCriteria createForMapping(int pageIndex, int pageSize,String mappingId, Collection<DynamicConditionFieldValueType> fields) {
        return new DynamicPageDataCriteria(pageIndex, pageSize, null, mappingId,fields);
    }

    public Map<String,Object> getFiledKeyValueMap() {
        Map<String, Object> map = new HashMap<>();
        if(!CollectionUtils.isEmpty(fields)) {
            for (DynamicConditionFieldValueType fieldValueType : fields) {
                map.put(fieldValueType.getField(), fieldValueType.getValue());
            }
        }

        return map;
    }
}