package com.bcxin.tenant.bcx.domains.snapshots;

import com.baomidou.mybatisplus.annotation.TableField;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.snapshots.SnapshotAbstract;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class DynamicPageValueSnapshot extends SnapshotAbstract {
    private String pageId;
    private long version;
    private PageBusinessType businessType;
    private Map<String, Object> items;
    private Map<String,String> columnMappings;

    public static DynamicPageValueSnapshot create(String pageId, long version, PageBusinessType businessType,
                                                  Map<String, Object> items,
                                                  Map<String,String> columnMappings) {
        DynamicPageValueSnapshot snapshot = new DynamicPageValueSnapshot();
        snapshot.setPageId(pageId);
        snapshot.setVersion(version);
        snapshot.setBusinessType(businessType);
        snapshot.setItems(items);
        snapshot.setColumnMappings(columnMappings);

        return snapshot;
    }

    public static DynamicPageValueSnapshot empty() {
        return create(null, 0, null, new HashMap<>(), new HashMap<>());
    }
}
