package com.bcxin.tenant.bcx.domains.services;

import com.bcxin.tenant.bcx.domains.entities.BusOrganRegistryFormsEntity;
import com.bcxin.tenant.bcx.domains.repositories.criterias.OrganRegistryFormsSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.organregistry.BatchLogicalDeleteOrganRegistryFormsCommand;
import com.bcxin.tenant.bcx.domains.services.commands.organregistry.CreateOrganRegistryFormsCommand;
import com.bcxin.tenant.bcx.domains.services.commands.organregistry.LogicalDeleteOrganRegistryFormsCommand;
import com.bcxin.tenant.bcx.domains.services.commands.organregistry.UpdateOrganRegistryFormsCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;

/**
 * 企业注册表单服务接口
 */
public interface OrganRegistryFormsService {
    void dispatch(CreateOrganRegistryFormsCommand command);

    void dispatch(UpdateOrganRegistryFormsCommand command);

    void dispatch(DeleteDataCommand command);

    /**
     * 逻辑删除企业注册表单
     */
    void dispatch(LogicalDeleteOrganRegistryFormsCommand command);

    /**
     * 批量逻辑删除企业注册表单
     */
    void dispatch(BatchLogicalDeleteOrganRegistryFormsCommand command);

    EntityCollection<BusOrganRegistryFormsEntity> search(OrganRegistryFormsSearchCriteria criteria);

    BusOrganRegistryFormsEntity getById(String id);

    /**
     * 根据条件查找企业注册表单
     */
    BusOrganRegistryFormsEntity findByCondition(String institutionalTypeCode, String industryTypeCode, String regionCode);
}
