package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.ExamReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

/**
 * 自定义报名条件
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName(value = "bus_exam_enrollment_criteria", autoResultMap = true)
public class ExamEnrollmentCriteriaEntity extends EntityAbstract implements Aggregate {
    /**
     * meta_pages页面的Id;
     */
    @TableId(value = "id")
    private String id;

    /**
     * 报名类型: 科目
     */
    @TableField(value = "subject_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ExamReferenceType subjectType;

    @TableField(value = "subject_number")
    private String subjectNumber;

    /**
     * 创造者类型: 0-平台, 1-租户, 2-用户
     */
    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;

    /**
     * 创建者标识(平台组织Id/租户Id/用户Id)
     */
    @TableField(value = "reference_number")
    private String referenceNumber;

    @TableField(value = "name")
    private String name;

    @TableField(value = "note")
    private String note;


    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "creator_id")
    private String creatorId;
    @TableField(value = "creator_name")
    private String creatorName;

    /**
     * 最后修改人Id
     */
    @TableField(value = "last_updater_id")
    private String lastUpdaterId;

    @TableField(value = "last_updater_name")
    private String lastUpdaterName;

    @TableField(value = "deleted")
    private boolean deleted;

    public ExamEnrollmentCriteriaEntity() {
        this.setDeleted(false);
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static ExamEnrollmentCriteriaEntity create(
            String id,
            ExamReferenceType subjectType,
            String subjectNumber,
            TenantEmployeeContext.TenantUserModel creator) {
        ExamEnrollmentCriteriaEntity entity = new ExamEnrollmentCriteriaEntity();
        entity.setId(id);

        entity.setSubjectType(subjectType);
        entity.setSubjectNumber(subjectNumber);
        entity.setReferenceType(creator.getUserType());
        entity.setReferenceNumber(creator.getOrganizationId());
        entity.setCreatorId(creator.getId());
        entity.setCreatorName(creator.getName());

        return entity;
    }

    public void change(String name,String  note,
                       TenantEmployeeContext.TenantUserModel lastUpdater) {
        this.setName(name);
        this.setNote(note);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastUpdaterId(lastUpdater.getId());
        this.setLastUpdaterName(lastUpdater.getName());
    }
}
