/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.BusOrganRegistryFormsEntity;
import com.bcxin.tenant.bcx.domains.repositories.OrganRegistryFormsRepository;
import com.bcxin.tenant.bcx.domains.repositories.criterias.OrganRegistryFormsSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.MetaPageService;
import com.bcxin.tenant.bcx.domains.services.OrganRegistryFormsService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.organregistry.BatchLogicalDeleteOrganRegistryFormsCommand;
import com.bcxin.tenant.bcx.domains.services.commands.organregistry.CreateOrganRegistryFormsCommand;
import com.bcxin.tenant.bcx.domains.services.commands.organregistry.LogicalDeleteOrganRegistryFormsCommand;
import com.bcxin.tenant.bcx.domains.services.commands.organregistry.UpdateOrganRegistryFormsCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.BatchLogicalDeletePageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.CreateMetaPageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.LogicalDeletePageCommand;
import com.bcxin.tenant.bcx.domains.services.commands.pages.UpdateMetaPageCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OrganRegistryFormsServiceImpl
implements OrganRegistryFormsService {
    private final OrganRegistryFormsRepository repository;
    private final MetaPageService metaPageService;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public OrganRegistryFormsServiceImpl(OrganRegistryFormsRepository repository, MetaPageService metaPageService, UnitWork unitWork, IdWorker idWorker) {
        this.repository = repository;
        this.metaPageService = metaPageService;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreateOrganRegistryFormsCommand command) {
        command.validate();
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        this.unitWork.executeTran(() -> {
            String pageId = String.valueOf(this.idWorker.getNextId());
            CreateMetaPageCommand createPageCommand = new CreateMetaPageCommand("1", "1179141567317098496", command.getName(), command.getNote(), command.getFormJson(), command.getSlug(), command.getLogo(), command.getPageType(), command.getBusinessType(), command.getTableName(), command.getEnableBPMFlow() != null ? command.getEnableBPMFlow() : false, command.getEnableAnonymousAccess() != null ? command.getEnableAnonymousAccess() : false, false, null, null, null, 0);
            pageId = this.metaPageService.dispatch(createPageCommand);
            String id = String.valueOf(this.idWorker.getNextId());
            BusOrganRegistryFormsEntity entity = BusOrganRegistryFormsEntity.create(id, command.getInstitutionalTypeCode(), command.getIndustryTypeCode(), command.getRegionCode(), pageId, userModel.getUserType(), userModel.getOrganizationId(), userModel.getEmployeeId());
            this.repository.insert(entity);
        });
    }

    @Override
    public void dispatch(UpdateOrganRegistryFormsCommand command) {
        command.validate();
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        this.unitWork.executeTran(() -> {
            BusOrganRegistryFormsEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u66f4\u65b0\u5df2\u5220\u9664\u7684\u4f01\u4e1a\u6ce8\u518c\u8868\u5355\uff0cID: " + command.getId());
            }
            entity.change(command.getInstitutionalTypeCode(), command.getIndustryTypeCode(), command.getRegionCode(), userModel.getUserType(), userModel.getOrganizationId(), userModel.getEmployeeId());
            this.repository.update(entity);
            if (command.getName() != null || command.getNote() != null || command.getFormJson() != null || command.getSlug() != null || command.getLogo() != null || command.getPageType() != null || command.getBusinessType() != null || command.getTableName() != null || command.getEnableBPMFlow() != null || command.getEnableAnonymousAccess() != null || command.getSettingJson() != null) {
                UpdateMetaPageCommand updatePageCommand = UpdateMetaPageCommand.create(entity.getPageId(), command.getName(), command.getNote(), command.getSlug(), command.getLogo(), command.getPageType(), command.getBusinessType(), command.getTableName(), command.getEnableBPMFlow() != null ? command.getEnableBPMFlow() : false, command.getEnableAnonymousAccess() != null ? command.getEnableAnonymousAccess() : false, false, null, null, null, 0);
                this.metaPageService.dispatch(updatePageCommand);
            }
        });
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7269\u7406\u5220\u9664");
    }

    @Override
    public void dispatch(LogicalDeleteOrganRegistryFormsCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            BusOrganRegistryFormsEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new NoFoundTenantException();
            }
            if (entity.getPageId() != null && !entity.getPageId().isEmpty()) {
                LogicalDeletePageCommand deletePageCommand = new LogicalDeletePageCommand(entity.getPageId());
                this.metaPageService.dispatch(deletePageCommand);
            }
            TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
            entity.changeMarkAsDeleted(userModel);
            this.repository.update(entity);
        });
    }

    @Override
    public void dispatch(BatchLogicalDeleteOrganRegistryFormsCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            List<String> ids = command.getIds();
            if (ids == null || ids.isEmpty()) {
                return;
            }
            List<BusOrganRegistryFormsEntity> entities = this.repository.getByIds(ids);
            ArrayList<String> pageIds = new ArrayList<String>();
            ArrayList<String> validIds = new ArrayList<String>();
            for (BusOrganRegistryFormsEntity entity : entities) {
                if (entity == null || entity.isDeleted()) continue;
                validIds.add(entity.getId());
                if (entity.getPageId() == null || entity.getPageId().isEmpty()) continue;
                pageIds.add(entity.getPageId());
            }
            if (validIds.isEmpty()) {
                return;
            }
            if (!pageIds.isEmpty()) {
                this.metaPageService.dispatch(new BatchLogicalDeletePageCommand(pageIds));
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            this.repository.batchMarkAsDeleted(validIds, now);
        });
    }

    @Override
    public EntityCollection<BusOrganRegistryFormsEntity> search(OrganRegistryFormsSearchCriteria criteria) {
        return this.repository.search(criteria);
    }

    @Override
    public BusOrganRegistryFormsEntity getById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        return (BusOrganRegistryFormsEntity)this.repository.getById(id);
    }

    @Override
    public BusOrganRegistryFormsEntity findByCondition(String institutionalTypeCode, String industryTypeCode, String regionCode) {
        return this.repository.findByCondition(institutionalTypeCode, industryTypeCode, regionCode);
    }

    private BusOrganRegistryFormsEntity getByIdIncludeDeleted(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        return (BusOrganRegistryFormsEntity)this.repository.getById(id);
    }
}

