package com.bcxin.tenant.bcx.infrastructures.snapshots;

import lombok.Data;

import java.util.Collection;

@Data
public class PermissionConfigSnapshot extends SnapshotAbstract {

    private PermissionType referenceType;
    private Collection<String> referenceNumbers;

    public static enum PermissionType {
        Organization,
        Employee,
        Role
    }

    public boolean matched(PermissionType permissionType,String value) {
        if (this.getReferenceType() == permissionType || this.getReferenceNumbers() == null) {
            return this.getReferenceNumbers().contains(value);
        }

        return false;
    }
}
