package com.bcxin.tenant.bcx.infrastructures.criterias;

import lombok.Data;
import lombok.Getter;

@Data
public abstract class CriteriaAbstract {
    public static final int IGNORE_PAGE_FOR_SIZE = Integer.MAX_VALUE;

    private final int pageIndex;
    private final int pageSize;

    private boolean forExport;

    public int getSkip() {
        int skip = (this.getPageIndex() - 1) * this.getPageSize();

        if (skip < 0) {
            skip = 0;
        }

        return skip;
    }

    protected CriteriaAbstract(int pageIndex, int pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    protected CriteriaAbstract() {
        this(1, 20);
    }

    public boolean ignorePage() {
        return this.getPageSize() == IGNORE_PAGE_FOR_SIZE || this.isForExport();
    }
}
