package com.bcxin.tenant.bcx.infrastructures;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

@Data
public class UserDetailResponse extends ResponseAbstract {
    @JSONField(name = "tId")
    private String id;
    @JSONField(name = "eid")
    private String employeeId;

    @JSONField(name = "name")
    private String name;

    @JSONField(name = "idCardNo")
    private String idCardNo;

    @JSONField(name = "orId")
    private String organizationId;

    @JSONField(name = "imNum")
    private String imNum;

    @JSONField(name = "org_lat")
    private Double orgLatitude;

    @JSONField(name = "org_lon")
    private Double orgLongitude;

    @JSONField(name = "supervise")
    private Boolean supervise;

    @JSONField(name = "org_ist")
    private String institutional;

    @JSONField(name = "org_industry")
    private String industry;

    @JSONField(name = "org_name")
    private String orgName;

    @JSONField(name = "domain_admin")
    private boolean domainAdmin;

    @JSONField(name = "sup_region_code")
    private String superviseRegionCode;

    /**
     * 所在企业的级别:(企业或者集团等等)
     */
    @JSONField(name = "cLevel")
    private int cLevel;


    public UserDetailResponse() {
        this.supervise = false;
    }

    public UserDetailResponse(String id, String name,String idCardNo) {
        this.id = id;
        this.name = name;
        this.idCardNo = idCardNo;
    }

    public void change(String employeeId,
                       String organizationId,
                       String industry,
                       String institutional,
                       String superviseRegionCode,
                       String orgName,
                       boolean domainAdmin,
                       int cLevel){
        this.employeeId = employeeId;
        this.organizationId = organizationId;
        this.industry = industry;
        this.institutional = institutional;
        this.superviseRegionCode = superviseRegionCode;
        this.orgName = orgName;
        this.domainAdmin = domainAdmin;
        this.cLevel = cLevel;
    }

    public void assignOrgLatLon(Double orgLatitude, Double orgLongitude) {
        this.setOrgLatitude(orgLatitude);
        this.setOrgLongitude(orgLongitude);
    }

    public static UserDetailResponse create(String id,
                                            String name,
                                            String idCardNo) {
        return new UserDetailResponse(
                id,  name,idCardNo);
    }
}
