package com.baichuanxin.openrestapi.entity;


import com.baichuanxin.openrestapi.dtos.AttachDto;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Map;


@Data
@TableName(value = "notice",autoResultMap = true)
public class Notice {
    //办件唯一ID
    @TableId("taskId")
    private String taskId;
    //办件事项名称
    @TableField("matName")
    private String matName;
    //事项ID
    @TableField("matId")
    private String matId;
    //申办人姓名
    @TableField("sbrxm")
    private String sbrxm;
    //申办人身份证号码
    @TableField("sbrgmsfhm")
    private String sbrgmsfhm;
    //申办人联系电话
    @TableField("sbrlxdh")
    private String sbrlxdh;
    //申请时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField("createTime")
    private Date createTime;
    //业务数据
    @TableField(value = "formJson",typeHandler = JacksonTypeHandler.class)
    private Map<String, Object> formJson;
    //附件列表
    @TableField(value = "attachList",typeHandler = JacksonTypeHandler.class)
    private List<AttachDto> attachList;

    //是否进行邮寄   0、否 1、是
    @TableField("isdelivery")
    private String isdelivery;
    @TableField("sourceAddress")
    private String sourceAddress;
    @TableField("targetAddress")
    private String targetAddress;

    //办件数据获取状态
    @TableField("status")
    private Integer status;
    //办件结果物回传状态
    @TableField("fileStatus")
    private Integer fileStatus;
    //收到办件通知的时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "receiptTime")
    private Date receiptTime;
    //获取办件数据的时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "getDataTime")
    private Date getDataTime;

}
