/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.document.domains.documents.RdCommunityUserDocument;
import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.document.domains.repositories.RdEmployeeDocumentRepository;
import com.bcxin.tenant.open.document.domains.utils.GeoPointUtils;
import com.bcxin.tenant.open.domains.entities.RdEmployeeEntity;
import com.bcxin.tenant.open.domains.readers.RdCompositedReader;
import com.bcxin.tenant.open.domains.repositories.AttendanceRepository;
import com.bcxin.tenant.open.domains.repositories.RdWorkstationRepository;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.enums.RoleType;
import com.bcxin.tenant.open.infrastructures.exceptions.DocumentIndexNoFoundException;
import com.bcxin.tenant.open.infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.geo.Point;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RdEmployeeEntityUtils {
    private static final Logger logger = LoggerFactory.getLogger(RdEmployeeEntityUtils.class);

    public static RdEmployeeDocument toDocument(RdEmployeeEntity ii, boolean isFlushStation, RdEmployeeDocumentRepository rdEmployeeDocumentRepository, AttendanceRepository attendanceRepository, RdCompositedReader compositedReader, BeanFactory beanFactory, Collection<RdCommunityUserDocument> communityUserDocuments, Collection<RdDispatchDataScopeDocument> dataScopeDocuments, Collection<RdCompanyDocument> proprietorCompanyDocuments) {
        try {
            Collection selectedUserDocuments;
            RdEmployeeDocument document = null;
            Optional documentOptional = rdEmployeeDocumentRepository.findById((Object)ii.getId());
            if (documentOptional.isPresent()) {
                document = (RdEmployeeDocument)documentOptional.get();
            } else {
                document = new RdEmployeeDocument();
                document.setId(ii.getId());
            }
            document.rest();
            document.setCLevel(ii.getCLevel());
            document.setName(ii.getName());
            document.setContact(ii.getContact());
            document.setCheckedStatus(ii.getCheckedStatus());
            document.setAuthenticatedStatus(ii.getAuthenticatedStatus());
            document.setTenantImUserId(ii.getTenantImUserId());
            document.setOrganizationId(ii.getOrganizationId());
            document.setCompanyName(ii.getCompanyName());
            document.setDeviceNumber(ii.getDeviceNumber());
            document.setHeadPhoto(ii.getHeadPhoto());
            document.setHiredDate((Date)ii.getHiredDate());
            document.setIdCardNo(ii.getIdCardNo());
            document.setInsure(ii.isInsure());
            document.setMilitaryStatus(ii.getMilitaryStatus());
            document.setOccupationType(ii.getOccupationType());
            document.setStatus(ii.getStatus());
            document.setSecurityCertificateNo(ii.getSecurityCertificateNo());
            document.setTenantEmployeeId(ii.getTenantEmployeeId());
            document.setCId(ii.getCId());
            document.setSuperviseRegionCode(ii.getSuperviseRegionCode());
            document.setThirdParty(ii.getThirdParty());
            if (document.getLonLat() == null || document.getLonLat().getX() < 2.0 || document.getLonLat().getY() == 1.0) {
                if (!StringUtil.isEmpty((String)ii.getLonLat())) {
                    document.setLonLat(GeoPointUtils.translate((String)ii.getLonLat()));
                }
                if (document.getLonLat() == null || document.getLonLat().getX() < 2.0 || document.getLonLat().getY() == 1.0) {
                    document.setLonLat(new Point(BusinessConstants.INVALID_LON_LAT.doubleValue(), BusinessConstants.INVALID_LON_LAT.doubleValue()));
                }
                if (StringUtil.isEmpty((String)document.getDutyStatus())) {
                    document.setDutyStatus(ii.getDutyStatus().name());
                }
            }
            if (StringUtil.isEmpty((String)document.getDutyStatus()) || !DutySignInType.SignIn.name().equalsIgnoreCase(document.getDutyStatus())) {
                document.makeDispatchable(false, "\u7b7e\u5230\u79bb\u5c97\u4eba\u5458");
                document.setLastDutyStatusChangedTime(Timestamp.from(Instant.now()));
            }
            document.setTenantUserId(ii.getTenantUserId());
            document.addScopePermissions(new String[]{ii.getOrganizationId()});
            document.setSuperviseDepartId(ii.getSuperviseDepartId());
            document.addScopePermissions(new String[]{ii.getSuperviseDepartId()});
            if (!StringUtil.isEmpty((String)ii.getResponsibleOfStationId())) {
                String[] respStationIds = (String[])Arrays.stream(ii.getResponsibleOfStationId().split(";")).filter(ix -> !StringUtil.isEmpty((String)ix)).toArray(String[]::new);
                document.addScopePermissions(respStationIds);
            }
            boolean noFoundPer = false;
            if (!CollectionUtils.isEmpty(dataScopeDocuments)) {
                Collection scopeIds = dataScopeDocuments.stream().filter(it -> StringUtil.isEqual((String)it.getId(), (String)ii.getSecurityStationId()) && !CollectionUtils.isEmpty((Collection)it.getScopes())).flatMap(it -> it.getScopes().stream()).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty((Collection)scopeIds)) {
                    Collection perCompanies;
                    document.addScopePermissions((String[])scopeIds.toArray(String[]::new));
                    if (!CollectionUtils.isEmpty(proprietorCompanyDocuments) && !CollectionUtils.isEmpty((Collection)(perCompanies = (Collection)proprietorCompanyDocuments.stream().filter(it -> scopeIds.contains(it.getId())).collect(Collectors.toList())))) {
                        document.addScopePermissions((String[])perCompanies.stream().map(ix -> ix.getSuperviseDepartId()).filter(ix -> !StringUtil.isEmpty((String)ix)).collect(Collectors.toList()).toArray(String[]::new));
                        RdCompanyDocument firstCom = (RdCompanyDocument)perCompanies.stream().findFirst().get();
                        document.assignProprietor(firstCom.getId(), firstCom.getName());
                        document.addResourceTypes(new String[]{ResourceType.ProprietorManaged.name()});
                    }
                } else {
                    noFoundPer = true;
                }
            }
            document.setSuperviseDepartName(ii.getSuperviseDepartName());
            document.setSecurityStationId(ii.getSecurityStationId());
            document.setSecurityStationName(ii.getSecurityStationName());
            if (!StringUtil.isEmpty((String)ii.getSecurityStationId()) && !"#1".equalsIgnoreCase(ii.getSecurityStationId())) {
                document.addScopePermissions(new String[]{ii.getSecurityStationId()});
            }
            document.setSex(ii.getSex());
            document.addResponsibleOfStationIds(ii.getResponsibleOfStationId());
            document.setDomainAdmin(ii.isDomainAdmin());
            document.setIndustry(ii.getIndustry());
            document.setInstitutional(ii.getInstitutional());
            RoleType roleType = RoleType.create((String)ii.getInstitutional(), (String)ii.getCompanyName());
            if (roleType == RoleType.Company || roleType == RoleType.Proprietor) {
                document.addResourceTypes(new String[]{ResourceType.create((String)ii.getInstitutional())});
            }
            if (!(CollectionUtils.isEmpty(communityUserDocuments) || "#1".equalsIgnoreCase(document.getSecurityStationId()) || CollectionUtils.isEmpty((Collection)(selectedUserDocuments = (Collection)communityUserDocuments.stream().filter(ix -> StringUtil.isEqual((String)ix.getTenantUserId(), (String)ii.getTenantUserId())).collect(Collectors.toList()))))) {
                String[] superviseDepartIds = (String[])selectedUserDocuments.stream().map(ix -> ix.getSuperviseDepartId()).distinct().filter(ix -> StringUtils.hasLength((String)ix)).collect(Collectors.toList()).toArray(String[]::new);
                document.addScopePermissions(superviseDepartIds);
                document.addResourceTypes(new String[]{ResourceType.Population.name()});
            }
            if (noFoundPer) {
                // empty if block
            }
            Set<String> stationTypes = new HashSet<String>();
            if (!StringUtil.isEmpty((String)ii.getSecurityStationId())) {
                stationTypes.add(ii.getSecurityStationId());
            }
            if (ii.getResourceType() == ResourceType.TemporarySecurity) {
                EntityStream entityStream;
                RdSecurityStationDocument securityStationDocument;
                document.addResourceTypes(new String[]{ResourceType.TemporarySecurity.name()});
                if (!"#1".equalsIgnoreCase(document.getSecurityStationId()) && (securityStationDocument = (RdSecurityStationDocument)(entityStream = (EntityStream)beanFactory.getBean(EntityStream.class)).of(RdSecurityStationDocument.class).filter((SearchFieldPredicate)RdSecurityStationDocument$.ID.eq((Object)document.getSecurityStationId())).findFirst().orElse(null)) != null) {
                    document.addScopePermissions(new String[]{securityStationDocument.getProjectId()});
                    stationTypes = securityStationDocument.getStationTypes();
                    document.setPaymentOrgId(securityStationDocument.getOrganizationId());
                }
            }
            document.setStationTypes(stationTypes);
            document.setLastUpdatedTime(Timestamp.from(Instant.now()));
            RdWorkstationRepository workstationRepository = (RdWorkstationRepository)beanFactory.getBean(RdWorkstationRepository.class);
            long countOfStations = workstationRepository.getCountOfStationsByEmployeeId(document.getId());
            document.updateCountOfStations((int)countOfStations);
            return document;
        }
        catch (Exception ex) {
            if (ExceptionUtil.getStackMessage((Throwable)ex).contains("no such index")) {
                throw new DocumentIndexNoFoundException("\u7d22\u5f15\u5f02\u5e38", ex);
            }
            logger.error("\u804c\u5458\u4fe1\u606f-\u89e3\u6790\u6570\u636e\u53d1\u751f\u5f02\u5e38:id={};name={}", new Object[]{ii.getId(), ii.getName(), ex});
            return null;
        }
    }
}

