/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.configs;

import java.util.concurrent.atomic.AtomicInteger;

public class SyncLimiter {
    private int maxCount = 1000;
    private long interval = 1L;
    private AtomicInteger atomicInteger = new AtomicInteger(0);
    private long startTime = System.currentTimeMillis();

    public boolean get() {
        if (this.atomicInteger.get() == 0) {
            this.startTime = System.currentTimeMillis();
            return true;
        }
        if (System.currentTimeMillis() - this.startTime > this.interval * 1000L) {
            this.startTime = System.currentTimeMillis();
            this.atomicInteger.set(1);
            return true;
        }
        return this.atomicInteger.get() <= this.maxCount;
    }

    public void set() {
        this.atomicInteger.addAndGet(1);
    }

    public int getMaxCount() {
        return this.atomicInteger.get();
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }
}

