package com.bcxin.backend.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.backend.configs.SmsConfig;
import com.bcxin.backend.dto.HuaWeiSmsContent;
import com.bcxin.backend.dto.SmsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class MessageUtil {
	final static Logger logger = LoggerFactory.getLogger(MessageUtil.class);

	/**
	 * 发送华为短信
	 * @param huaWeiSmsContent
	 * @return
	 */
	public static boolean sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
		boolean flag = false;
		Map<String,Object> params =  new HashMap<>();
		//环境标识
        huaWeiSmsContent.setChannel(SmsConfig.getChannel());
		huaWeiSmsContent.setPlatform(SmsConfig.getPlatform());
		params.put("data", JSON.toJSONString(huaWeiSmsContent));
		params.put("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.formatDate(DateUtil.date())));
		String result = HttpUtil.post(SmsConfig.getUrl(),params);

		SmsResult smsResult = JSON.parseObject(result,SmsResult.class);
		flag = smsResult.isSuccess();
		System.out.println(result);
		logger.info(result);

		return flag;
	}
	public static void testSendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
		Map<String,Object> params =  new HashMap<>();
		//环境标识
		params.put("data", JSON.toJSONString(huaWeiSmsContent));
		params.put("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.formatDate(DateUtil.date())));
		String result = HttpUtil.post("http://msg.ba.baibaodun.com.cn:9165/sms/huawei/sendSMS",params);
		System.out.println(result);
		logger.info(result);
	}




	public static void main(String[] args) {
		HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
		huaWeiSmsContent.setPlatform("V5");
		huaWeiSmsContent.setChannel("test");
		huaWeiSmsContent.setSmsCode("B1");
		huaWeiSmsContent.setParams("青康平,ZP培训机构安排您于2022-03-15 09:17:01.0进行《国家保安员证》考试，请您务必提前到测试扫码签到。届时请联系【考点联系人】：awn3SQyY :手机号:");
		huaWeiSmsContent.setMobile("15750701070");
		MessageUtil.testSendHuaWeiSMS(huaWeiSmsContent);
	}

}
