package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.services.DataSyncQueueService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SyncDataViaFtpJobTask extends TaskAbstract{
    private final DataSyncQueueService dataSyncQueueService;

    public SyncDataViaFtpJobTask(@Qualifier("FtpDataSyncQueueServiceImpl")
                                     DataSyncQueueService dataSyncQueueService) {
        this.dataSyncQueueService = dataSyncQueueService;
    }

    @Override
    protected void runCore() {
        this.dataSyncQueueService.dispatchData();
    }

    @Override
    public String getTaskName() {
        return "sync.data.ftp.data";
    }
}
