package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategyFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * 生成SignatureQueues记录
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class SignatureJobCreateTask extends TaskAbstract{
    @Value("${myapps.signature.serverKey}")
    String serverKey;

    @Override
    protected void runCore() {
        logger.error("====> 电子签章（生成SignatureQueues记录）定时任务开始：5分钟一次................");
        QzSignatureStrategy qzSignatureStrategy = QzSignatureStrategyFactory.getBYServerKey(serverKey);
        qzSignatureStrategy.cerSignatureQueues();
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.job.create_signature";
    }
}
