package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategyFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * 临时目录pdf剪切到in目录触发签章
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class SignatureJobCGITask extends TaskAbstract{

    @Value("${myapps.signature.serverKey}")
    String serverKey;
//    private final SignatureToPDFService signatureToPDFService;

//    public SignatureJobCGITask(SignatureToPDFService signatureToPDFService) {
//        this.signatureToPDFService = signatureToPDFService;
//    }


    @Override
    protected void runCore() {
        QzSignatureStrategy qzSignatureStrategy = QzSignatureStrategyFactory.getBYServerKey(serverKey);
        qzSignatureStrategy.signQuicklyExCGI();
//        signatureToPDFService.signQuicklyExCGI();
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.job.cgi";
    }

}
