package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.screening.service.InductionBackgroundScreeningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix = "myapps.screeninng",name = "enable",havingValue = "true")
public class InductionBackgroundScreeningTask extends TaskAbstract{

    private final InductionBackgroundScreeningService backgroundScreeningService;

    public InductionBackgroundScreeningTask(InductionBackgroundScreeningService backgroundScreeningService) {

        this.backgroundScreeningService = backgroundScreeningService;
    }

    @Override
    protected void runCore() throws Exception {
        logger.info("新用户的背景筛查");
        backgroundScreeningService.screening();
    }

    @Override
    public String getTaskName() {
        return "execute.Screening.job.induction";
    }


}
