package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.services.ExecuteAppTaskJobService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
public class ExecuteAppJobTask extends TaskAbstract{

    @Autowired
    private final ExecuteAppTaskJobService executeAppTaskJobService;


    public ExecuteAppJobTask(ExecuteAppTaskJobService executeAppTaskJobService) {
        this.executeAppTaskJobService = executeAppTaskJobService;

    }


    @Override
    protected void runCore() throws Exception {
        executeAppTaskJobService.executeTaskByTaskId();
    }

    @Override
    public String getTaskName() {
        return "execute.app.job";
    }
}
