package com.bcxin.backend.jobs;

import com.bcxin.backend.documentSignatrures.DocumentSignatureProvider;
import com.bcxin.backend.documentSignatrures.SignatureConfigProperty;
import com.bcxin.backend.tasks.TaskAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Collection;

/**
 * 文书签章功能
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class DocumentSignatureScheduleJob extends ScheduleJobAbstract{
    private final static Logger logger = LoggerFactory.getLogger(DocumentSignatureScheduleJob.class);
    private final SignatureConfigProperty signatureConfigProperty;

    public DocumentSignatureScheduleJob(SignatureConfigProperty signatureConfigProperty) {
        this.signatureConfigProperty = signatureConfigProperty;
    }

    @Scheduled(fixedDelay = 1 * 60 * 1000)
    public void prepareDocumentSignature() {
        DocumentSignatureProvider documentSignatureProvider = this.getBean(signatureConfigProperty.getAreaCode(),
                DocumentSignatureProvider.class
        );
        if (documentSignatureProvider == null) {
            logger.error("找不到符合实现:{}", signatureConfigProperty.getAreaCode());
            return;
        }
        documentSignatureProvider.step1_push2Queue();
    }

    @Scheduled(fixedDelay = 2 * 60 * 1000)
    public void doSignature() {
        DocumentSignatureProvider documentSignatureProvider = this.getBean(signatureConfigProperty.getAreaCode(),
                DocumentSignatureProvider.class
        );
        if (documentSignatureProvider == null) {
            logger.error("找不到符合实现:{}", signatureConfigProperty.getAreaCode());
            return;
        }

        documentSignatureProvider.step2_doSignature();
    }









    /**
     * <b> 北京内网初始生成文书签章数据 </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Deprecated
    public void initDocumentSignature() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.document.init");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * 重复的逻辑: todo: 去掉
     * <b> 北京内网重置文书正副本签章数据 </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Deprecated
    public void comparisonDocumentSignature() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.document.comparison");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * todo: 针对文书的功能，内网应用上警官可能会对文书进行变更，此时需要重新对文书进行签章处理
     * <b> 北京内网重置文书正副本签章数据 </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Deprecated
    public void resetDocumentSignature() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.document.reset");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * <b> 北京内网文书签章结果数据同步更新 </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Deprecated
    public void useDocumentSignature() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.document.use");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    @Deprecated
    public void checkSignatureStatus() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.document.check");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }
}
