package com.bcxin.backend.domain.screening.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.domain.models.Result;
import com.bcxin.backend.domain.models.ScreeningDTO;
import com.bcxin.backend.domain.screening.service.BackgrounpScreeningProvider;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * <b> 背筛接口访问实现 mock</b>
 * @author ZXF
 * @create 2022/09/22 0022 15:10
 * @version
 * @注意事项 </b>
 */
@Component("bsp_mock")
@Slf4j
public class BackgrounpScreeningProviderMockImpl implements BackgrounpScreeningProvider {

    @Autowired
    @Qualifier("primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;

    /**
     * <b> 单个身份证背筛 </b>
     * 返回结果定义：Result 里面有fail() success() 快捷方法直接使用
     *  Result.retType 放接口请求是否成功编码
     *  Result.data 放下面json格式
     * [{"isProblem":"0/1","detail":"吸毒人员,在逃嫌疑犯","idnum":"1111"}]
     *
     * @author ZXF
     * @create 2022/09/22 0022 15:33
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result<ScreeningDTO> screening(String idnum) {
        List<String> logList = new ArrayList<>();
        log.info(String.valueOf(idnum.hashCode()));
        if(idnum.hashCode()%5 == 0){
            StringBuilder message = new StringBuilder("{\"isProblem\":1,\"detail\":\"吸毒人员\",\"idnum\":");
            String result = appendString(message,idnum);
            System.out.println("result--->"+result);
            setLogList(logList,"2",idnum,"吸毒人员",result);
            saveLog(logList);
            return new Result().success(Result.SUCCESS_MSG,new ScreeningDTO(idnum,"1",result));
        }else if(idnum.hashCode()%6 == 0){
            StringBuilder message = new StringBuilder("{\"isProblem\":1,\"detail\":\"重点人员\",\"idnum\":");
            String result = appendString(message,idnum);
            System.out.println("result--->"+result);
            setLogList(logList,"2",idnum,"重点人员",result);
            saveLog(logList);
            return new Result().success(Result.SUCCESS_MSG,new ScreeningDTO(idnum,"1",result));
        }else if(idnum.hashCode()%7 == 0){
            StringBuilder message = new StringBuilder("{\"isProblem\":1,\"detail\":\"在逃人员\",\"idnum\":");
            String result = appendString(message,idnum);
            System.out.println("result--->"+result);
            setLogList(logList,"2",idnum,"在逃人员",result);
            saveLog(logList);
            return new Result().success(Result.SUCCESS_MSG,new ScreeningDTO(idnum,"1",result));
        }else{
            StringBuilder message = new StringBuilder("{\"isProblem\":0,\"detail\":\"\",\"idnum\":");
            String result = appendString(message,idnum);
            System.out.println("result--->"+result);
            return new Result().success(Result.SUCCESS_MSG,new ScreeningDTO(idnum,"1",result));
        }
    }

    public String appendString(StringBuilder builder,String idnum){
        builder.append(idnum);
        builder.append("}");
        log.info("data---->"+builder);
        return builder.toString();
    }

    /**
     * <b> 多个身份证背筛 </b>
     * 返回结果定义：Result 里面有fail() success() 快捷方法直接使用
     *  Result.retType 放接口请求是否成功编码
     *  Result.data 放下面json格式 （isProblem 0没问题1有问题 ，0时detail可以为空，1时detail不为空，idnum始终不能为空）
     * [{"isProblem":"0/1","detail":"吸毒人员,在逃嫌疑犯","idnum":"1111"},{"isProblem":"0/1","detail":"吸毒人员,在逃嫌疑犯","idnum":"222"}]
     *
     * @author ZXF
     * @create 2022/09/22 0022 15:33
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result<List<ScreeningDTO>> screenings(String[] idnums) {
        List<ScreeningDTO> list = Lists.newArrayList();
        for (String idnum : idnums) {
            List<String> logList = new ArrayList<>();
            log.info(String.valueOf(idnum.hashCode()));
            if(idnum.hashCode()%5 == 0){
                StringBuilder message = new StringBuilder("{\"isProblem\":1,\"detail\":\"吸毒人员\",\"idnum\":");
                String result = appendString(message,idnum);
                list.add(new ScreeningDTO(idnum,"1","吸毒人员"));
                setLogList(logList,"2",idnum,"吸毒人员",result);
                saveLog(logList);
            }else if(idnum.hashCode()%6 == 0){
                StringBuilder message = new StringBuilder("{\"isProblem\":1,\"detail\":\"重点人员\",\"idnum\":");
                String result = appendString(message,idnum);
                list.add(new ScreeningDTO(idnum,"1","重点人员"));
                setLogList(logList,"2",idnum,"重点人员",result);
                saveLog(logList);
            }else if(idnum.hashCode()%7 == 0){
                StringBuilder message = new StringBuilder("{\"isProblem\":1,\"detail\":\"在逃人员\",\"idnum\":");
                String result = appendString(message,idnum);
                list.add(new ScreeningDTO(idnum,"1","在逃人员"));
                setLogList(logList,"2",idnum,"在逃人员",result);
                saveLog(logList);
            }else{
                list.add(new ScreeningDTO(idnum,"0",""));
            }
        }
        System.out.println("result--->"+list);

        return new Result().success(Result.SUCCESS_MSG,list);
    }

    /**
     * <b> 日志sql组装多次数据 </b>
     * @author ZXF
     * @create 2022/09/22 0022 16:58
     * @version
     * @注意事项 </b>
     */
    private void setLogList(List<String> list, String type, String idnum, String short_result, String result){
        list.add("( '" + type + "',NOW(),'" + idnum + "','" + short_result + "','" + result + "' )");
    }

    /**
     * <b> 日志sql组装后保存 </b>
     * @author ZXF
     * @create 2022/09/22 0022 16:58
     * @version
     * @注意事项 </b>
     */
    private void saveLog(List<String> list){
        if(list.size()>0){
            String lStr = list.toString();
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO bg_screening_user_exec_logs (type,created_time,idnum,short_result,result) values" + lStr.substring(1,lStr.length()-1));
            jdbcTemplate.update(sb.toString());
        }
    }
}
