package com.bcxin.backend.domain.screening.service;

import com.bcxin.backend.domain.screening.factory.ScreeningFactory;
import com.bcxin.backend.domain.screening.service.impl.BackgroundScreeningServiceAbstractImpl;
import org.springframework.stereotype.Service;

/**
 * <b> 新入职背筛任务 </b>
 * @author ZXF
 * @create 2022/09/23 0023 9:57
 * @version
 * @注意事项 </b>
 */
@Service
public class InductionBackgroundScreeningService extends BackgroundScreeningServiceAbstractImpl {

    protected InductionBackgroundScreeningService(ScreeningFactory screeningFactory) {
        super(screeningFactory);
    }


    /**
     * <b> 有效人员身份证 </b>
     * @author ZXF
     * @create 2022/09/23 0023 9:55
     * @version
     * @注意事项 </b>
     */
    @Override
    public String numSql() {
        return
                "SELECT bs.idnum,bs.user_id FROM bg_screening_users bs " +
                        "WHERE " +
                        "bs.idnum IS NOT NULL " +
                        "AND bs.enabled=1 " +
                        "AND bs.last_background_screening_time IS NULL " +
                        "LIMIT 600;";
    }

}
