package com.bcxin.oa.old.service.web;

import com.bcxin.oa.old.dto.CountPerAttendDTO;
import com.bcxin.oa.old.dto.PerAttendDateDTO;
import com.bcxin.oa.old.dto.count.AppPerAttendCountDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

import javax.servlet.http.HttpServletResponse;

/**
 * 人员考勤日统计
 *
 * @author llc
 * @date 2018-12-03
 */
public interface CountPerAttendDateService {

    /**
     * 定时器生成考勤报表
     * @author llc
     * @date 2018-12-17
     * @param
     * @return
     */
    Result createAttendCountReport() throws BusinessException;

    /**
     * 获取人员考勤日统计情况
     * @author llc
     * @date 2018-12-03
     * @param dto
     * @return
     */
    Result getPerAttendDateCountList(CountPerAttendDTO dto) throws BusinessException;


    /**
     * 获取人员考勤月统计情况
     * @author llc
     * @date 2018-12-03
     * @param dto
     * @return
     */
    Result getPerAttendMonthCountList(CountPerAttendDTO dto)throws BusinessException;


    /**
     * 人员考勤月统计导出
     * @author llc
     * @date 2018-12-04
     * @param dto
     * @return
     */
    Result exportCountPerAttendMonth(CountPerAttendDTO dto, HttpServletResponse response)throws BusinessException;


    /**
     * 查询人员某日打卡详情
     * @author llc
     * @date 2018-12-06
     * @param dto
     * @return
     */
    Result getAttendRecodeList(PerAttendDateDTO dto)throws BusinessException;


    /**
     * 修改人员打卡记录
     * @author llc
     * @date 2018-12-06
     * @param dto
     * @return
     */
    Result updateAttendRecord(PerAttendDateDTO dto)throws BusinessException;


    /**
     * app内勤统计
     * @author llc
     * @date 2019-01-04
     * @param dto
     * @return
     */
    Result inStatisTics(AppPerAttendCountDTO dto)throws BusinessException;


}