package com.bcxin.oa.old.service.task;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.*;
import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.entity.enterprise.company.ComBaseInfo;
import com.bcxin.oa.old.entity.task.*;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.mapper.app.PerTaskCardRecordMapper;
import com.bcxin.oa.old.mapper.system.SysPoliceMapper;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.service.system.CacheService;
import com.bcxin.oa.old.service.task.bbd.BbdTestService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.*;

/**
 * 驻勤
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
@Service
@Transactional
public class ComTaskServiceImpl implements ComTaskService {

    @Resource
    private ComTaskMapper comTaskMapper;
    @Resource
    private ComShiftMapper comShiftMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private ComTaskFixedMapper comTaskFixedMapper;
    @Resource
    private ComTaskAttendAddressMapper comTaskAttendAddressMapper;
    @Resource
    private ComTaskImplementMapper comTaskImplementMapper;
    @Resource
    private CommonService commonService;
    @Resource
    private MidTaskMapper midTaskMapper;
    @Resource
    private MidTaskDetailMapper midTaskDetailMapper;

    @Resource
    private ComTaskShiftMapper comTaskShiftMapper;

    @Resource
    private ComTaskSchedulMapper comTaskSchedulMapper;

    @Resource
    private ComTaskSchedulCycleMapper comTaskSchedulCycleMapper;

    @Resource
    private ComTaskCycleShiftMapper comTaskCycleShiftMapper;

    @Resource
    private ComTaskInsidePushMapper comTaskInsidePushMapper;

    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;

    @Resource
    private ValidateTaskFixedPerMapper validateTaskFixedPerMapper;

    @Resource
    private ValidateTaskFixedMapper validateTaskFixedMapper;
    @Resource
    private BbdTestService bbdTestService;

    @Resource
    private ComTaskPerShiftService comTaskPerShiftService;

    @Resource
    private TaskCardRemindMapper taskCardRemindMapper;

    @Resource
    private ComShiftRuleMapper comShiftRuleMapper;

    @Resource
    private PerTaskCardRecordMapper perTaskCardRecordMapper;

    @Resource
    private SysPoliceMapper sysPoliceMapper;

    @Resource
    private CacheService cacheService;

    @Resource
    private IdWorker idWorker;


    @Override
    public Result treeForTaskType(ComTaskDto comTaskDto) {
        List<ConifgTaskBigTypeDTO> bigTypeDTOS = new ArrayList<ConifgTaskBigTypeDTO>();
        List<Map> mapList = comTaskMapper.listForTaskType(comTaskDto);
        Map haveMaps = new HashMap();
        for (Map map : mapList) {
            if (!haveMaps.containsKey(map.get("bigKey").toString())) {
                ConifgTaskBigTypeDTO conifgTaskBigTypeDTO = new ConifgTaskBigTypeDTO();
                // t1.taskType as 'key',t1.name as value,t2.taskBigType as
                // 'bigKey',t2.name as bigValue
                conifgTaskBigTypeDTO.setBigKey(map.get("bigKey").toString());
                conifgTaskBigTypeDTO.setBigValue(map.get("bigValue").toString());
                conifgTaskBigTypeDTO.setChildren(this.childrenTaskType(map.get("bigKey").toString(), mapList));
                bigTypeDTOS.add(conifgTaskBigTypeDTO);
                haveMaps.put(map.get("bigKey").toString(), map.get("bigKey").toString());
            }
        }

        return Result.success("", bigTypeDTOS);
    }

    private List<ConifgTaskTypeDTO> childrenTaskType(String bigKey, List<Map> mapList) {
        List<ConifgTaskTypeDTO> taskTypeDTOS = new ArrayList<ConifgTaskTypeDTO>();
        for (Map taskTypeMap : mapList) {
            String childrenBigKey = taskTypeMap.get("bigKey").toString();
            if (StringUtils.isNotEmpty(childrenBigKey) && childrenBigKey.equals(bigKey)) {
                ConifgTaskTypeDTO conifgTaskTypeDTO = new ConifgTaskTypeDTO();
                conifgTaskTypeDTO.setKey(taskTypeMap.get("key").toString());
                conifgTaskTypeDTO.setValue(taskTypeMap.get("value").toString());
                taskTypeDTOS.add(conifgTaskTypeDTO);
            }
        }
        return taskTypeDTOS;
    }

    /**
     * 分页查询驻勤列表
     *
     * @param comTaskDto
     * @Title: listTask
     * @Description:
     * @return: Result by llc 2017-12-12
     */
    @Override
    public Result pageTaskList(ComTaskDto comTaskDto) {
        if (comTaskDto.getComId() == null || comTaskDto.getComId().toString() == "") {
            return Result.fail("公司Id不能为空", comTaskDto.getComId());
        }
        PageHelper.startPage(comTaskDto.getPageNumber(), comTaskDto.getPageSize());

		/* 驻勤表的驻勤类型只存小驻勤类型 所以转换驻勤类型 010002,01000205 安保服务/押运 ***/
        if (comTaskDto.getTaskType() != null && comTaskDto.getTaskType().contains(",")) {
            comTaskDto.setTaskType(comTaskDto.getTaskType().substring(comTaskDto.getTaskType().lastIndexOf(",") + 1));
        }
        List<Map<String, Object>> list = comTaskMapper.getTaskList(comTaskDto);
        PageInfoUtils pageInfo = new PageInfoUtils(list);
        return Result.success("", pageInfo);
    }


    /**
     * 导出驻勤列表
     *
     * @param dto
     * @return
     * @throws BusinessException
     * @author llc
     * @date 2020-04-07
     */
    @Override
    public Result exportTaskList(ComTaskDto dto, HttpServletResponse response) throws BusinessException {
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            String fileName = "_" + "驻勤列表" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("驻勤");

            List<Map<String, String>> taskList = comTaskMapper.getExportTaskList(dto);

            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            /**** 生成sheet1的内容 ***/
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 11);
            titleFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            titleFont.setFontName("黑体");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);// 水平居中
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));

            /*** 填充第一行数据 ***/
            HSSFRow rowFirst = sheet1.createRow(0);
            String[] firstArr = {"序号", "驻勤ID", "驻勤点", "驻勤状态", "驻勤点类型", "驻勤起止时间", "驻勤地址", "驻勤精确地址","负责人姓名", "负责人身份证", "负责人手机", "驻勤人数",
                    "合同名称", "甲方名称", "乙方名称", "丙方名称", "企业档案编号", "合同有效期"};
            int column;
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第二行的每个单元格
                if (i == 0) {
                    column = 1500;
                } else if (i == 2 || i == 6 || i == 7 || i == 12) {
                    column = 7000;
                } else if (i == 1 || i == 5 || i == 9 || i == 17) {
                    column = 6000;
                } else {
                    column = 4000;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                cell.setCellStyle(titleStyle); // 文本格式
            }

            /*** 填充第一行数据 ***/
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第一行的每个单元格
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(titleStyle);
            }

            /*** 字体颜色样式 ***/
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);// 青绿色样式
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index); // 红色样式
            HSSFRow row = null;
            int rowIndex = 1;
            for (Map<String, String> result : taskList) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(rowIndex);
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("comTaskId") != null ? result.get("comTaskId") : null); // 驻勤ID
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("taskName") != null ? result.get("taskName") : null); // 驻勤点
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("taskEffect") != null ? result.get("taskEffect") : null); // 驻勤状态
                if (result.get("taskEffect").equalsIgnoreCase("生效")) {
                    cell3.setCellStyle(greenStyle);
                } else if (result.get("taskEffect").equalsIgnoreCase("终止")) {
                    cell3.setCellStyle(redStyle);
                }
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("taskStationType") != null ? result.get("taskStationType") : null); // 驻勤点类型
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("taskSection") != null ? result.get("taskSection") : null); // 驻勤起止时间
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("taskAddress") != null ? result.get("taskAddress") : null); // 驻勤地址
                cell6.setCellStyle(redStyle);
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("taskExactAddress") != null ? result.get("taskExactAddress") : null); // 驻勤精确地址
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("chargePerName") != null ? result.get("chargePerName") : null);// 负责人姓名
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("chargePerIdCardNo") != null ? result.get("chargePerIdCardNo") : null);// 负责人身份证
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("chargePerMobilePhone") != null ? result.get("chargePerMobilePhone") : null);// 负责人手机
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("perNum") != null ? result.get("perNum") : null);// 驻勤人数
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("contractName") != null ? result.get("contractName") : null);// 合同名称
                HSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(result.get("firstPartyName") != null ? result.get("firstPartyName") : null);// 甲方名称
                HSSFCell cell14 = row.createCell(14);
                cell14.setCellValue(result.get("secondPartyName") != null ? result.get("secondPartyName") : null);// 乙方名称
                HSSFCell cell15 = row.createCell(15);
                cell15.setCellValue(result.get("thirdPartyName") != null ? result.get("thirdPartyName") : null);// 丙方名称
                HSSFCell cell16 = row.createCell(16);
                cell16.setCellValue(result.get("comFileNo") != null ? result.get("comFileNo") : null);// 合同企业档案编号
                HSSFCell cell17 = row.createCell(17);
                cell17.setCellValue(result.get("contractSection") != null ? result.get("contractSection") : null);// 合同有效期
                rowIndex++;
            }
            wb.write(os);
            os.close();
        } catch (Exception e) {
            throw new BusinessException(Result.ERROR, e.getMessage());
        } finally {
            try {
                os.close();
            } catch (IOException e1) {
            }
        }
        return Result.success("导出驻勤数据文件失败");
    }

    /**
     * 改变地址格式，编码返回成数组,返回dto
     */
    private ComTaskDto codeAddressChangeToArray(ComTask comTask) {
        ComTaskDto comTaskDto = new ComTaskDto();
        BeanUtil.copyProperties(comTask, comTaskDto);
        int[] address = new int[3];
        address[0] = comTask.getProvince();
        address[1] = comTask.getCity();
        address[2] = comTask.getArea();
        comTaskDto.setAllAddress(address);
        String taskType = comTaskDto.getTaskType();
        /* 转换驻勤类型名称 安保服务/押运 ***/
        if (StringUtils.isNotEmpty(taskType)) {
            Map<String, String> resultMap = comTaskMapper.getTaskTypeName(comTask.getComId(), taskType);
            if (resultMap != null) {
                comTaskDto.setTaskBigType(resultMap.get("taskBigType"));
                comTaskDto.setTaskTypeName(resultMap.get("taskTypeName"));
            }
        }
        return comTaskDto;
    }

    /**
     * 改变地址格式，数组格式地址返回成code,返回dto
     */
    private ComTaskDto arrayAddressChangeToCode(ComTaskDto comTaskDto) throws BusinessException {
        // 前台传递过来的就是一个数组 ，需要自己判断
        int address[] = comTaskDto.getAllAddress();
        if (address.length == 0) {
            throw new BusinessException(Result.ERROR, "省市区数组为空");
        } else {
            comTaskDto.setProvince(address[0]);
            comTaskDto.setCity(address[1]);
            comTaskDto.setArea(address[2]);
        }
        return comTaskDto;
    }

    @Override
    public Result getIndustriesList(ComTaskDto comTaskDto) {
        // 获取行业类型·
        // 获取登陆信息 ，查询企业的行业类型和机构类型, code字段，写一个方法就行
        if (comTaskDto.getComId() == null || comTaskDto.getComId() == 0L) {
            return Result.fail("公司Id不能为空", comTaskDto.getComId());
        }
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(comTaskDto.getComId());
        return Result.success("", comTaskMapper.getIndustriesList(comBaseInfo.getInstitutionType(),
                comBaseInfo.getIndustryType(), "taskType"));
    }

    @Override
    public Result getServerTypeList(ComTaskDto comTaskDto) {
        // 获取服务类型
        // 获取登陆信息 ，查询企业的行业类型和机构类型, code字段，写一个方法就行
        if (comTaskDto.getComId() == null || comTaskDto.getComId() == 0L) {
            return Result.fail("公司Id不能为空", comTaskDto.getComId());
        }
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(comTaskDto.getComId());
        return Result.success("", comTaskMapper.getIndustriesList(comBaseInfo.getInstitutionType(),
                comBaseInfo.getIndustryType(), "serviceType"));
    }

    /**
     * ---------------------------整合驻勤接口-钟建辉----------------------------------------------------------------
     **/
    /**
     * ---------------------------整合驻勤接口-第一步----------------------------------------------------------------
     **/
    @Override
    public Result getStepOneDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
        // 驻勤ID
        Long taskId = comTaskTempDTO.getComTaskId();
        if (taskId == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID为空");
        }
        // 查找驻勤ID是否存在
        ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
        ComTaskDto resultDto = new ComTaskDto();
        // 实体为空则查询缓存
        if (comTask == null) {
            MidTask midTask = midTaskMapper.getByPrimaryKey(taskId);
            if (midTask == null) {
                throw new BusinessException(Result.ERROR, "未找到驻勤信息");
            }
            List<MidTaskDetail> midTaskDetails = midTaskDetailMapper.getByMidTaskId(midTask.getMidTaskId(), "1");
            if (midTaskDetails.size() == 1) {
                comTask = JSON.parseObject(midTaskDetails.get(0).getContent(), ComTask.class);
                resultDto = codeAddressChangeToArray(comTask);
            } else {
                throw new BusinessException(Result.ERROR, "未找到驻勤详情信息");
            }
        } else {
            resultDto = codeAddressChangeToArray(comTask);
        }
        List<Map<String, Object>> comContractList = comTaskMapper.getRelationContractList(comTask);
        resultDto.setComContractList(comContractList);
        return Result.success(Result.SUCCESS_QUERY_MSG, resultDto);
    }

    @Override
    public Result saveStepOneDetail(ComTaskDto comTaskDto) throws BusinessException {
        if (comTaskDto.getComContractId() == null) {
            return Result.fail("必须关联合同！");
        }
        ComTask comTask = new ComTask();
        comTask.setCreateBy(comTaskDto.getCreateBy());
        comTaskDto = this.arrayAddressChangeToCode(comTaskDto);
        ObjectUtils.copyProperties(comTask, comTaskDto);

        if (comTaskDto.getComTaskId() == null) {
            comTask.setTaskStatus(DictConst.TASKSTATUS_WFB);
            // 新增，直接加入暂存表
            MidTask midTask = new MidTask();
            ObjectUtils.copyProperties(midTask, comTaskDto);
            Long taskNewId = idWorker.nextId();
            midTask.setMidTaskId(taskNewId);
            midTask.setComId(comTaskDto.getComId());
            midTask.setPerId(comTaskDto.getCreateBy());
            if (midTaskMapper.insert(midTask) <= 0) {
                throw new BusinessException(Result.ERROR, "新增暂存驻勤失败");
            }
            MidTaskDetail midTaskDetail = new MidTaskDetail();
            ObjectUtils.copyProperties(midTaskDetail, midTask);
            midTaskDetail.setMidTaskDetailId(idWorker.nextId());
            midTaskDetail.setStage(1);
            midTaskDetail.setContent(JSON.toJSON(comTask).toString());
            midTaskDetail.setComId(comTaskDto.getComId());
            midTaskDetail.setCreateBy(comTaskDto.getCreateBy());
            if (midTaskDetailMapper.insert(midTaskDetail) <= 0) {
                throw new BusinessException(Result.ERROR, "新增暂存驻勤详情失败");
            }
            return Result.success("", taskNewId.toString());
        } else {
            // 驻勤ID
            Long taskId = comTaskDto.getComTaskId();
            // 查找考勤组ID是否存在,如果存在则修改考勤类型
            ComTask comTask1 = comTaskMapper.getByPrimaryKey(taskId);

            // 实体为空则查询缓存
            if (comTask1 == null) {
                MidTask midTask = midTaskMapper.getByPrimaryKey(taskId);
                if (midTask == null) {
                    throw new BusinessException(Result.ERROR, "根据id未找到驻勤信息");
                }
                List<MidTaskDetail> midTaskDetails = midTaskDetailMapper.getByMidTaskId(taskId, "1");
                if (midTaskDetails.size() == 1) {
                    for (MidTaskDetail midTaskDetail : midTaskDetails) {
                        midTaskDetail.setContent(JSON.toJSON(comTask).toString());
                        if (midTaskDetailMapper.update(midTaskDetail) <= 0) {
                            throw new BusinessException(Result.ERROR, "修改驻勤中间详情失败");
                        }
                        return Result.success("", comTask.getComTaskId());
                    }
                } else {
                    throw new BusinessException(Result.ERROR, "未找到中间驻勤详情");
                }
                return Result.success("", comTask.getComTaskId());
            } else {

                /*** 校验驻勤点名称的唯一性 ***/

                if (comTaskMapper.checkTaskNameUnique(comTask.getComId(), comTask.getComTaskId(), comTask.getTaskName()) > 0) { // 校验档案标号唯一性
                    throw new BusinessException(Result.BUSINESS_ERROR, "驻勤点名称已经存在，请修改驻勤点名称");
                }

                /** 校验当前日期是否晚于驻勤开始日期 驻勤开始日期早于（包含等于）当前日期，驻勤状态为进行中
                 * 驻勤开始日期晚于当前日期，驻勤状态为未开始 by llc 2018-09-25
                 **/
                if (DateUtils.dateCompare(DateUtils.formatDate(comTask.getStartDate()), DateUtils.getDate())) {
                    /*** 由于放开限制可以录入已结束的驻勤，所以校验当前日期早于（包含等于）驻勤结束日期驻勤状态为进行中 ***/
                    if (DateUtils.dateCompare(DateUtils.getDate(), DateUtils.formatDate(comTask.getEndDate()))) {
                        comTask.setTaskStatus(DictConst.TASKSTATUS_JXZ);
                    } else {
                        comTask.setTaskStatus(DictConst.TASKSTATUS_YJS);
                    }
                } else {
                    comTask.setTaskStatus(DictConst.TASKSTATUS_WKS);
                }

                /*** 获取所选公安机构对应的百保盾ID ***/
                Long policeId = comTaskDto.getPoliceStationId() == null ? (comTaskDto.getDistrictOrgId() == null ? comTaskDto.getCityOrgId() : comTaskDto.getDistrictOrgId()) : comTaskDto.getPoliceStationId();

                Long bbdId = sysPoliceMapper.getBbdIdByPoliceId(policeId);
                comTask.setBbdId(bbdId);
                if (comTaskMapper.update(comTask) <= 0) {
                    throw new BusinessException(Result.ERROR, "修改驻勤失败");
                }

                /*** 如果驻勤开始日期修改,需要同步修改驻勤人员的开始时间 by llc 2020-03-05 ***/
                if (!ObjectUtils.equals(comTask1.getStartDate(), comTask.getStartDate())) {
                    comTaskInsidePushMapper.updateTaskPerPeriod(comTaskDto.getUpdateBy(), comTaskDto.getComTaskId(), comTask1.getStartDate(), comTask.getStartDate());
                }

                /*** 同步百保盾 ***/
                comTaskDto.setBbdId(bbdId);
                comTaskDto.setTaskStatus(comTask.getTaskStatus());

                ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(comTaskDto.getComId());
                String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
                /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
                if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//                    bdpSyncService.updateTask(comTaskDto);
                }else{
                    bbdTestService.bbdSaveOrUpdateTask(comTaskDto);
                }
                /*** 发布驻勤通知 ***/
                String title = MsgConst.TYPE_020105_TASK_CHANGE_TITLE;
                String content = MsgConst.TYPE_020105_TASK_CHANGE_CONTENT;
                String createrName = perBaseInfoMapper.getNameById(comTaskDto.getCreateBy());
                content = content.replace("{taskName}", comTask1.getTaskName()).replace("{operate}", createrName);
                commonService.sendMessageToApp(title, content, DictMessageTypeConst.MESSAGETYPE_020105, comTask1.getChargePerId().toString(),
                        comTaskDto.getComId(), taskId);
                return Result.success("", comTask.getComTaskId());
            }
        }
    }

    /**
     * ---------------------------整合驻勤接口-第二步----------------------------------------------------------------
     **/
    @Override
    public Result getStepTwoDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
        Map<String, Object> map = new HashMap<>();
        // 驻勤ID
        Long taskId = comTaskTempDTO.getComTaskId();
        if (taskId == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID为空");
        }
        // 查找考勤组ID是否存在,如果存在则修改考勤类型
        ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
        // 实体为空则查询缓存
        if (comTask == null) {
            MidTask midTask = midTaskMapper.getByPrimaryKey(taskId);
            if (midTask == null) {
                throw new BusinessException(Result.ERROR, "未找到驻勤信息");
            }
            List<MidTaskDetail> midTaskDetails = midTaskDetailMapper.getByMidTaskId(midTask.getMidTaskId(), "2");

            /*** 获取第一步驻勤所选城市作为第二步的考勤地址使用 ***/
            MidTaskDetail firstMidTaskDetail = midTaskDetailMapper.getDetailByIdAndStage(midTask.getMidTaskId(), "1");

            comTask = JSON.parseObject(firstMidTaskDetail.getContent(), ComTask.class);

            String taskCityName = comTaskMapper.getRegionFullName(comTask.getCity());

            map.put("taskCityName", taskCityName);

            if (midTaskDetails.size() == 1) {
                ComTaskReturnDTO comTaskReturnDTO = this.stepTwochange(midTaskDetails.get(0));
                map.put("attendType", comTaskReturnDTO.getAttendType());
                // 所有都可编辑
                map.put("canEdit", ComTaskTempDTO.ALL_CAN_EDIT);
                map.put("PBZ", comTaskReturnDTO.getComTaskSchedulTempDTO());
                map.put("GDBZ", comTaskReturnDTO.getComTaskFixedTempDTO());
                // 是否新增
                map.put("ISNEW", CommonConst.N);
            } else if ((midTaskDetails.size() < 1)) {
                // 是新增
                map.put("ISNEW", CommonConst.Y);
                map.put("PBZ", null);
                map.put("GDBZ", null);
            }
            return Result.success("", map);
        } else {
            String canEdit = ComTaskTempDTO.SOME_CAN_EDIT;
            String taskStatus = comTask.getTaskStatus();

            if (DictConst.TASKSTATUS_WKS.equals(taskStatus) || DictConst.TASKSTATUS_WFB.equals(taskStatus)) {
                // 未发布，未开始驻勤可以全部编辑
                canEdit = ComTaskTempDTO.ALL_CAN_EDIT;
            } else if (DictConst.TASKSTATUS_YYQ.equals(taskStatus) || DictConst.TASKSTATUS_YQX.equals(taskStatus)
                    || DictConst.TASKSTATUS_YJS.equals(taskStatus)) {
                // 已完成3、已取消5、已结束8全部不能修改
                canEdit = ComTaskTempDTO.ALL_CAN_NOT_EDIT;
            }

            // 查询驻勤考勤类型
            String attendType = comTask.getAttendType();
            map.put("canEdit", canEdit);
            map.put("attendType", attendType);
            comTaskTempDTO.setAttendType(attendType);
            String taskCityName = comTaskMapper.getRegionFullName(comTask.getCity());
            map.put("taskCityName", taskCityName);

            if (attendType.equals(DictConst.ATTENDTYPE_PBZ)) {
                // 排班制,2
                map.put("ISNEW", CommonConst.N);
                map.put("PBZ", this.selectComTaskSchedulCycle(comTaskTempDTO));
                map.put("GDBZ", null);
            } else if (attendType.equals(DictConst.ATTENDTYPE_GDBZ)) {
                // 固定班制,1
                map.put("ISNEW", CommonConst.N);
                map.put("PBZ", null);
                map.put("GDBZ", this.getFixDetail(comTaskTempDTO));
            }
            return Result.success("", map);
        }
    }

    /**
     * @param comTaskTempDTO
     * @Author: zhongjianhui
     * @Description:驻勤获取固定排班第二步详情
     * @Date: 2018/03/07 14:05
     */

    private ComTaskFixedTempDTO getFixDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
        // 驻勤ID
        Long taskId = comTaskTempDTO.getComTaskId();
        if (taskId == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID为空");
        }
        // 查找考勤组ID是否存在,如果存在则修改考勤类型
        ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
        if (comTask == null) {
            throw new BusinessException(Result.ERROR, "驻勤不存在");
        }
        ComTaskFixedTempDTO comTaskFixedTempDTO = new ComTaskFixedTempDTO();
        comTaskFixedTempDTO.setComTaskId(taskId);
        comTaskFixedTempDTO.setAttendType(comTask.getAttendType());
        List<ComTaskFixedDTO> comTaskFixedDTOList = new ArrayList<>();
        ComTaskFixed comTaskFixed1 = new ComTaskFixed();
        ObjectUtils.copyProperties(comTaskFixed1, comTaskTempDTO);
        // 根据驻勤id获取固定排班制信息
        List<ComTaskFixed> comAttendGroupFixedList = comTaskFixedMapper.listComTaskFixed(comTaskFixed1);
        if (comAttendGroupFixedList != null && comAttendGroupFixedList.size() > 0) {
            for (ComTaskFixed comTaskFixed : comAttendGroupFixedList) {
                ComTaskFixedDTO comTaskFixedReturnDTO = new ComTaskFixedDTO();
                ObjectUtils.copyProperties(comTaskFixedReturnDTO, comTaskFixed);
                Long shiftId = comTaskFixed.getShiftId();

                if (shiftId != -1) {
                    ComShift comShift = comShiftMapper.getByPrimaryKey(shiftId);
                    comTaskFixedReturnDTO.setShiftName(comShift.getShiftName());
                    if (CommonConst.Y.equals(comTaskFixedReturnDTO.getIsRest())) {
                        comTaskFixedReturnDTO.setShiftDetails("休息");
                    } else {
                        comTaskFixedReturnDTO.setShiftDetails(commonService.listChangeToString(shiftId, false, true));
                    }
                } else {
                    comTaskFixedReturnDTO.setShiftName("休息");
                    comTaskFixedReturnDTO.setShiftDetails("休息");
                }
                comTaskFixedDTOList.add(comTaskFixedReturnDTO);
            }

        }
        // 根据驻勤id获取考勤地点
        comTaskFixedTempDTO
                .setReturnComTaskAttendAddressList(comTaskAttendAddressMapper.listComTaskAttendAddress(taskId));
        comTaskFixedTempDTO.setReturnComTaskFixedDList(comTaskFixedDTOList);

        return comTaskFixedTempDTO;
    }

    /**
     * 将暂存表考勤转成实体
     */
    private ComTaskReturnDTO stepTwochange(MidTaskDetail midTaskDetail) {
        ComTaskReturnDTO comTaskReturnDTO = new ComTaskReturnDTO();
        ComTaskTempDTO comTaskTempDTO1 = JSON.parseObject(midTaskDetail.getContent(), ComTaskTempDTO.class);

        String attendType = comTaskTempDTO1.getAttendType();
        comTaskReturnDTO.setAttendType(attendType);
        if (attendType.equals(DictConst.ATTENDTYPE_PBZ)) {
            ComTaskSchedulTempDTO comTaskSchedulTempDTO = new ComTaskSchedulTempDTO();
            comTaskSchedulTempDTO.setAttendType(attendType);
            // 获取排班制
            List<ComTaskSchedulCycleDTO> listSchedulCycle = this.getShiftNameStr(
                    JSON.parseArray(comTaskTempDTO1.getComTaskSchedulCycleJson(), ComTaskSchedulCycleDTO.class));
            comTaskSchedulTempDTO.setReturnComTaskSchedulCycleList(listSchedulCycle);
            List<ComTaskAttendAddress> listComTaskAttendAddress = JSON
                    .parseArray(comTaskTempDTO1.getComTaskAttendAdresses(), ComTaskAttendAddress.class);
            comTaskSchedulTempDTO.setReturnComTaskAttendAddressList(listComTaskAttendAddress);
            List<ComShiftDto> listShift = JSON.parseArray(comTaskTempDTO1.getShiftIdJson(), ComShiftDto.class);
            // 查询出勤班次的时间安排
            if (listShift != null && listShift.size() > 0) {
                for (ComShiftDto comShiftDto : listShift) {
                    ComShift comShift = comShiftMapper.getByPrimaryKey(comShiftDto.getShiftId());
                    comShiftDto.setShiftName(comShift.getShiftName());
                    comShiftDto
                            .setShiftRuleTime(commonService.listChangeToString(comShiftDto.getShiftId(), false, true));
                }
            }
            comTaskSchedulTempDTO.setComShifts(listShift);
            // 排班制,2
            comTaskReturnDTO.setComTaskSchedulTempDTO(comTaskSchedulTempDTO);
        } else if (attendType.equals(DictConst.ATTENDTYPE_GDBZ)) {
            // 固定班制,1
            ComTaskFixedTempDTO comTaskFixedReturnDTO = new ComTaskFixedTempDTO();
            // 获取地址
            List<ComTaskAttendAddress> comTaskAttendAddresslist = JSON
                    .parseArray(comTaskTempDTO1.getComTaskAttendAdresses(), ComTaskAttendAddress.class);
            comTaskFixedReturnDTO.setReturnComTaskAttendAddressList(comTaskAttendAddresslist);
            // 获取固定班制
            List<ComTaskFixedDTO> comTaskFixedDlist = JSON.parseArray(comTaskTempDTO1.getComTaskFixeds(),
                    ComTaskFixedDTO.class);
            List<ComTaskFixedDTO> list = new ArrayList<ComTaskFixedDTO>();
            for (ComTaskFixedDTO comTaskFixedDto : comTaskFixedDlist) {

                if (comTaskFixedDto.getShiftId() != null) {
                    String shiftDetails = "休息";
                    if (comTaskFixedDto.getShiftId() != -1) {
                        shiftDetails = commonService.listChangeToString(comTaskFixedDto.getShiftId(), true, true);
                    }
                    comTaskFixedDto.setShiftDetails(shiftDetails);
                }
                list.add(comTaskFixedDto);
            }
            comTaskFixedReturnDTO.setReturnComTaskFixedDList(list);
            comTaskFixedReturnDTO.setAttendType(attendType);
            comTaskReturnDTO.setComTaskFixedTempDTO(comTaskFixedReturnDTO);
        }
        return comTaskReturnDTO;
    }

    /**
     * 驻勤-出勤设置-排班制-查询（第二步）
     *
     * @param comTaskTempDTO
     * @return
     * @throws BusinessException
     * @author zhongjianhui
     * @date 2018/03/06
     */
    private ComTaskSchedulTempDTO selectComTaskSchedulCycle(ComTaskTempDTO comTaskTempDTO) {

        // 查询出勤班次
        List<ComShiftDto> listShift = comTaskShiftMapper.selectComTaskShiftByTaskId(comTaskTempDTO.getComTaskId());

        // 查询出勤班次的时间安排
        if (listShift != null && listShift.size() > 0) {
            for (ComShiftDto comShiftDto : listShift) {
                comShiftDto.setShiftRuleTime(commonService.listChangeToString(comShiftDto.getShiftId(), false, true));
            }
        }

        // 查询周期排班信息
        List<ComTaskSchedulCycleDTO> listSchedulCycle = this.getShiftNameStr(
                comTaskSchedulCycleMapper.selectComTaskSchedulCycleByComTaskId(comTaskTempDTO.getComTaskId()));

        // 查询出勤地点
        List<ComTaskAttendAddress> listComTaskAttendAddress = comTaskAttendAddressMapper
                .listComTaskAttendAddress(comTaskTempDTO.getComTaskId());

        ComTaskSchedulTempDTO comTaskSchedulTempDTO = new ComTaskSchedulTempDTO();
        comTaskSchedulTempDTO.setAttendType(comTaskTempDTO.getAttendType());
        comTaskSchedulTempDTO.setReturnComTaskSchedulCycleList(listSchedulCycle);
        comTaskSchedulTempDTO.setReturnComTaskAttendAddressList(listComTaskAttendAddress);
        comTaskSchedulTempDTO.setComShifts(listShift);
        return comTaskSchedulTempDTO;
    }

    private List<ComTaskSchedulCycleDTO> getShiftNameStr(List<ComTaskSchedulCycleDTO> listSchedulCycle) {
        if (listSchedulCycle != null && listSchedulCycle.size() > 0) {
            /* 班次A，一天2班2个次日班，一天3班班次，班次190，班次99 晚班班次260，保安组日常班次 */
            for (ComTaskSchedulCycleDTO comTaskSchedulCycleDTO : listSchedulCycle) {

                // 定义班次名称字符串
                String shiftNameStr = "";

                // 查询驻勤排班周期所选班次
                List<ComTaskCycleShiftDTO> listComTaskCycleShift = comTaskCycleShiftMapper
                        .getTaskCycleShiftById(comTaskSchedulCycleDTO.getTaskSchedulCycleId());

                // 创建驻勤排班周期所选班次列表
                List<ComTaskCycleShiftDTO> listComTaskCycleShiftDTO = new ArrayList<>();

                // 将查询驻勤排班周期所选班次加入到驻勤排班周期对象的列表中
                if (listComTaskCycleShift != null && listComTaskCycleShift.size() > 0) {

                    for (ComTaskCycleShiftDTO taskCycleShiftDTO : listComTaskCycleShift) {

                        ComTaskCycleShiftDTO comTaskCycleShiftDTO = new ComTaskCycleShiftDTO();

                        ObjectUtils.copyProperties(comTaskCycleShiftDTO, taskCycleShiftDTO);

                        if ("1".equals(taskCycleShiftDTO.getIsRest())) {
                            comTaskCycleShiftDTO.setShiftName("休息");
                        } else {
                            if (taskCycleShiftDTO.getShiftId() != null) {
                                taskCycleShiftDTO.setShiftRuleTime(
                                        commonService.listChangeToString(taskCycleShiftDTO.getShiftId(), false, true));
                            }
                        }

                        // 拼接定义班次名称字符串
                        shiftNameStr += comTaskCycleShiftDTO.getShiftName() + ",";
                        // 将查询驻勤排班周期所选班次加入到驻勤排班周期对象的列表中
                        listComTaskCycleShiftDTO.add(comTaskCycleShiftDTO);
                    }

                } else if (comTaskSchedulCycleDTO.getShiftIdArrayUse() != null) {
                    for (String shiftIdStr : comTaskSchedulCycleDTO.getShiftIdArrayUse()) {
                        Long shiftId = Long.valueOf(shiftIdStr);
                        String shiftName = "休息";
                        String shiftRuleTime = "";
                        /* 休息的id是负一 */
                        if (shiftId > 0) {
                            shiftName = comShiftMapper.getByPrimaryKey(shiftId).getShiftName();
                            shiftRuleTime = commonService.listChangeToString(shiftId, false, true);
                        }
                        shiftNameStr += shiftName + ",";
                        ComTaskCycleShiftDTO comTaskCycleShiftDTO = new ComTaskCycleShiftDTO();
                        comTaskCycleShiftDTO.setShiftName(shiftName);
                        comTaskCycleShiftDTO.setShiftId(shiftId);
                        comTaskCycleShiftDTO.setShiftRuleTime(shiftRuleTime);
                        listComTaskCycleShiftDTO.add(comTaskCycleShiftDTO);
                    }

                }
                // 设置排班列表
                comTaskSchedulCycleDTO.setComTaskCycleShift(listComTaskCycleShiftDTO);
                // 设置班次名称字符串
                comTaskSchedulCycleDTO.setShiftNameStr(shiftNameStr);
            }
        }
        return listSchedulCycle;
    }

    @Override
    public Result saveStepTwoDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
        // 驻勤ID
        Long taskId = comTaskTempDTO.getComTaskId();
        String attendType = comTaskTempDTO.getAttendType();
        if (taskId == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID为空");
        }
        // 查找驻勤ID是否存在,如果存在则修改考勤类型
        ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
        // 实体为空则查询缓存
        if (comTask == null) {
            MidTask midTask = midTaskMapper.getByPrimaryKey(taskId);
            if (midTask == null) {
                throw new BusinessException(Result.ERROR, "未找到驻勤信息");
            }
            String shiftIds = "";
            if (attendType.equals(DictConst.ATTENDTYPE_PBZ)) {
                List<ComShiftDto> listShift = JSON.parseArray(comTaskTempDTO.getShiftIdJson(), ComShiftDto.class);
                // 查询出勤班次的时间安排
                if (listShift != null && listShift.size() > 0) {
                    for (ComShiftDto comShiftDto : listShift) {
                        shiftIds += comShiftDto.getShiftId() + ",";
                    }
                }
            } else {
                // 获取固定班制
                List<ComTaskFixedDTO> comTaskFixedDlist = JSON.parseArray(comTaskTempDTO.getComTaskFixeds(),
                        ComTaskFixedDTO.class);

                for (ComTaskFixedDTO comTaskFixedDto : comTaskFixedDlist) {
                    shiftIds += comTaskFixedDto.getShiftId() + ",";
                }
            }
            comTaskTempDTO.setShiftIds(shiftIds);
            String content = JSON.toJSON(comTaskTempDTO).toString();
            // 保存或新增暂存详细信息
            return this.saveMidTaskDetail(content, midTask, "2");

        } else {
            comTask.setAttendType(attendType);
            if (comTaskMapper.update(comTask) <= 0) {
                throw new BusinessException(Result.ERROR, "更新驻勤信息失败");
            }
            // 驻勤出勤地点列表以String格式传上来
            // 修改："comTaskAttendAdresses":{
            // "taskAttendAddressId":"397843933108895744",
            // "address":"软件园二期30号","addressLongitude":"110.3","addressLatitude":"133.4","addressRange":"1000"｝
            // 新增："comTaskAttendAdresses":{ "taskAttendAddressId":"",
            // "address":"软件园二期30号","addressLongitude":"110.3","addressLatitude":"133.4","addressRange":"1000"｝
            List<ComTaskAttendAddress> adresseslist = JSON.parseArray(comTaskTempDTO.getComTaskAttendAdresses(),
                    ComTaskAttendAddress.class);

            saveComTaskAttendAddress(adresseslist, comTaskTempDTO);

            if (attendType.equals(DictConst.ATTENDTYPE_PBZ)) {
                // 排班制,2
                return this.saveComTaskSchedulCycle(comTaskTempDTO);
            } else if (attendType.equals(DictConst.ATTENDTYPE_GDBZ)) {
                // 固定班制,1
                return this.saveComTaskFixed(comTaskTempDTO);
            } else {
                throw new BusinessException(Result.ERROR, "请上传正确的考勤类型");
            }
        }
    }

    /**
     * @param midTask,stage
     * @Author: zhongjianhui
     * @Description:驻勤中间详情表新增或修改
     * @Date: 2018/03/02 14:05
     */
    private Result saveMidTaskDetail(String content, MidTask midTask, String stage) throws BusinessException {

        List<MidTaskDetail> list = midTaskDetailMapper.getByMidTaskId(midTask.getMidTaskId(), stage);

        if (list.size() == 1) {
            for (MidTaskDetail midTaskDetail : list) {
                // 修改
                midTaskDetail = midTaskDetailMapper.getByPrimaryKey(midTaskDetail.getMidTaskDetailId());
                // 更新
                midTaskDetail.setContent(content);

                if (midTaskDetailMapper.update(midTaskDetail) <= 0) {
                    throw new BusinessException(Result.ERROR, "更新暂存驻勤详情失败");
                }
            }
        } else if (list.size() == 0) {
            // 新增
            MidTaskDetail midTaskDetail = new MidTaskDetail();
            midTaskDetail.setMidTaskDetailId(idWorker.nextId());
            ObjectUtils.copyProperties(midTaskDetail, midTask);
            midTaskDetail.setContent(content);
            midTaskDetail.setStage(Integer.valueOf(stage));
            midTaskDetailMapper.insert(midTaskDetail);

        } else {
            throw new BusinessException(Result.ERROR, "暂存详细有重复数据");
        }
        return Result.success("");
    }

    /**
     * @param comTaskTempDTO
     * @Author: zhongjianhui
     * @Description:驻勤固定班制新增或修改
     * @Date: 2018/03/02 14:05
     */
    private Result saveComTaskFixed(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
        // 驻勤ID
        Long taskId = comTaskTempDTO.getComTaskId();
        if (taskId == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID为空");
        }
        // 查找考勤组ID是否存在,如果存在则修改考勤类型
        ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
        if (comTask == null) {
            throw new BusinessException(Result.ERROR, "驻勤不存在");
        }
        // 固定排班制以String格式传上来
        // 修改："comTaskFixeds":{ "taskFixedId":"397846222926249984",
        // "weekDay":"1","shiftId":"1"｝,{ "taskFixedId":"397846222926249983",
        // "weekDay":"2","shiftId":"2"｝...
        // 新增："comTaskFixeds":{ "taskFixedId":"", "weekDay":"1","shiftId":"1"｝,{
        // "taskFixedId":"", "weekDay":"2","shiftId":"2"｝...
        List<ComTaskFixed> list = JSON.parseArray(comTaskTempDTO.getComTaskFixeds(), ComTaskFixed.class);

        List<ComTaskFixed> updateTaskFixedlist = new ArrayList<>();

        List<ComTaskFixed> insertTaskFixedlist = new ArrayList<>();

        // 如果size不是7就说明上传少（多）了几天
        if (list.size() == 7) {

            for (ComTaskFixed comTaskFixed : list) {
                // 设置工作id
                comTaskFixed.setComTaskId(taskId);
                // 工作日+shiftId+（shiftId不为空则isRect为0否则为1）
                comTaskFixed.setIsRest(comTaskFixed.getShiftId() == -1 ? DictConst.ISREST_TRUE
                        : (comTaskFixed.getShiftId() != null ? DictConst.ISREST_FALSE : DictConst.ISREST_TRUE));
                if (comTaskFixed.getTaskFixedId() != null) {
                    // 修改
                    comTaskFixed.setComId(comTaskTempDTO.getComId());
                    comTaskFixed.setUpdateBy(comTaskTempDTO.getUpdateBy());
                    comTaskFixed.setUpdateTime(comTaskTempDTO.getUpdateTime());
                    updateTaskFixedlist.add(comTaskFixed);
                } else {
                    comTaskFixed.setTaskFixedId(idWorker.nextId());
                    comTaskFixed.setComId(comTaskTempDTO.getComId());
                    comTaskFixed.setCreateTime(comTaskTempDTO.getCreateTime());
                    comTaskFixed.setCreateBy(comTaskTempDTO.getCreateBy());
                    comTaskFixed.setIsDelete(CommonConst.N);
                    insertTaskFixedlist.add(comTaskFixed);
                }
            }
            if (updateTaskFixedlist.size() > 0) {
                comTaskFixedMapper.batchUpdateComTaskFixed(updateTaskFixedlist);
            }
            if (insertTaskFixedlist.size() > 0) {
                comTaskFixedMapper.batchInsertComTaskFixed(insertTaskFixedlist);
            }
        }
        return Result.success("");
    }

    /**
     * @param adresseslist，taskId
     * @Author: zhongjianhui
     * @Description:保存驻勤地点
     * @Date: 2018/03/02 14:05
     */
    private Result saveComTaskAttendAddress(List<ComTaskAttendAddress> adresseslist, ComTaskTempDTO comTaskTempDTO)
            throws BusinessException {
        if (CollectionUtil.isEmpty(adresseslist)) {
            return Result.success("");
        }
        /* 删除之前的考勤地址 */
        comTaskAttendAddressMapper.deleteTaskAttendAddressById(comTaskTempDTO.getComTaskId());

		/* 插入新的考勤地址 */
        for (ComTaskAttendAddress comTaskAttendAddress : adresseslist) {
            // 设置驻勤id
            comTaskAttendAddress.setComTaskId(comTaskTempDTO.getComTaskId());
            comTaskAttendAddress.setComId(comTaskTempDTO.getComId());
            comTaskAttendAddress.setUpdateTime(new Date());
            comTaskAttendAddress.setTaskAttendAddressId(idWorker.nextId());
            comTaskAttendAddress.setCreateTime(new Date());
            comTaskAttendAddress.setIsDelete(DictConst.DATAAUTHFLAG_F);
            // 新增
            if (comTaskAttendAddressMapper.insert(comTaskAttendAddress) == 0) {
                throw new BusinessException(Result.ERROR, "新增出勤地点失败");
            }
        }
        return Result.success("");
    }

    /**
     * 驻勤-出勤设置-排班制-修改或新增（第二步）
     *
     * @param comTaskTempDTO
     * @return
     * @throws BusinessException
     * @author zhangjianhua
     * @date 2018/03/06
     */
    private Result saveComTaskSchedulCycle(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
        // 删除之前的默认班次信息
        comTaskShiftMapper.deleteByPrimaryKey(comTaskTempDTO.getComTaskId());
        // 添加默认班次信息
        this.addComTaskSchedul(comTaskTempDTO);
        // 新增或者修改周期排班制
        this.addTaskSchedulCycle(comTaskTempDTO);

        return Result.success("");

    }

    /**
     * 添加默认班次信息
     *
     * @param comTaskTempDTO
     * @throws BusinessException
     */
    private Result addComTaskSchedul(ComTaskTempDTO comTaskTempDTO) throws BusinessException {

        List<ComTaskShift> list = JSON.parseArray(comTaskTempDTO.getShiftIdJson(), ComTaskShift.class);
        if (CollectionUtil.isNotEmpty(list)) {
            for (ComTaskShift comTaskShift : list) {
                comTaskShift.setComTaskId(comTaskTempDTO.getComTaskId());
                comTaskShift.setComId(comTaskTempDTO.getComId());
                comTaskShift.setCreateTime(comTaskTempDTO.getCreateTime());
                comTaskShift.setCreateBy(comTaskTempDTO.getCreateBy());
                comTaskShift.getShiftId();
                if (comTaskShiftMapper.insert(comTaskShift) <= 0) {
                    throw new BusinessException(Result.ERROR, "添加班次失败");
                }
            }
        } else {
            throw new BusinessException(Result.ERROR, "请选择默认班次");
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 初始化驻勤打卡提醒
     *
     * @param comTask
     * @param shiftList
     */
    @Override
    public void initTaskRemind(Long comId, ComTask comTask, List<ComTaskShift> shiftList) {
        taskCardRemindMapper.deleteByTask(comTask.getComTaskId());
        List<ComShiftRule> shiftRuleList = comShiftRuleMapper.getShiftRuleByShiftIdList(shiftList);
        List<TaskCardRemind> remindList = Lists.newArrayList();
        for (ComShiftRule rule : shiftRuleList) {
            TaskCardRemind remind = new TaskCardRemind();
            remind.setTaskCardRemindId(idWorker.nextId());
            remind.setComId(comId);
            remind.setAttendTime(rule.getStartWorkTime());
            remind.setRemindTime(DateUtil.offsetMinute(rule.getStartWorkTime(), -5));
            remind.setStartDate(comTask.getStartDate());
            remind.setEndDate(comTask.getEndDate());
            remind.setComTaskId(comTask.getComTaskId());
            remind.setShiftRuleId(rule.getShiftRuleId());
            remindList.add(remind);
        }
        taskCardRemindMapper.batchInsert(remindList);
    }

    /**
     * 周期排班设置
     *
     * @param comTaskTempDTO
     * @throws BusinessException
     */
    private void addTaskSchedulCycle(ComTaskTempDTO comTaskTempDTO) throws BusinessException {
        if (StringUtils.isNotEmpty(comTaskTempDTO.getComTaskSchedulCycleJson())) {
            // "comTaskSchedulCycleJson":[{"taskSchedulCycleId":"397847079348600832","cycleName":"周期名称AAA","cycleDays":"4","shiftIdArrayUse":[1,2,3,-1]},{"cycleName":"周期名称BBB","cycleDays":"4","shiftIdArrayUse":[1,2,3,-1]}]
            List<ComTaskSchedulCycleDTO> list = JSON.parseArray(comTaskTempDTO.getComTaskSchedulCycleJson(),
                    ComTaskSchedulCycleDTO.class);

            if (list != null && list.size() > 0) {
                for (ComTaskSchedulCycleDTO comTaskSchedulCycleDTO : list) {

                    if (comTaskSchedulCycleDTO.getTaskSchedulCycleId() != null) {
                        // 删除周期班次关联表数据
                        comTaskCycleShiftMapper.deleteByPrimaryKey(comTaskSchedulCycleDTO.getTaskSchedulCycleId());
                        comTaskSchedulCycleDTO.setUpdateBy(comTaskTempDTO.getUpdateBy());
                        comTaskSchedulCycleDTO.setUpdateTime(comTaskTempDTO.getUpdateTime());
                        comTaskSchedulCycleDTO.setComId(comTaskTempDTO.getComId());
                        comTaskSchedulCycleDTO.setComTaskId(comTaskTempDTO.getComTaskId());
                        if (comTaskSchedulCycleMapper.update(comTaskSchedulCycleDTO) <= 0) {
                            throw new BusinessException(Result.ERROR, "更新周期失败");
                        }
                    } else {
                        comTaskSchedulCycleDTO.setTaskSchedulCycleId(idWorker.nextId());
                        comTaskSchedulCycleDTO.setComTaskId(comTaskTempDTO.getComTaskId());
                        comTaskSchedulCycleDTO.setComId(comTaskTempDTO.getComId());
                        comTaskSchedulCycleDTO.setCreateTime(comTaskTempDTO.getCreateTime());
                        comTaskSchedulCycleDTO.setCreateBy(comTaskTempDTO.getCreateBy());
                        // 添加周期基础信息
                        if (comTaskSchedulCycleMapper.insert(comTaskSchedulCycleDTO) <= 0) {
                            throw new BusinessException(Result.ERROR, "新增周期失败");
                        }
                    }
                    // 添加驻勤排班周期所选班次
                    if (comTaskSchedulCycleDTO.getShiftIdArrayUse() != null
                            && comTaskSchedulCycleDTO.getShiftIdArrayUse().length > 0) {

                        for (int i = 0; i < comTaskSchedulCycleDTO.getShiftIdArrayUse().length; i++) {

                            ComTaskCycleShift comTaskCycleShift = new ComTaskCycleShift();
                            comTaskCycleShift.setCreateBy(comTaskTempDTO.getCreateBy());
                            ObjectUtils.copyProperties(comTaskCycleShift, comTaskTempDTO);
                            comTaskCycleShift.setTaskSchedulCycleId(comTaskSchedulCycleDTO.getTaskSchedulCycleId());
                            // 前端如果是休息则传-1
                            if ("-1".equals(comTaskSchedulCycleDTO.getShiftIdArrayUse()[i])) {
                                comTaskCycleShift.setIsRest(ComTaskTempDTO.ISREST);
                            } else {
                                comTaskCycleShift.setShiftId(Long.parseLong(comTaskSchedulCycleDTO.getShiftIdArrayUse()[i]));
                            }
                            comTaskCycleShift.setWhatDay(i + 1);
                            if (comTaskCycleShiftMapper.insert(comTaskCycleShift) <= 0) {
                                throw new BusinessException(Result.ERROR, "添加驻勤排班周期所选班次失败");
                            }
                        }

                    } else {
                        throw new BusinessException(Result.ERROR, "添加周期失败");
                    }
                }
            }
        }
    }

    /**
     * ---------------------------整合驻勤接口-第三步----------------------------------------------------------------
     **/
    @Override
    public Result getStepThreeDetail(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
        // 驻勤ID
        Long taskId = comTaskThreeDTO.getComTaskId();

        if (taskId == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID为空");
        }
        ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
        /* 如果正式驻勤不存在则查询暂存表 ***/
        if (comTask == null) {
            MidTask midTask = midTaskMapper.getByPrimaryKey(taskId);
            if (midTask == null) {
                throw new BusinessException(Result.ERROR, "未找到驻勤信息");
            }
            List<MidTaskDetail> midTaskDetails = midTaskDetailMapper.getByMidTaskId(midTask.getMidTaskId(), "3");
            if (midTaskDetails.size() == 1) {
                comTaskThreeDTO = JSON.parseObject(midTaskDetails.get(0).getContent(), ComTaskThreeDTO.class);
                comTaskThreeDTO.setCanZC(true);
                return Result.success("", comTaskThreeDTO);
            } else {
                return Result.success("");
            }

        } else {
            /* 正式驻勤 ***/
            String getTaskPerInsMode = "";

            List<ComTaskInsidePushDTO> departAndPerList = comTaskInsidePushMapper.listTaskInsidePush1(taskId,
                    comTaskThreeDTO.getComId());
            String[] array = new String[departAndPerList.size()];
            int i = 0;
            List<ComTaskDepartAndPerDTO> departList = new ArrayList<>();
            for (ComTaskInsidePushDTO comTaskInsidePush : departAndPerList) {

                Long departId = comTaskInsidePush.getDepartId();
                array[i] = comTaskInsidePush.getPerId().toString();
                int departListSize = 0;
                String title = comTaskInsidePush.getDepartName();
                if (departId == null) {
                    departId = comTaskThreeDTO.getComId();
                    title = comTaskInsidePush.getComName();
                }
                for (ComTaskDepartAndPerDTO comTaskDepartAndPerDTO : departList) {
                    if (!departId.equals(comTaskDepartAndPerDTO.getKey())) {
                        departListSize++;
                    }
                }
                if (departListSize == departList.size()) {
                    ComTaskDepartAndPerDTO comTaskDepartAndPerDTO = new ComTaskDepartAndPerDTO();
                    comTaskDepartAndPerDTO.setKey(departId);
                    comTaskDepartAndPerDTO.setTitle(title);
                    comTaskDepartAndPerDTO
                            .setPerList(comTaskInsidePushMapper.listTaskInsidePushAndDepartID(taskId, departId, comTaskThreeDTO.getComId()));
                    departList.add(comTaskDepartAndPerDTO);
                }
                i++;
            }
            //if (departAndPerList.size() > 0) {
            //	getTaskPerInsMode = departAndPerList.get(0).getTaskPerInsMode();
            //}
            comTaskThreeDTO.setCanZC(false);
            comTaskThreeDTO.setChargePerName(comTaskMapper.getChargePerName(comTask.getComTaskId()));
            comTaskThreeDTO.setTaskPerInsMode(getTaskPerInsMode);
            comTaskThreeDTO.setTaskPerArray(array);
            comTaskThreeDTO.setChargePerId(comTask.getChargePerId());
            comTaskThreeDTO.setDepartList(departList);
            comTaskThreeDTO.setTaskStatus(comTask.getTaskStatus());
            return Result.success("", comTaskThreeDTO);

        }
    }

    /**
     * 根据id获取驻勤
     *
     * @param comTaskId
     * @return ComTaskDto
     */
    @Override
    public Result getTaskById(Long comTaskId) {
        ComTask comTask = comTaskMapper.getByPrimaryKey(comTaskId);
        return Result.success("", this.codeAddressChangeToArray(comTask));
    }

    /**
     * <b> 根据驻勤id和企业id查询未投保人员名称列 </b>
     *
     * @author ZXF
     * @create 2018/11/09 0009 14:27
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getTaskUnInsPerInfoList(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
        List<String> listName = comTaskMapper.getTaskUnInsPerInfoList(comTaskThreeDTO.getComTaskId(),
                comTaskThreeDTO.getComId());
        return Result.success("", listName);
    }

    /**
     * <b> 根据驻勤id获取驻勤冲突投保人员列 </b>
     *
     * @author ZXF
     * @create 2018/11/09 0009 14:27
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getTaskConflictPerInfoList(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
        ComTask comTask = comTaskMapper.getByPrimaryKey(comTaskThreeDTO.getComTaskId());
        List<String> listName = Lists.newArrayList();
        if (comTask != null) {
            // 校验人员固定排班是否冲突,返回冲突的排班信息
            List<Map> mapList = validateTaskFixedMapper.checkImplement(DateUtils.formatDate(comTask.getStartDate()),
                    DateUtils.formatDate(comTask.getEndDate()), comTaskThreeDTO.getComTaskId());

            // 获取人员列表
            List<Long> listPerId = new ArrayList<>();
            if (mapList != null && mapList.size() > 0) {
                for (Map map1 : mapList) {
                    listPerId.add((Long) map1.get("perId"));
                }
            }
            // 存在排班重复的人员去重
            HashSet hashSet = new HashSet(listPerId);
            listPerId.clear();
            listPerId.addAll(hashSet);
            if (listPerId != null && listPerId.size() > 0) {
                // 固定排班重复人员名称
                listName = validateTaskFixedMapper.listName(listPerId);
            }
        }
        return Result.success("", listName);
    }

    /***
     * 获取驻勤成员名单 (驻勤详情的第3个tab)
     *
     * @param dto
     * @return
     * @throws BusinessException
     *  by llc 2018-09-20
     */
    @Override
    public Result getTaskPer(ComTaskThreeDTO dto) throws BusinessException {

        if (dto.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
        }
        if (dto.getPageNumber() == null) {
            throw new BusinessException(Result.ERROR, "第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            throw new BusinessException(Result.ERROR, "每页多少行不能为空");
        }
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        /*** 查询出驻勤人员名单 ***/
        List<Map<String, String>> taskPerList = comTaskInsidePushMapper.getTaskPer(dto);
        PageInfoUtils pageInfo = new PageInfoUtils(taskPerList);
        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }

    /**
     * 导出驻勤人员
     *
     * @param dto
     * @return
     * @throws BusinessException
     * @author llc
     * @date 2019-11-29
     */
    @Override
    public Result exportTaskPer(ComTaskThreeDTO dto, HttpServletResponse response) throws BusinessException {
        if (dto.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            String fileName = "_" + "驻勤人员" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("驻勤人员");

            List<Map<String, String>> taskPerList = comTaskInsidePushMapper.getTaskPer(dto);

            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            /**** 生成sheet1的内容 ***/
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 11);
            titleFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            titleFont.setFontName("黑体");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);// 水平居中
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));

            /*** 填充第一行数据 ***/
            HSSFRow rowFirst = sheet1.createRow(0);
            String[] firstArr = {"序号", "姓名", "所属部门", "身份证号", "手机号码", "保安员资格证", "投保状态"};
            int column;
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第二行的每个单元格
                if (i == 0) {
                    column = 1500;
                } else if (i == 2 || i == 3) {
                    column = 5000;
                } else {
                    column = 4000;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                cell.setCellStyle(titleStyle); // 文本格式
            }

            /*** 填充第一行数据 ***/
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第一行的每个单元格
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(titleStyle);
            }

            /*** 字体颜色样式 ***/
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);// 青绿色样式
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index); // 红色样式
            HSSFRow row = null;
            int rowIndex = 1;
            for (Map<String, String> result : taskPerList) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(rowIndex);
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("perName") != null ? result.get("perName") : null); // 姓名
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("orgName") != null ? result.get("orgName") : null); // 所属部门
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("idCardNo") != null ? result.get("idCardNo") : null); // 身份证号
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("mobilePhone") != null ? result.get("mobilePhone") : null); // 手机号
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("bayzgzh") != null ? result.get("bayzgzh") : null); // 保安员资格证
                cell5.setCellStyle(redStyle);
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("tbzt") != null ? result.get("tbzt") : null);// 投保状态
                if (result.get("tbzt").equalsIgnoreCase("已投保")) {
                    cell6.setCellStyle(greenStyle);
                } else {
                    cell6.setCellStyle(redStyle);
                }
                rowIndex++;
            }
            wb.write(os);
            os.close();
        } catch (Exception e) {
            throw new BusinessException(Result.ERROR, e.getMessage());
        } finally {
            try {
                os.close();
            } catch (IOException e1) {
            }
        }
        return Result.success("导出驻勤人员数据文件失败");
    }

    /***
     * 获取驻勤负责人
     * @param comTask
     * @return
     * @throws BusinessException
     * by llc 2019-11-25
     */
    @Override
    public Result getTaskChargePer(ComTask comTask) throws BusinessException {
        if (comTask.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
        }
        Map<String, String> map = comTaskMapper.getChargePerInfo(comTask.getComTaskId());
        return Result.success(Result.SUCCESS_QUERY_MSG, map);
    }

    /***
     * 修改驻勤负责人
     * @param comTask
     * @return
     * @throws BusinessException
     * by llc 2019-11-25
     */
    @Override
    public Result updateTaskChargePer(ComTask comTask) throws BusinessException {
        if (comTask.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
        }
        if (comTask.getChargePerId() == null) {
            throw new BusinessException(Result.ERROR, "人员ID不能为空");
        }

        ComTask oldComTask = comTaskMapper.getByPrimaryKey(comTask.getComTaskId());

        /*** 更新旧的驻勤负责人记录终止时间 ***/

        if(oldComTask != null && oldComTask.getChargePerId() != null) {
            ComTaskChargeRecord oldComTaskChargeRecord = new ComTaskChargeRecord();
            oldComTaskChargeRecord.setComTaskId(comTask.getComTaskId());
            oldComTaskChargeRecord.setUpdateTime(comTask.getCreateTime());
            oldComTaskChargeRecord.setUpdateBy(comTask.getCreateBy());
            oldComTaskChargeRecord.setEndTime(comTask.getCreateTime());
            oldComTaskChargeRecord.setChargePerId(oldComTask.getChargePerId());
            oldComTaskChargeRecord.setComId(comTask.getComId());
            comTaskMapper.updateRecord(oldComTaskChargeRecord);
        }
        /*** 插入新的驻勤负责人记录 ***/
        ComTaskChargeRecord newComTaskChargeRecord = new ComTaskChargeRecord();
        newComTaskChargeRecord.setComTaskChargeRecordId(idWorker.nextId());
        newComTaskChargeRecord.setComTaskId(comTask.getComTaskId());
        newComTaskChargeRecord.setCreateTime(comTask.getCreateTime());
        newComTaskChargeRecord.setCreateBy(comTask.getCreateBy());
        newComTaskChargeRecord.setStartTime(comTask.getCreateTime());
        newComTaskChargeRecord.setChargePerId(comTask.getChargePerId());
        newComTaskChargeRecord.setComId(comTask.getComId());
        comTaskMapper.addRecord(newComTaskChargeRecord);

        /*** 更新驻勤负责人 ***/
        comTaskMapper.updateTaskChargePer(comTask);

        /*** 驻勤负责人通知  ***/
        String createrName = perBaseInfoMapper.getNameById(comTask.getCreateBy());
        String tilte = MsgConst.TYPE_0201011_TASK_NEW_TITLE;// 标题
        String content = MsgConst.TYPE_0201011_TASK_NEW_CONTENT; // 通知内容
        content = content.replace("{operate}", createrName)
                .replace("{taskName}", oldComTask.getTaskName());
        commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020101, comTask.getChargePerId().toString(), comTask.getComId(), comTask.getComTaskId());

        return Result.success("修改成功");
    }


    /***
     * 移除驻勤人员
     * @param dto
     * @return
     * @throws BusinessException
     * by llc 2019-11-29
     */
    @Override
    public Result removeTaskPer(ComTaskPerDTO dto) throws BusinessException {
        if (dto.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
        }
        if (StringUtil.isEmpty(dto.getPetIds())) {
            throw new BusinessException(Result.ERROR, "请选择人员");
        }
        /*** 人员ID列表 ***/
        List<String> perIdList = StrSplitter.split(dto.getPetIds(), CommonConst.COMMA, true, true);

        String today = DateUtils.getDate();
        /*** 删除驻勤执行情况 ***/

        List<String> existsPerIdList = comTaskInsidePushMapper.listPerIdWithType1(dto.getComTaskId());

        if (perIdList.size() == existsPerIdList.size()) {
            throw new BusinessException(Result.ERROR, "驻勤人员必须保留一个");
        }

        comTaskImplementMapper.deleteImplementByPerIdList(perIdList, dto.getComId(), dto.getComTaskId(), today);

        /*** 删除驻勤排班记录 ***/

        comTaskSchedulMapper.deleteByPerListTaskAndFromDate(today, perIdList, dto.getComTaskId());

        /*** 删除今天之后的驻勤打卡记录 ***/

        perTaskCardRecordMapper.deletePerTaskCardRecordByDateAndPerIdList(dto.getComTaskId(), today, perIdList);

        /*** 移除驻勤人员 ***/

        String yesterday = DateUtils.formatDate(DateUtil.yesterday());

        comTaskInsidePushMapper.deleteByTaskIdAndPerIdList(perIdList, dto.getUpdateBy(), dto.getComTaskId(), yesterday);

        /*** 同步百保盾 ***/
        ComTask comTask = comTaskMapper.getByPrimaryKey(dto.getComTaskId());
        ComTaskDto comTaskDto = new ComTaskDto();
        BeanUtil.copyProperties(comTask, comTaskDto);
        comTaskDto.setCreateBy(dto.getCreateBy());
        comTaskDto.setSessionId(dto.getSessionId());

        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(dto.getComId());
        String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
        /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
        if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//            bdpSyncService.removeTaskPer(comTaskDto,perIdList);
        }else{
            bbdTestService.bbdRemoveTaskPer(comTaskDto, perIdList);
        }

        /*** 发送通知 ***/
        /*** 通知驻勤成员 ***/
        String tilte = MsgConst.TYPE_020114_TASK_REMOVE_PER_MANAGE_TITLE;// 标题
        String content = MsgConst.TYPE_020114_TASK_REMOVE_PER_MANAGE_CONTENT; // 通知内容
        content = content.replace("{taskName}", comTask.getTaskName());
        commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020114, dto.getPetIds(), dto.getComId(), comTask.getComTaskId());

        /*** 通知负责人 ***/
        tilte = MsgConst.TYPE_0201141_TASK_REMOVE_PER_MANAGE_TITLE;
        content = MsgConst.TYPE_0201141_TASK_REMOVE_PER_MANAGE_CONTENT;
        String createrName = perBaseInfoMapper.getNameById(dto.getUpdateBy());
        content = content.replace("{taskName}", comTask.getTaskName())
                .replace("{operate}", createrName);
        commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020114, comTask.getChargePerId().toString(),
                comTask.getComId(), comTask.getComTaskId());

        return Result.success("删除成功");
    }


    /***
     * 驻勤人员
     * @param dto
     * @return
     * @throws BusinessException
     * by llc 2019-12-02
     */
    @Override
    public Result addTaskPer(ComTaskPerDTO dto) throws BusinessException {
        if (dto.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
        }
        if (StringUtil.isEmpty(dto.getPetIds())) {
            throw new BusinessException(Result.ERROR, "请选择人员");
        }
        /*** 人员ID列表 ***/
        List<String> perIdStrList = StrSplitter.split(dto.getPetIds(), CommonConst.COMMA, true, true);

        List<Long> perIdList = new ArrayList<>();
        for (String perId : perIdStrList) {
            perIdList.add(Long.parseLong(perId));
        }
        /*** 驻勤安排冲突人员列表 by llc 2020-02-27 ***/
        List<Map<String, String>> conflictPerList = comTaskInsidePushMapper.getConflictPerList(dto.getComTaskId(), dto.getComId(), perIdList);
        List<String> successPerIdStrList = new ArrayList<>();
        for (String perId : perIdStrList) {
            Boolean checkPassFlag = true;
            /*** 排除本次校验失败的人员 ***/
            for (Map<String, String> map : conflictPerList) {
                if (map.get("perId").equals(perId)) {
                    checkPassFlag = false;
                    break;
                }
            }
            if (checkPassFlag) {
                successPerIdStrList.add(perId);
            }
        }


        /*** 如果本次新增的人员存在校验通过才需删除驻勤执行情况 by llc 2020-02-27 ***/

        if (successPerIdStrList.size() > 0) {
            List<String> taskPerIdList = comTaskInsidePushMapper.getTaskPerIdList(dto.getComTaskId(), successPerIdStrList);

            List<ComTaskInsidePush> comTaskInsidePushList = new ArrayList<>();

            ComTask comTask = comTaskMapper.getByPrimaryKey(dto.getComTaskId());
            /*** 如果本次添加的人员都未安排 ***/
            if (taskPerIdList != null && taskPerIdList.size() == 0) {
                for (String perId : successPerIdStrList) {
                    ComTaskInsidePush comTaskInsidePush = new ComTaskInsidePush();
                    comTaskInsidePush.setInsidePushId(idWorker.nextId());
                    comTaskInsidePush.setCreateTime(dto.getCreateTime());
                    comTaskInsidePush.setCreateBy(dto.getCreateBy());
                    comTaskInsidePush.setPerId(Long.parseLong(perId));
                    comTaskInsidePush.setComTaskId(dto.getComTaskId());
                    comTaskInsidePush.setStartDate(new Date());
                    comTaskInsidePush.setEndDate(comTask.getEndDate());
                    comTaskInsidePush.setPushPerType(DictConst.PUSHPERTYPE_CYRY);
                    comTaskInsidePush.setComId(dto.getComId());
                    comTaskInsidePushList.add(comTaskInsidePush);
                }
            }

            /*** 如果本次添加的人员有部分已安排 ***/
            if (taskPerIdList != null && taskPerIdList.size() != 0) {
                for (String perId : successPerIdStrList) {
                    Boolean matchFlag = false;
                    for (String taskPerId : taskPerIdList) {
                        if (taskPerId.equals(perId)) {
                            matchFlag = true;
                            break;
                        }
                    }
                    /*** 如果未匹配到 则新增***/
                    if (!matchFlag) {
                        ComTaskInsidePush comTaskInsidePush = new ComTaskInsidePush();
                        comTaskInsidePush.setInsidePushId(idWorker.nextId());
                        comTaskInsidePush.setCreateTime(dto.getCreateTime());
                        comTaskInsidePush.setCreateBy(dto.getCreateBy());
                        comTaskInsidePush.setPerId(Long.parseLong(perId));
                        comTaskInsidePush.setComTaskId(dto.getComTaskId());
                        comTaskInsidePush.setStartDate(new Date());
                        comTaskInsidePush.setEndDate(comTask.getEndDate());
                        comTaskInsidePush.setPushPerType(DictConst.PUSHPERTYPE_CYRY);
                        comTaskInsidePush.setComId(dto.getComId());
                        comTaskInsidePushList.add(comTaskInsidePush);
                    }
                }
            }

            /*** 插入驻勤参与人员表 ***/
            if (comTaskInsidePushList.size() > 0) {
                comTaskInsidePushMapper.insertComTaskInsidePushList(comTaskInsidePushList);

                List<String> taskAddPerIdList = new ArrayList<>();
                for (ComTaskInsidePush comTaskInsidePush : comTaskInsidePushList) {
                    taskAddPerIdList.add(comTaskInsidePush.getPerId().toString());
                }

                /*** 只有本次新增的数据有效才同步百保盾 ***/
                ComTaskDto comTaskDto = new ComTaskDto();
                BeanUtil.copyProperties(comTask, comTaskDto);
                comTaskDto.setCreateBy(dto.getCreateBy());
                comTaskDto.setSessionId(dto.getSessionId());

                ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(dto.getComId());
                String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
                /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
                if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//                    bdpSyncService.saveTaskPer(comTaskDto,taskAddPerIdList);
                }else{
                    bbdTestService.bbdAddTaskPer(comTaskDto, taskAddPerIdList);
                }

                /*** 发送通知 ***/
                /*** 通知驻勤成员 ***/
                String tilte = MsgConst.TYPE_020101_TASK_NEW_TITLE;// 标题
                String content = MsgConst.TYPE_020101_TASK_NEW_CONTENT; // 通知内容
                content = content.replace("{taskName}", comTask.getTaskName())
                        .replace("{taskStart}",
                                comTask.getStartDate() == null ? ""
                                        : DateUtils.formatDate(comTask.getStartDate(), "yyyy-MM-dd"))
                        .replace("{taskEnd}", comTask.getEndDate() == null ? ""
                                : DateUtils.formatDate(comTask.getEndDate(), "yyyy-MM-dd"))
                        .replace("{taskAddress}", comTask.getTaskAddress())
                        .replace("{taskContent}", comTask.getTaskContent());
                String taskPers = StringUtils.join(taskAddPerIdList, ",");
                commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020101, taskPers, dto.getComId(), comTask.getComTaskId());

                /*** 通知负责人 ***/
                tilte = MsgConst.TYPE_020110_TASK_ADD_PER_MANAGE_TITLE;
                content = MsgConst.TYPE_020110_TASK_ADD_PER_MANAGE_CONTENT;
                String createrName = perBaseInfoMapper.getNameById(dto.getUpdateBy());
                content = content.replace("{taskName}", comTask.getTaskName())
                        .replace("{operate}", createrName);
                commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020110, comTask.getChargePerId().toString(),
                        comTask.getComId(), comTask.getComTaskId());
            }
        }

        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("conflictPerList", conflictPerList);
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /***
     * 驻勤发布第三步
     *
     * @param comTaskThreeDTO
     * @return
     * @throws BusinessException
     */
    @Override
    public Result saveStepThreeDetail(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
        // 驻勤ID
        Long taskId = comTaskThreeDTO.getComTaskId();
        // 推送范围
        // String pushRange = comTaskThreeDTO.getPushRange();
        if (taskId == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID为空");
        }

        ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
        Map<String, String> insDetailMap = Maps.newHashMap();
        insDetailMap.put("comTaskId", String.valueOf(taskId));

		/* 如果不是正式驻勤则查暂存表 ***/
        if (comTask == null) {
            MidTask midTask = midTaskMapper.getByPrimaryKey(taskId);
            if (midTask == null) {
                throw new BusinessException(Result.ERROR, "未找到驻勤信息");
            }
            if (ComTaskThreeDTO.TURE.equals(comTaskThreeDTO.getIsFB())) {
                // 2.新增taskId，新增驻勤表
                ComTask comTask1 = new ComTask();
                Long taskNewId = idWorker.nextId();
                comTask1.setComTaskId(taskNewId);
                comTask1.setIsDelete(CommonConst.N);
                comTask1.setComId(comTaskThreeDTO.getComId());
                comTask1.setTaskStatus(DictConst.TASKSTATUS_WKS);
                comTask1.setCreateBy(comTaskThreeDTO.getCreateBy());
                comTask1.setTaskAssign(DictConst.TASKASSIGN_WQ);
                comTask1.setAttendSubType(DictConst.ATTENDSUBTYPE_SD);

                if (comTaskMapper.insert(comTask1) <= 0) {
                    throw new BusinessException(Result.ERROR, "新建驻勤失败");
                }
                Long comId = comTaskThreeDTO.getComId();
                // 1.先取出所有暂存数据（1，2步的），判断出勤类型，排班表（固定班制），考勤地点表，新增推送人员表，进行排班
                List<MidTaskDetail> midTaskDetailList = midTaskDetailMapper.getByMidTaskId(taskId, null);

                if (midTaskDetailList.size() >= 2) {
                    for (MidTaskDetail midTaskDetail : midTaskDetailList) {
                        // 第一步
                        switch (midTaskDetail.getStage()) {

                            // 驻勤第一步的，取出，然后更新驻勤
                            case 1:
                                ComTask comTaskDto = JSON.parseObject(midTaskDetail.getContent(), ComTask.class);
                                comTaskDto.setIsDelete("0");
                                comTaskDto.setComId(comId);
                                comTaskThreeDTO.setTaskName(comTaskDto.getTaskName());

                                /*** 校验驻勤点名称的唯一性 ***/

                                if (comTaskMapper.checkTaskNameUnique(comTaskDto.getComId(), null, comTaskDto.getTaskName()) > 0) {
                                    throw new BusinessException(Result.BUSINESS_ERROR, "驻勤点名称已经存在，请修改驻勤点名称");
                                }

                                /*** 校验当前日期是否晚于驻勤开始日期 驻勤开始日期早于（包含等于）当前日期，驻勤状态为进行中
                                 驻勤开始日期晚于当前日期，驻勤状态为未开始 by llc 2018-09-25
                                 ***/
                                if (DateUtils.dateCompare(DateUtils.formatDate(comTaskDto.getStartDate()), DateUtils.getDate())) {
                                    /*** 由于放开限制可以录入已结束的驻勤，所以校验当前日期早于（包含等于）驻勤结束日期驻勤状态为进行中 ***/
                                    if (DateUtils.dateCompare(DateUtils.getDate(), DateUtils.formatDate(comTaskDto.getEndDate()))) {
                                        comTaskDto.setTaskStatus(DictConst.TASKSTATUS_JXZ);
                                    } else {
                                        comTaskDto.setTaskStatus(DictConst.TASKSTATUS_YJS);
                                    }
                                } else {
                                    comTaskDto.setTaskStatus(DictConst.TASKSTATUS_WKS);
                                }

                                /*** 获取所选公安机构对应的百保盾ID ***/
                                Long policeId = comTaskDto.getPoliceStationId() == null ? (comTaskDto.getDistrictOrgId() == null ? comTaskDto.getCityOrgId() : comTaskDto.getDistrictOrgId()) : comTaskDto.getPoliceStationId();

                                Long bbdId = sysPoliceMapper.getBbdIdByPoliceId(policeId);
                                comTaskDto.setBbdId(bbdId);

                                comTaskDto.setComTaskId(taskNewId);
                                insDetailMap.put("comTaskId", String.valueOf(taskNewId));
                                if (comTaskMapper.update(comTaskDto) <= 0) {
                                    throw new BusinessException(Result.ERROR, "修改驻勤失败");
                                }
                                // 先校验参与人员是否已经购买保险
                                validatePerIns(comTaskThreeDTO, comTaskDto, insDetailMap);
                                break;
                            // 驻勤第二步的，取出，然后新增考勤
                            case 2:
                                ComTaskTempDTO comTaskTempDTO = JSON.parseObject(midTaskDetail.getContent(),
                                        ComTaskTempDTO.class);
                                comTaskTempDTO.setComTaskId(taskNewId);
                                comTaskTempDTO.setComId(comId);
                                comTaskTempDTO.setCreateTime(comTaskThreeDTO.getCreateTime());
                                comTaskTempDTO.setCreateBy(comTaskThreeDTO.getCreateBy());
                                this.saveStepTwoDetail(comTaskTempDTO);
                                break;
                            // 驻勤第三步的，不需取出，然后人员排班
                            case 3:
                                break;
                            default:
                                throw new BusinessException(Result.ERROR, "未找到相应的步骤");

                        }
                    }
                } else {
                    throw new BusinessException(Result.ERROR, "驻勤详细信息不完整");
                }
                // 校验人员是否有排班冲突
//                insDetailMap.putAll(this.checkPerImplement(comTaskThreeDTO));
                // 保存第三步内容
                comTaskThreeDTO.setComTaskId(taskNewId);
                Map resultMap = this.saveOrUpdateTaskThird(comTaskThreeDTO);
                insDetailMap.put("conflictPerList", JSON.toJSONString(resultMap.get("conflictPerList")));

                // 3.删除所有缓存数据
                if (midTaskDetailMapper.deleteByPrimaryKey(taskId) <= 0) {
                    throw new BusinessException(Result.ERROR, "删除暂存驻勤详情失败");
                }
                if (midTaskMapper.deleteByPrimaryKey(taskId) <= 0) {
                    throw new BusinessException(Result.ERROR, "删除暂存驻勤失败");
                }

                List<String> checkPassPerIdList = JSON.parseArray(JSON.toJSONString(resultMap.get("checkPassPerIdList")), String.class);

                // TODO 百保盾驻勤点同步保存
                ComTask comTaskNew = comTaskMapper.getByPrimaryKey(taskNewId);
                ComTaskDto comTaskDto = new ComTaskDto();
                BeanUtil.copyProperties(comTaskNew, comTaskDto);
                comTaskDto.setSessionId(comTaskThreeDTO.getSessionId());

                ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(comTaskThreeDTO.getComId());
                String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
                /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
                if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//                    throw new BusinessException(Result.ERROR, "测试失败");
//                    bdpSyncService.addTask(comTaskDto);
                    /*** 如果本次安排人员不为空 ***/
                    if (checkPassPerIdList != null && checkPassPerIdList.size() > 0) {
//                        bdpSyncService.saveTaskPer(comTaskDto, checkPassPerIdList);
                    }
                }else{
                    bbdTestService.bbdSaveOrUpdateTask(comTaskDto);
                }

                /*** 发送通知 ***/


                ComTask comTaskDB = comTaskMapper.getByPrimaryKey(taskNewId);
                /*** 排除本次创建校验不通过的人员 ***/
                if (checkPassPerIdList != null && checkPassPerIdList.size() > 0) {
                    String tilte = MsgConst.TYPE_020101_TASK_NEW_TITLE;// 标题
                    String content = MsgConst.TYPE_020101_TASK_NEW_CONTENT; // 通知内容
                    content = content.replace("{taskName}", comTaskDB.getTaskName())
                            .replace("{taskStart}",
                                    comTaskDB.getStartDate() == null ? ""
                                            : DateUtils.formatDate(comTaskDB.getStartDate(), "yyyy-MM-dd"))
                            .replace("{taskEnd}", comTaskDB.getEndDate() == null ? ""
                                    : DateUtils.formatDate(comTaskDB.getEndDate(), "yyyy-MM-dd"))
                            .replace("{taskAddress}", comTaskDB.getTaskAddress())
                            .replace("{taskContent}", comTaskDB.getTaskContent());
                    String checkPassPers = StringUtils.join(checkPassPerIdList, ",");
                    commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020101, checkPassPers, comId, taskNewId);
                }

                /*** 驻勤负责人通知  ***/
                String createrName = perBaseInfoMapper.getNameById(comTaskDB.getCreateBy());
                String tilte2 = MsgConst.TYPE_0201011_TASK_NEW_TITLE;// 标题
                String content2 = MsgConst.TYPE_0201011_TASK_NEW_CONTENT; // 通知内容
                content2 = content2.replace("{operate}", createrName).replace("{taskName}", comTaskDB.getTaskName());
                commonService.sendMessageToApp(tilte2, content2, DictMessageTypeConst.MESSAGETYPE_020101, comTaskDB.getChargePerId().toString(), comId, taskNewId);
                return Result.success("", insDetailMap);
            } else {

                String content = JSON.toJSON(comTaskThreeDTO).toString();
                // 保存或新增暂存详细信息
                Result result = this.saveMidTaskDetail(content, midTask, "3");

                result.setData(insDetailMap);

                return result;
            }

        } else {

            /*** 由于业务场景关系，目前程序不会进入这段逻辑了 ***/

			/* 校验人员是否有排班冲突 ***/
//            insDetailMap.putAll(this.checkPerImplement(comTaskThreeDTO));

			/* 校验参与人员是否已经购买保险 ***/
            validatePerIns(comTaskThreeDTO, comTask, insDetailMap);
            // 修改驻勤信息
            Map resultMap = this.saveOrUpdateTaskThird(comTaskThreeDTO);
            insDetailMap.put("conflictPerList", JSON.toJSONString(resultMap.get("conflictPerList")));
            insDetailMap.put("comTaskId", String.valueOf(taskId));
            /*** 同步百保盾 ***/
            ComTaskDto comTaskDto = new ComTaskDto();
            BeanUtil.copyProperties(comTask, comTaskDto);
            ;
            comTaskDto.setSessionId(comTaskThreeDTO.getSessionId());

            ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(comTaskThreeDTO.getComId());
            String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
            /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
            if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//                bdpSyncService.updateTask(comTaskDto);
            }else{
                bbdTestService.bbdSaveOrUpdateTask(comTaskDto);
            }

            return Result.success("", insDetailMap);
        }
    }

    /**
     * 驻勤-发布设置-固定排班-校验人员是否有排班冲突（第三步）
     *
     * @return
     * @throws BusinessException
     * @author zhangjianhua
     * @date 2018/03/27
     */
    private Map<String, String> checkPerImplement(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
        // 驻勤安排总人数
        int arrangeCount = 0;

        ComTaskTempDTO comTaskTempDTO = new ComTaskTempDTO();

        comTaskTempDTO.setComTaskId(comTaskThreeDTO.getComTaskId());

        // 获取驻勤第二步信息
        Result result = this.getStepTwoDetail(comTaskTempDTO);

        HashMap map = (HashMap) result.getData();

        // 固定驻勤校验人员列表
        List<ValidateTaskFixedPer> listValidateTaskFixedPer = new ArrayList<>();

        // 固定驻勤校验列表
        List<ValidateTaskFixed> listValidateTaskFixed = new ArrayList<>();

        // 固定排班将选择的人员
        List<Long> implementPerIdList = new ArrayList<>();

        List<String> listName = new ArrayList<>();

        // 获取驻勤第一步信息
        Result result1 = this.getStepOneDetail(comTaskTempDTO);

        ComTask comTask = (ComTask) result1.getData();

        //// 查询驻勤状态，未开始的驻勤可进行任意修改
        // if (DictConst.TASKSTATUS_WKS.equals(comTask.getTaskStatus())) {
        // // 删除所有的排班信息
        // comTaskImplementMapper.deleteTaskImplementByComTaskId(comTaskThreeDTO.getComTaskId());
        // // 查询驻勤状态，未终止状态可以进行修改
        // } else if (DictConst.TASKSTATUS_JXZ.equals(comTask.getTaskStatus())
        // || DictConst.TASKSTATUS_YYQ.equals(comTask.getTaskStatus())
        // || DictConst.TASKSTATUS_YZT.equals(comTask.getTaskStatus())) {
        //
        // // 删除未到的班次
        // comTaskImplementMapper.deleteTaskImplementByDate(comTaskThreeDTO.getComTaskId(),
        // DateUtils.getDate("yyyy-MM-dd"));
        // } else
        if (DictConst.TASKSTATUS_YWC.equals(comTask.getTaskStatus())
                || DictConst.TASKSTATUS_YQX.equals(comTask.getTaskStatus())
                || DictConst.TASKSTATUS_YJS.equals(comTask.getTaskStatus())) {
            throw new BusinessException(Result.ERROR, "已经终止的驻勤禁止修改");
        }

        if (map != null) {
            // 固定排班信息
            ComTaskFixedTempDTO comTaskFixedTempDTO = (ComTaskFixedTempDTO) map.get("GDBZ");
            if (comTaskFixedTempDTO != null) {
                // 固定排班周期
                List<ComTaskFixedDTO> list = comTaskFixedTempDTO.getReturnComTaskFixedDList();
                if (list != null && list.size() == 7) {
                    if (comTaskThreeDTO.getTaskPerArray() != null && comTaskThreeDTO.getTaskPerArray().length > 0) {
                        for (String perId : comTaskThreeDTO.getTaskPerArray()) {
                            implementPerIdList.add(Long.parseLong(perId));
                            ValidateTaskFixedPer validateTaskFixedPer = new ValidateTaskFixedPer();
                            validateTaskFixedPer.setPerId(Long.parseLong(perId));
                            validateTaskFixedPer.setMidTaskId(comTaskThreeDTO.getComTaskId());
                            listValidateTaskFixedPer.add(validateTaskFixedPer);
                            if (list != null && list.size() > 0) {
                                for (ComTaskFixedDTO comTaskFixedDTO : list) {
                                    ValidateTaskFixed validateTaskFixed = new ValidateTaskFixed();
                                    validateTaskFixed.setValidateTaskFixedId(idWorker.nextId());
                                    validateTaskFixed.setMidTaskId(comTaskThreeDTO.getComTaskId());
                                    validateTaskFixed.setPerId(Long.parseLong(perId));
                                    validateTaskFixed.setWeekDay(comTaskFixedDTO.getWeekDay());
                                    validateTaskFixed.setShiftId(comTaskFixedDTO.getShiftId());
                                    validateTaskFixed.setCreateTime(comTaskThreeDTO.getCreateTime());
                                    validateTaskFixed.setUpdateTime(comTaskThreeDTO.getUpdateTime());
                                    validateTaskFixed.setComId(comTaskThreeDTO.getComId());
                                    listValidateTaskFixed.add(validateTaskFixed);
                                }
                            }
                        }
                        arrangeCount = implementPerIdList.size();
                    }

                    if (listValidateTaskFixedPer != null && listValidateTaskFixed.size() > 0) {
                        // 批量插入固定驻勤校验人员表
                        int status = validateTaskFixedPerMapper
                                .insertValidateTaskFixedPerList(listValidateTaskFixedPer);

                        if (status <= 0) {
                            throw new BusinessException(Result.ERROR, "校验排班信息失败，请稍后重试");
                        }
                    }

                    if (listValidateTaskFixed != null && listValidateTaskFixed.size() > 0) {
                        // 批量插入固定驻勤校验表
                        int status2 = validateTaskFixedMapper.insertValidateTaskFixedList(listValidateTaskFixed);

                        if (status2 <= 0) {
                            throw new BusinessException(Result.ERROR, "校验排班信息失败，请稍后重试");
                        }
                    }

                    // 校验人员固定排班是否冲突,返回冲突的排班信息
                    List<Map> mapList = validateTaskFixedMapper.checkImplement(
                            DateUtils.formatDate(comTask.getStartDate()), DateUtils.formatDate(comTask.getEndDate()),
                            comTaskThreeDTO.getComTaskId());

                    // 获取人员列表
                    List<Long> listPerId = new ArrayList<>();
                    if (mapList != null && mapList.size() > 0) {
                        for (Map map1 : mapList) {
                            listPerId.add((Long) map1.get("perId"));
                        }
                    }
                    // 存在排班重复的人员去重
                    HashSet hashSet = new HashSet(listPerId);
                    listPerId.clear();
                    listPerId.addAll(hashSet);
                    if (listPerId != null && listPerId.size() > 0) {
                        // 固定排班重复人员名称
                        listName = validateTaskFixedMapper.listName(listPerId);
                    }

                    // 移除存在排班重复的人员
                    for (int i = 0; i < listPerId.size(); i++) {
                        if (implementPerIdList.contains(listPerId.get(i))) {
                            implementPerIdList.remove(listPerId.get(i));
                        }
                    }
                    String[] perArray = new String[implementPerIdList.size()];

                    for (int i = 0; i < implementPerIdList.size(); i++) {
                        perArray[i] = implementPerIdList.get(i).toString();
                    }

                    comTaskThreeDTO.setTaskPerArray(perArray);

					/* 删除校验临时表信息 ***/
                    validateTaskFixedMapper.deleteByPrimaryKey(comTaskThreeDTO.getComTaskId());
                    validateTaskFixedPerMapper.deleteByPrimaryKey(comTaskThreeDTO.getComTaskId());

                } else {
                    throw new BusinessException(Result.BUSINESS_ERROR, "固定排班信息不符合要求，请修改后重试");
                }
            }
        }
        Map<String, String> mapConflict = new HashMap<>();

        mapConflict.put("conflict", listName.toString());
        // 判断员驻勤安排总人数是否等于驻勤冲突总人数，如果想等，则不能发布成功驻勤
        if (listName != null && listName.size() == arrangeCount && listName.size() != 0) {
            throw new BusinessException(Result.BUSINESS_ERROR, "驻勤发布失败：驻勤参与人员全部存在排班冲突！");
        }
        return mapConflict;
    }

    /**
     * 驻勤-发布设置（第三步）（插入数据库）
     *
     * @param comTaskThreeDTO
     * @return
     * @throws BusinessException
     * @author zhangjianhua
     * @date 2018/03/14
     */
    public Map saveOrUpdateTaskThird(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException {
        /* 查询驻勤信息 */
        ComTask comTask = comTaskMapper.getByPrimaryKey(comTaskThreeDTO.getComTaskId());
        if (comTask == null) {
            throw new BusinessException(Result.ERROR, "驻勤信息有误，请稍后重试");
        }
        String taskPerInMode = comTaskThreeDTO.getTaskPerInsMode();
        // 1、负责人信息
        /* 新增驻勤负责人记录 */
        if (comTaskThreeDTO.getChargePerId() != null && comTaskThreeDTO.getChargePerId().toString() != "") {
            ComTaskChargeRecord comTaskChargeRecord = new ComTaskChargeRecord();
            ObjectUtils.copyProperties(comTaskChargeRecord, comTask);
            comTaskChargeRecord.setComTaskChargeRecordId(idWorker.nextId());
            comTaskChargeRecord.setEndTime(comTask.getEndDate());
            comTaskChargeRecord.setChargePerId(comTaskThreeDTO.getChargePerId());
            comTaskMapper.addRecord(comTaskChargeRecord);
            if (comTask.getChargePerId() != null) {
                /* 更新驻勤负责人记录信息 */
                comTaskMapper.updateRecord(comTaskChargeRecord);
            }
        } else {
            throw new BusinessException(Result.ERROR, "驻勤负责人不能为空");
        }

        comTask.setChargePerId(comTaskThreeDTO.getChargePerId());
        /** 校验当前日期是否晚于驻勤开始日期 驻勤开始日期早于（包含等于）当前日期，驻勤状态为进行中
         * 驻勤开始日期晚于当前日期，驻勤状态为未开始 by llc 2018-09-25
         **/
//
//        if (DateUtils.dateCompare(DateUtils.formatDate(comTask.getStartDate()), DateUtils.getDate())) {
//            /*** 由于放开限制可以录入已结束的驻勤，所以校验当前日期早于（包含等于）驻勤结束日期驻勤状态为进行中 ***/
//            if (DateUtils.dateCompare(DateUtils.getDate(), DateUtils.formatDate(comTask.getEndDate()))) {
//                comTask.setTaskStatus(DictConst.TASKSTATUS_JXZ);
//            } else {
//                comTask.setTaskStatus(DictConst.TASKSTATUS_YJS);
//            }
//        } else {
//            comTask.setTaskStatus(DictConst.TASKSTATUS_WKS);
//        }


        if (comTaskMapper.update(comTask) <= 0) {
            throw new BusinessException(Result.ERROR, "设置驻勤负责人失败");
        }
        // 2、推送信息
        // 抄送人员信息列表
        List<ComTaskInsidePush> listComTaskInsidePush = Lists.newArrayList();

		/* 修改或新增驻勤人员逻辑处理 */
        /* 1、先找到原来的驻勤人员 */
        List<String> oldPerList = comTaskInsidePushMapper.listPerIdWithType1(comTaskThreeDTO.getComTaskId());
        if (CollectionUtil.isNotEmpty(oldPerList)) {
			/* 2、对比现在选中的推送人员 */
            List<String> deletePerList = Lists.newArrayList();
            List<String> currentPerList = Lists.newArrayList(comTaskThreeDTO.getTaskPerArray());
            for (String per : oldPerList) {
                if (!currentPerList.contains(per)) {
                    deletePerList.add(per);
                }
            }
			/* 3、找到被删减的驻勤人员，删除今天之后已经排班的记录 */
            if (CollUtil.isNotEmpty(deletePerList)) {
                // 按人员列表删除未到的班次但是已经提前打卡
                comTaskImplementMapper.deletePerTaskCardRecordByPerson(comTaskThreeDTO.getComTaskId(), deletePerList);
                comTaskImplementMapper.deleteRestTaskImplementByDateAndPerList(comTaskThreeDTO.getComTaskId(), deletePerList, DateUtil.today());
                comTaskImplementMapper.deleteTaskImplementByDateAndPerList(comTaskThreeDTO.getComTaskId(), deletePerList);
                comTaskSchedulMapper.deleteByPerListTaskAndFromDate(DateUtil.today(), deletePerList, comTaskThreeDTO.getComTaskId());
            }
            // 删除之前的推送信息
            comTaskInsidePushMapper.deleteByComTaskId(comTaskThreeDTO.getComTaskId());
        }

		/* 添加推送给给抄送人员 */
        if (comTaskThreeDTO.getCcPerId() != null && comTaskThreeDTO.getCcPerId().length > 0) {
            for (String perId : comTaskThreeDTO.getCcPerId()) {
                ComTaskInsidePush comTaskInsidePush = new ComTaskInsidePush();
                ObjectUtils.copyProperties(comTaskInsidePush, comTaskThreeDTO);
                comTaskInsidePush.setInsidePushId(idWorker.nextId());
                comTaskInsidePush.setPerId(Long.parseLong(perId));
                comTaskInsidePush.setPushPerType(DictConst.PUSHPERTYPE_CSRY);
                comTaskInsidePush.setCreateBy(comTaskThreeDTO.getCreateBy());
                comTaskInsidePush.setStartDate(comTask.getStartDate());
                comTaskInsidePush.setEndDate(comTask.getEndDate());
                listComTaskInsidePush.add(comTaskInsidePush);
            }
            if (CollectionUtil.isNotEmpty(listComTaskInsidePush)) {
                // 批量推送给给抄送人员
                int status3 = comTaskInsidePushMapper.insertComTaskInsidePushList(listComTaskInsidePush);
                if (status3 <= 0) {
                    throw new BusinessException(Result.ERROR, "驻勤内部推送失败，请稍后重试");
                }
            }
        }
        // 默认已投保
        String taskInSign = DictConst.TASKINSSIGN_YTB;
        if (DictConst.TASKPERINSMODE_WXTB.equals(taskPerInMode)) {
            taskInSign = DictConst.TASKINSSIGN_WXTB;
        }

        // 驻勤内部推送列表
        List<ComTaskInsidePush> insertComTaskInsidePushList = new ArrayList<>();
        /*** 驻勤安排冲突人员列表 by llc 2020-02-27 ***/
        List<Map<String, String>> conflictPerList = new ArrayList<>();

        /*** 校验通过人员ID列表  ***/
        List<String> checkPassPerIdList = new ArrayList<>();
		/* 添加推送给参与人员 */
        String[] comTaskPerArray = comTaskThreeDTO.getTaskPerArray();
        if (comTaskPerArray != null && comTaskPerArray.length > 0) {
            List<Long> perIdList = new ArrayList<>();
            for (String perIdStr : comTaskThreeDTO.getTaskPerArray()) {
                perIdList.add(Long.parseLong(perIdStr));
            }
            conflictPerList = comTaskInsidePushMapper.getConflictPerList(comTaskThreeDTO.getComTaskId(), comTaskThreeDTO.getComId(), perIdList);
            for (String perIdStr : comTaskThreeDTO.getTaskPerArray()) {
                Boolean checkPassFlag = true;
                /*** 排除本次校验失败的人员 ***/
                for (Map<String, String> map : conflictPerList) {
                    if (map.get("perId").equals(perIdStr)) {
                        checkPassFlag = false;
                        break;
                    }

                }
                if (checkPassFlag) {
                    Long perId = Long.valueOf(perIdStr);
                    ComTaskInsidePush comTaskInsidePush = new ComTaskInsidePush();
                    ObjectUtils.copyProperties(comTaskInsidePush, comTaskThreeDTO);
                    comTaskInsidePush.setInsidePushId(idWorker.nextId());
                    comTaskInsidePush.setPerId(perId);
                    comTaskInsidePush.setPushPerType(DictConst.PUSHPERTYPE_CYRY);
                    comTaskInsidePush.setCreateBy(comTaskThreeDTO.getCreateBy());
                    comTaskInsidePush.setStartDate(comTask.getStartDate());
                    comTaskInsidePush.setEndDate(comTask.getEndDate());
                    insertComTaskInsidePushList.add(comTaskInsidePush);
                    checkPassPerIdList.add(perIdStr);
                }
            }
            if (CollectionUtil.isNotEmpty(insertComTaskInsidePushList)) {
                // 批量插入推送表
                int status3 = comTaskInsidePushMapper.insertComTaskInsidePushList(insertComTaskInsidePushList);
                if (status3 <= 0) {
                    throw new BusinessException(Result.ERROR, "驻勤内部推送失败，请稍后重试");
                }
            }
        }

        // 3、固定排班
        if (DictConst.ATTENDTYPE_GDBZ.equals(comTask.getAttendType())) {

			/* 根据驻勤Id查询需要进行的排班列表 */
            List<ComTaskImplement> comTaskImplementByIdList = comTaskImplementMapper
                    .listComTaskImplementById(comTaskThreeDTO.getComTaskId(), comTaskThreeDTO.getComId());

            if (CollectionUtil.isNotEmpty(comTaskImplementByIdList)) {
                for (ComTaskImplement comTaskImplement : comTaskImplementByIdList) {
                    comTaskImplement.setTaskImplementId(idWorker.nextId());
                }
				/* 批量插入驻勤执行情况表 */
                if (comTaskImplementMapper.insertComTaskImplementList(comTaskImplementByIdList) <= 0) {
                    throw new BusinessException(Result.ERROR, "固定排班失败，请稍后重试");
                }
            }
        }

		/* 获得目前的全部参与人员 或 新增的人员 */
		/* 对比现在选中的推送人员 */
//        List<String> addPerList = Lists.newArrayList();
//        List<String> currentPerList = Lists.newArrayList(comTaskThreeDTO.getTaskPerArray());
//        if (CollUtil.isEmpty(oldPerList)) {
//            addPerList = currentPerList;
//        } else {
//            for (String per : currentPerList) {
//                if (!oldPerList.contains(per)) {
//                    addPerList.add(per);
//                }
//            }
//        }
		/* 排班制才需要初始化 */
        /*** 创建排班不生成排班数据 by llc 2019-10-16 ***/
//		if (DictConst.ATTENDTYPE_PBZ.equals(comTask.getAttendType())) {
//			initTaskPerShift(comTask, addPerList);
//		}



		/* 初始化驻勤打卡提醒*/
        List<ComTaskShift> shiftList = comTaskShiftMapper.getShiftListByTask(comTask.getComTaskId());
        initTaskRemind(comTask.getComId(), comTask, shiftList);
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("conflictPerList", conflictPerList);
        resultMap.put("checkPassPerIdList", checkPassPerIdList);
        return resultMap;
    }

    /**
     * 校验参与人员是否购买保险
     *
     * @return
     */
    private void validatePerIns(ComTaskThreeDTO comTaskThreeDTO, ComTask comTask, Map<String, String> insDetailMap) {
        if (comTask == null) {
			/* 2为全部投保 */
            insDetailMap.put("status", "2");
            insDetailMap.put("detail", "");
            return;
        }

        String taskPerInsMode = comTaskThreeDTO.getTaskPerInsMode();
		/* 无需投保，直接通过校验 */
        if (DictConst.TASKPERINSMODE_WXTB.equals(taskPerInsMode)) {
			/* 2为全部投保 */
            insDetailMap.put("status", "2");
            insDetailMap.put("detail", "");
            return;
        }
        String[] perArray = comTaskThreeDTO.getTaskPerArray();
        if (perArray != null && perArray.length == 0) {
			/* 2为全部投保 */
            insDetailMap.put("status", "2");
            insDetailMap.put("detail", "");
            return;
        }

        // 1.查询驻勤地区的保险购买政策 (经与陈丽商量，不再取规则)
        // List<String> insList =
        // comInsMapper.selectInsCodeByTask(comTask.getCity(),
        // comTaskThreeDTO.getComId());
        //// 2.如果没有找到配置的保险产品，则通过校验，如果有，拿到保险产品
        // if (CollectionUtil.isEmpty(insList)) {
        /// * 2为全部投保 */
        // insDetailMap.put("status", "2");
        // insDetailMap.put("detail", "");
        // return;
        // }

        // 3.查找投保详情
        List<String> perIdStrList = Arrays.asList(perArray);
        List<Long> perIdList = Lists.newArrayList();
        perIdStrList.forEach(perIdStr -> {
            perIdList.add(Long.parseLong(perIdStr));
        });

        // StringBuilder insCodeStr = new StringBuilder();
        // insList.forEach(ins -> {
        // if (StrUtil.isEmpty(insCodeStr.toString())) {
        // insCodeStr.append(ins);
        // } else {
        // insCodeStr.append(",").append(ins);
        // }
        // });

		/* 得到已经投保的用户列表 */
//        List<Map<String, Object>> insPerInfoList = comInsMapper.selectInsDetail(perIdList, comTask.getStartDate(),
//                comTask.getEndDate());
		/* 全部未投保 */
//        if (CollUtil.isEmpty(insPerInfoList)) {
//			/* 0为 全部未投保 */
//            insDetailMap.put("status", "0");
//            return;
//        }
        String blbOrderId = "";
        List<Long> insPerList = Lists.newArrayList();

//        for (Map<String, Object> insPerInfo : insPerInfoList) {
//            insPerList.add(Long.parseLong(insPerInfo.get("perId").toString()));
//            if (StrUtil.isEmpty(blbOrderId)) {
//                blbOrderId = insPerInfo.get("blbOrderId").toString();
//            }
//        }
		/* 得到未投保的用户列表，包含中文名 */
        Collection<Long> notInsIdList = CollUtil.disjunction(perIdList, insPerList);
		/* 全部已经投保 */
        if (CollUtil.isEmpty(notInsIdList)) {
            insDetailMap.put("status", "2");
            insDetailMap.put("detail", "");
            return;
        }
        StringBuilder insDetail = new StringBuilder();
        StringBuilder insListBuilder = new StringBuilder();
        List<String> notInsList = perBaseInfoMapper.selectNameByPrimaryList(notInsIdList);
        notInsList.forEach(per -> {
            if (StrUtil.isEmpty(insDetail.toString())) {
                insDetail.append(per);
            } else {
                insDetail.append("，").append(per);
            }
        });

        notInsIdList.forEach(id -> {
            if (id != null) {
                insListBuilder.append(id);
            } else {
                insListBuilder.append(",").append(id);
            }
        });

		/* 组装投保详情信息 */
		/* 1为 部分未投保 */
        insDetailMap.put("status", "1");
        insDetailMap.put("detail", insDetail.toString());
        insDetailMap.put("blbOrderId", blbOrderId);
        insDetailMap.put("noInsSize", notInsList.size() + "");
        insDetailMap.put("noInsId", insListBuilder.toString());
    }

    /**
     * 删除未生效的驻勤
     *
     * @return
     * @throws BusinessException
     * @author zhangjianhua
     * @date 2018/04/09
     * @update by llc 2020-04-08
     */
    @Override
    public Result deleteTask(ComTaskThreeDTO dto) throws BusinessException {
        ComTask comTask = comTaskMapper.getByPrimaryKey(dto.getComTaskId());
        if (comTask != null) {

            Date today = new Date();
            String todayStr = DateUtils.formatDate(today);

            /*** 删除今日开始的排班记录 ***/

            comTaskSchedulMapper.deleteTaskSchedulFromDate(dto.getComTaskId(), dto.getComId(), todayStr);

            /*** 删除今日开始的驻勤执行情况 ***/

            comTaskImplementMapper.deleteImplementFromDate(dto.getComTaskId(), dto.getComId(), todayStr);

            /*** 删除今日开始的打卡记录 ***/

            perTaskCardRecordMapper.deleteTaskCardRecordByDate(dto.getComTaskId(), dto.getComId(), todayStr);

            /*** 删除打卡提醒表 ***/
            taskCardRemindMapper.deleteByTask(dto.getComTaskId());

            comTaskMapper.deleteTask(dto);

            /*** 同步百保盾 ***/
            ComTaskDto comTaskDto = new ComTaskDto();
            BeanUtil.copyProperties(comTask, comTaskDto);
            comTaskDto.setCreateBy(dto.getCreateBy());
            comTaskDto.setSessionId(dto.getSessionId());

            ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(dto.getComId());
            String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
            /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
            if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//                bdpSyncService.deleteTask(comTaskDto);
            }else{
                bbdTestService.bbdDeleteTask(comTaskDto);
            }

            /*** 驻勤删除通知 ***/
            List<String> perIdList = comTaskInsidePushMapper.listValidPerId(comTask.getComTaskId());
            if (perIdList != null && perIdList.size() > 0) {
                String taskPers = StringUtils.join(perIdList, ",");
                String tilte = MsgConst.TYPE_020104_TASK_DELETE_TITLE;
                String content = MsgConst.TYPE_020104_TASK_DELETE_CONTENT;
                content = content.replace("{taskName}", comTask.getTaskName());
                commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020104, taskPers,
                        comTask.getComId(), comTask.getComTaskId());
            }

            /*** 驻勤删除通知负责人 ***/
            String tilte2 = MsgConst.TYPE_0201041_TASK_DELETE_TITLE;
            String content2 = MsgConst.TYPE_0201041_TASK_DELETE_CONTENT;
            String createrName = perBaseInfoMapper.getNameById(dto.getUpdateBy());
            content2 = content2.replace("{taskName}", comTask.getTaskName()).replace("{operate}", createrName);
            commonService.sendMessageToApp(tilte2, content2, DictMessageTypeConst.MESSAGETYPE_020104, comTask.getChargePerId().toString(),
                    comTask.getComId(), comTask.getComTaskId());

        } else {
            // 找暂存的数据
            MidTask midtask = midTaskMapper.getByPrimaryKey(dto.getComTaskId());
            if (midtask == null) {
                throw new BusinessException(Result.ERROR, "驻勤不存在，操作失败");
            }
            /*** 删除驻勤暂存表 ***/
            midTaskDetailMapper.deleteByMidTaskId(midtask.getMidTaskId());
            midTaskMapper.deleteByMidTaskId(midtask.getMidTaskId());
        }
        return Result.success("驻勤删除成功");
    }

    /**
     * 延长驻勤
     *
     * @param comTask
     * @author llc
     * @date 2020-04-09
     */
    @Override
    public Result extendTask(ComTask comTask) throws BusinessException {
        if (comTask.getComTaskId() == null) {
            return Result.fail("驻勤ID不能为空");
        }
        if (comTask.getEndDate() == null) {
            return Result.fail("驻勤结束日期不能为空");
        }
        ComTask oldComTask = comTaskMapper.getByPrimaryKey(comTask.getComTaskId());
        if (oldComTask == null) {
            return Result.fail("未查找到驻勤");
        }
        if (oldComTask.getChargePerId() == null) {
            return Result.fail("此驻勤任务还没有负责人，请先设置负责人！");
        }
        comTask.setTaskStatus(DictConst.TASKSTATUS_JXZ);
        comTaskMapper.update(comTask);


        /*** 查询符合延期条件的驻勤人员ID列表 ***/

        List<Long> extendTaskPerIdList = comTaskInsidePushMapper.getExtendTaskPerList(comTask.getComId(),comTask.getComTaskId(), oldComTask.getEndDate());


        /*** 更新符合延期条件的驻勤人员的终止日期 ***/
        if(extendTaskPerIdList != null && extendTaskPerIdList.size() >0){
            comTaskInsidePushMapper.updateTaskPerEndDateByIdList(comTask.getUpdateBy(),comTask.getEndDate(),extendTaskPerIdList);
        }


        /*** 同步百保盾 ***/
        ComTaskDto comTaskDto = new ComTaskDto();
        BeanUtil.copyProperties(oldComTask, comTaskDto);
        comTaskDto.setSessionId(comTask.getSessionId());
        comTaskDto.setTaskStatus(comTask.getTaskStatus());
        comTaskDto.setEndDate(comTask.getEndDate());
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(comTask.getComId());
        String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
        /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
        if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//            bdpSyncService.updateTask(comTaskDto);
        }else{
            bbdTestService.bbdSaveOrUpdateTask(comTaskDto);
        }

        /*** 发送通知 ***/

        /*** 驻勤延期通知负责人 ***/
        String tilte = MsgConst.TYPE_0201181_TASK_EXTEND_TITLE;
        String content = MsgConst.TYPE_0201181_TASK_EXTEND_CONTENT;
        String createrName = perBaseInfoMapper.getNameById(comTask.getUpdateBy());
        content = content.replace("{taskName}", oldComTask.getTaskName())
                .replace("{operate}", createrName)
                .replace("{endDate}", DateUtils.formatDate(comTask.getEndDate()));
        commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020118, oldComTask.getChargePerId().toString(),
                comTask.getComId(), comTask.getComTaskId());

        return Result.success(Result.SUCCESS_QUERY_MSG);
    }

    /**
     * 驻勤
     *
     * @param comTask
     * @author llc
     * @date 2020-04-09
     */
    @Override
    public Result endTask(ComTask comTask) throws BusinessException {
        if (comTask.getComTaskId() == null) {
            return Result.fail("驻勤ID不能为空");
        }

        ComTask oldComTask = comTaskMapper.getByPrimaryKey(comTask.getComTaskId());
        if (oldComTask == null) {
            return Result.fail("未查找到驻勤");
        }

        Date today = new Date();
        comTask.setEndDate(today);
        comTaskMapper.update(comTask);
        String todayStr = DateUtils.formatDate(today);
        String tomorrowStr = DateUtils.getTomorrow();

        /*** 更新驻勤人员的终止日期 ***/

        comTaskInsidePushMapper.endTaskUpdatePerEndDate(comTask.getUpdateBy(), comTask.getComTaskId(),  comTask.getEndDate());

        /*** 删除明日开始的排班记录 ***/

        comTaskSchedulMapper.deleteTaskSchedulFromDate(comTask.getComTaskId(), comTask.getComId(), tomorrowStr);


        /*** 删除明日开始的驻勤执行情况 ***/

        comTaskImplementMapper.deleteImplementFromDate(comTask.getComTaskId(), comTask.getComId(), tomorrowStr);


        /*** 删除明日开始的打卡记录 ***/

        perTaskCardRecordMapper.deleteTaskCardRecordByDate(comTask.getComTaskId(), comTask.getComId(), tomorrowStr);


        /*** 同步百保盾 ***/
        ComTaskDto comTaskDto = new ComTaskDto();
        BeanUtil.copyProperties(oldComTask, comTaskDto);
        comTaskDto.setSessionId(comTask.getSessionId());
        ;
        comTaskDto.setTaskStatus(comTask.getTaskStatus());
        comTaskDto.setEndDate(comTask.getEndDate());

        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(comTask.getComId());
        String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
        /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
        if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//            bdpSyncService.updateTask(comTaskDto);
        }else{
            bbdTestService.bbdSaveOrUpdateTask(comTaskDto);
        }

        /*** 发送通知 ***/
        /*** 驻勤结束通知 ***/
        List<String> perIdList = comTaskInsidePushMapper.listValidPerId(comTask.getComTaskId());

        if (perIdList != null && perIdList.size() > 0) {
            String taskPers = StringUtils.join(perIdList, ",");
            String tilte = MsgConst.TYPE_020106_TASK_END_TITLE;
            String content = MsgConst.TYPE_020106_TASK_END_CONTENT;

            content = content.replace("{taskName}", oldComTask.getTaskName()).replace("{date}", todayStr);
            commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020104, taskPers,
                    comTask.getComId(), comTask.getComTaskId());
        }

        /*** 驻勤结束通知负责人 ***/
        String tilte2 = MsgConst.TYPE_0201061_TASK_END_TITLE;
        String content2 = MsgConst.TYPE_0201061_TASK_END_CONTENT;
        String createrName = perBaseInfoMapper.getNameById(comTask.getUpdateBy());
        content2 = content2.replace("{taskName}", oldComTask.getTaskName()).replace("{operate}", createrName).replace("{date}", todayStr);
        commonService.sendMessageToApp(tilte2, content2, DictMessageTypeConst.MESSAGETYPE_020106, oldComTask.getChargePerId().toString(),
                comTask.getComId(), comTask.getComTaskId());

        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 定时修改驻勤状态
     *
     * @return
     * @throws BusinessException
     */
    @Override
    public Result changeTaskStatus() throws BusinessException {

        comTaskMapper.updateAllTaskByTaskStatus();

        return Result.success("");
    }

    /**
     * 初始化该驻勤所有的排班记录，仅限第一次保存的人员
     */
    private void initTaskPerShift(ComTask comTask, List<String> perList) {
        if (CollUtil.isEmpty(perList)) {
            return;
        }
        List<ComTaskImplement> implementList = Lists.newArrayList();
        List<ComTaskSchedul> taskSchedulList = Lists.newArrayList();

        Date startDate = comTask.getStartDate();
        Date endDate = comTask.getEndDate();

		/* 如果驻勤开始日期早于当天，从当天开始算 */
        if (startDate.before(DateUtil.beginOfDay(DateUtil.date()))) {
            startDate = DateUtil.beginOfDay(DateUtil.date());
        }
        List<String> dateList = DateUtils.getBetweenDatesByDate(startDate, endDate);

		/* 拿到人员，进行排班 */
        for (String per : perList) {
            for (String date : dateList) {
                ComTaskImplement obj = comTaskPerShiftService.packComTaskImplement(idWorker, comTask.getComId(),
                        comTask.getComTaskId(), Long.parseLong(per), date, null, null, DictConst.ATTENDTYPE_PBZ,
                        PublicConst.Y, comTask.getCreateBy());
                ComTaskSchedul obj2 = comTaskPerShiftService.packComTaskSchedule(idWorker, comTask.getComId(),
                        comTask.getComTaskId(), Long.parseLong(per), date, null, PublicConst.Y);
                implementList.add(obj);
                taskSchedulList.add(obj2);
            }
        }

		/* 批量插入 */
        if (CollectionUtil.isNotEmpty(taskSchedulList)) {
            comTaskSchedulMapper.insertBatch(taskSchedulList);
        }

        if (CollectionUtil.isNotEmpty(implementList)) {
            comTaskImplementMapper.insertBatch(implementList);
        }

    }

    /**
     * 外勤打卡提醒定时器
     *
     * @return
     * @author llc
     * @date 2019-01-10
     */
    @Override
    public Result taskCardRemindJob() throws BusinessException {

        String currentDate = DateUtil.today();
        String currentTime = DateUtils.formatDate(new Date(), "HH:mm") + ":00";


        List<TaskCardRemindDTO> attendCardRemindList = taskCardRemindMapper.getTaskCardRemindList(currentDate, currentTime);
        if (CollectionUtil.isEmpty(attendCardRemindList)) {
            return Result.success(Result.SUCCESS_QUERY_MSG);
        }

        /*** 如果有需要提醒的人员，再去查询设置的人员 ***/
        List<Map<String, String>> perList = taskCardRemindMapper.getTaskCardRemindPerList(currentDate, currentTime, attendCardRemindList);
        for (TaskCardRemindDTO dto : attendCardRemindList) {
            Iterator<Map<String, String>> iter = perList.iterator();
            StringBuilder builder = new StringBuilder();
            while (iter.hasNext()) {
                Map<String, String> map = iter.next();
                if (map.get("comTaskId").equals(dto.getComTaskId())) {
                    builder.append(map.get("perId")).append(",");
                    iter.remove();
                }
            }
            dto.setPerIdStr(builder.toString());
        }

        List<TaskCardRemindDTO> remindList = new ArrayList<>();
        /** 排除当天未安排人的驻勤 ***/
        for (TaskCardRemindDTO dto : attendCardRemindList) {
            if (StringUtil.isEmpty(dto.getPerIdStr())) {
                continue;
            }
            remindList.add(dto);
        }
        /* 通知 */
        for (TaskCardRemindDTO dto : remindList) {
            String content = MsgConst.TYPE_020117_TASK_CLOCK_REMIND_CONTENT;
            content = content.replace("{clockTime}", dto.getAttendTime()).replace("{taskName}", dto.getTaskName());
            commonService.sendMessageToApp(MsgConst.TYPE_020117_TASK_CLOCK_REMIND_TITLE, content,
                    DictMessageTypeConst.MESSAGETYPE_020117, dto.getPerIdStr(),
                    Long.parseLong(dto.getComId()), Long.parseLong(dto.getComTaskId()));
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, remindList);
    }


    /**
     * 驻勤到期提醒定时器
     *
     * @return
     * @author llc
     * @date 2020-04-24
     */
    @Override
    public Result taskExpireRemind() throws BusinessException {

        List<Map<String, String>> taskList = comTaskMapper.getSoonExpireTask();
        if (CollectionUtil.isEmpty(taskList)) {
            return Result.success(Result.SUCCESS_QUERY_MSG);
        }
        /* 通知 */
        for (Map<String, String> map : taskList) {
            String content = MsgConst.TYPE_020119_TASK_EXPIRE_REMIND_CONTENT;
            if (StringUtils.isNotEmpty(map.get("chargePerId"))) {
                content = content.replace("{taskName}", map.get("taskName")).replace("{endDate}", map.get("endDate"));
                commonService.sendMessageToApp(MsgConst.TYPE_020119_TASK_EXPIRE_REMIND_TITLE, content,
                        DictMessageTypeConst.MESSAGETYPE_020119, map.get("chargePerId"),
                        Long.parseLong(map.get("comId")), Long.parseLong(map.get("comTaskId")));
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG);
    }

    /**
     * 检测合同是否关联了驻勤
     *
     * @param dto
     * @author llc
     * @date 2019-05-15
     */
    @Override
    public Result checkRelateTaskByContractId(ComTaskDto dto) {
        if (dto.getComContractId() == null) {
            return Result.fail("合同ID不能为空");
        }
        List<String> list = comTaskMapper.checkRelateTaskByContractId(dto);
        Map<String, String> resultMap = new HashMap<>();
        if (list.size() == 0) {
            resultMap.put("isExistsRelateTask", "0");
            resultMap.put("taskNames", null);
        } else {
            resultMap.put("isExistsRelateTask", "1");
            String taskNames = "";
            for (String taskName : list) {
                taskNames = taskNames + "【" + taskName + "】" + ",";
            }
            resultMap.put("taskNames", taskNames.substring(0, taskNames.length() - 1));
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /**
     * 获取公司驻勤驻勤点类型
     *
     * @return
     * @author llc
     * @date 2019-11-01
     */
    @Override
    public Result getComtaskStationType(ComTask comTask) {
        List<Map<String, Object>> list = comTaskMapper.getComtaskStationType(comTask);
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    /**
     * 防控指挥获取驻勤列表
     *
     * @return
     * @author llc
     * @date 2019-11-01
     */
    @Override
    public Result getComTaskList(ComTask comTask) {
        if (comTask.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comTask.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        PageHelper.startPage(comTask.getPageNumber(), comTask.getPageSize());
        List<Map<String, Object>> list = comTaskMapper.getComTaskList(comTask);
        if (list == null) {
            return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(new ArrayList()));
        }
        for (Map<String, Object> map : list) {
            if (map.get("addressLongitude") != null && map.get("addressLatitude") != null) {
                if (StringUtil.isNotEmpty(map.get("addressLongitude").toString()) && StringUtil.isNotEmpty(map.get("addressLatitude").toString())) {
                    double longitudeDouble = Double.valueOf(map.get("addressLongitude").toString());
                    double latitudeDouble = Double.valueOf(map.get("addressLatitude").toString());
                    Double[] lnglat = new Double[]{longitudeDouble, latitudeDouble};
                    map.put("lnglat", lnglat);
                } else {
                    map.put("lnglat", null);
                }
            } else {
                map.put("lnglat", null);
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    /**
     * 防控指挥获取驻勤人员位置
     *
     * @return
     * @author llc
     * @date 2019-11-01
     */
    @Override
    public Result getComTaskPerLocation(ComTask comTask) {
        if (comTask.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
        }
        if (comTask.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comTask.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        PageHelper.startPage(comTask.getPageNumber(), comTask.getPageSize());
        List<Map<String, Object>> list = comTaskMapper.getComTaskPerLocation(comTask);
        if (list == null) {
            return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(new ArrayList()));
        }
        for (Map<String, Object> map : list) {
            if (map.get("longitude") != null && map.get("latitude") != null) {
                if (StringUtil.isNotEmpty(map.get("longitude").toString()) && StringUtil.isNotEmpty(map.get("latitude").toString())) {
                    double longitudeDouble = Double.valueOf(map.get("longitude").toString());
                    double latitudeDouble = Double.valueOf(map.get("latitude").toString());
                    Double[] lnglat = new Double[]{longitudeDouble, latitudeDouble};
                    map.put("lnglat", lnglat);
                } else {
                    map.put("lnglat", null);
                }
            } else {
                map.put("lnglat", null);
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Result deleteBatchComTask(ComTaskDto dto) {
        List<Long> comTaskIdList = dto.getComTaskIdList();
        //批量删除需要清理的
        comTaskFixedMapper.deleteApproveTaskAdjustApply(comTaskIdList);
        comTaskFixedMapper.deleteApproveTaskLeaveApply(comTaskIdList);
        comTaskFixedMapper.deleteApproveTaskRemedyApply(comTaskIdList);
        comTaskFixedMapper.deleteComTaskApprove(comTaskIdList);
        comTaskFixedMapper.deleteComTaskAttendAddress(comTaskIdList);
        comTaskFixedMapper.deleteComTaskAttendWifi(comTaskIdList);
        comTaskFixedMapper.deleteComTaskBehalf(comTaskIdList);
        comTaskFixedMapper.deleteComTaskChargeRecord(comTaskIdList);
        comTaskFixedMapper.deleteComTaskContract(comTaskIdList);
        comTaskFixedMapper.deleteComTaskFeedback(comTaskIdList);
        comTaskFixedMapper.deleteComTaskFixed(comTaskIdList);
        comTaskFixedMapper.deleteComTaskFree(comTaskIdList);
        comTaskFixedMapper.deleteComTaskImplement(comTaskIdList);
        comTaskFixedMapper.deleteComTaskInsidePush(comTaskIdList);
        comTaskFixedMapper.deleteComTaskMidControl(comTaskIdList);
        comTaskFixedMapper.deleteComTaskOperProcess(comTaskIdList);
        comTaskFixedMapper.deleteComTaskReinforce(comTaskIdList);
        comTaskFixedMapper.deleteComTaskSchedul(comTaskIdList);
        comTaskFixedMapper.deleteComTaskSchedulCycle(comTaskIdList);
        comTaskFixedMapper.deleteComTaskShift(comTaskIdList);
        comTaskFixedMapper.deleteCountPerTaskApproveDate(comTaskIdList);
        comTaskFixedMapper.deleteCountPerTaskDate(comTaskIdList);
        comTaskFixedMapper.deletePerTaskCardRecord(comTaskIdList);
        comTaskFixedMapper.deleteTaskCardRemind(comTaskIdList);
        comTaskFixedMapper.deleteTask(comTaskIdList);
        comTaskFixedMapper.deleteTaskMessagePer(comTaskIdList);
        comTaskFixedMapper.deleteTaskMessage(comTaskIdList);

        /*** 同步百保盾 ***/
        bbdTestService.bbdDeleteTaskBatch(dto, comTaskIdList);

        return Result.success(Result.SUCCESS_QUERY_MSG);
    }

    /**
     * 通过合同ID查找驻勤点
     *
     * @return
     * @author llc
     * @date 2020-06-10
     */
    @Override
    public Result getTaskListByContractId(ComTask comTask) {
        if (comTask.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (comTask.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (comTask.getComContractId() == null) {
            return Result.fail("合同ID不能为空");
        }
        PageHelper.startPage(comTask.getPageNumber(), comTask.getPageSize());
        List<Map<String, Object>> list = comTaskMapper.getTaskListByContractId(comTask);
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    /**
     * 公安获取任务驻勤点类型
     *
     * @return
     * @author llc
     * @date 2020-07-02
     */
    @Override
    public Result policeGetTaskStationType(ComTask comTask) {
        /*** 获取公安机构所在省份 ***/
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(comTask.getComId());
        comTask.setProvince(comBaseInfo.getRegProvince());
        List<Map<String, Object>> list = comTaskMapper.policeGetTaskStationType(comTask);
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    /**
     * 公安防控指挥获取任务列表
     *
     * @return
     * @author llc
     * @date 2020-07-02
     */
    @Override
    public Result policeGetTaskList(ComTaskDto dto) {
        if (dto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        /*** 获取公安机构所在省份 ***/
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(dto.getComId());
        dto.setProvince(comBaseInfo.getRegProvince());
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<Map<String, Object>> list = comTaskMapper.policeGetTaskList(dto);
        if (list == null) {
            return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(new ArrayList()));
        }
        for (Map<String, Object> map : list) {
            if (map.get("addressLongitude") != null && map.get("addressLatitude") != null) {
                if (StringUtil.isNotEmpty(map.get("addressLongitude").toString()) && StringUtil.isNotEmpty(map.get("addressLatitude").toString())) {
                    double longitudeDouble = Double.valueOf(map.get("addressLongitude").toString());
                    double latitudeDouble = Double.valueOf(map.get("addressLatitude").toString());
                    Double[] lnglat = new Double[]{longitudeDouble, latitudeDouble};
                    map.put("lnglat", lnglat);
                } else {
                    map.put("lnglat", null);
                }
            } else {
                map.put("lnglat", null);
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }


    /**
     * 公安防控指挥获取任务位置列表
     *
     * @return
     * @author llc
     * @date 2020-07-09
     */
    @Override
    public Result policeGetTaskLocationList(ComTaskDto dto) {
        if (dto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        /*** 获取公安机构所在省份 ***/
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(dto.getComId());
        dto.setProvince(comBaseInfo.getRegProvince());
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<Map<String, Object>> list = comTaskMapper.policeGetTaskLocationList(dto);
        if (list == null) {
            return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(new ArrayList()));
        }
        for (Map<String, Object> map : list) {
            if (map.get("addressLongitude") != null && map.get("addressLatitude") != null) {
                if (StringUtil.isNotEmpty(map.get("addressLongitude").toString()) && StringUtil.isNotEmpty(map.get("addressLatitude").toString())) {
                    double longitudeDouble = Double.valueOf(map.get("addressLongitude").toString());
                    double latitudeDouble = Double.valueOf(map.get("addressLatitude").toString());
                    Double[] lnglat = new Double[]{longitudeDouble, latitudeDouble};
                    map.put("lnglat", lnglat);
                } else {
                    map.put("lnglat", null);
                }
            } else {
                map.put("lnglat", null);
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    /**
     * 公安防控指挥获取任务信息
     *
     * @return
     * @author llc
     * @date 2020-07-09
     */
    @Override
    public Result policeGetTaskById(ComTaskDto dto) {
        if(dto.getComTaskId() == null){
            return Result.fail("驻勤点Id不能为空");
        }
        Map<String, Object> map = comTaskMapper.policeGetTaskById(dto);
        return Result.success(Result.SUCCESS_QUERY_MSG, map);


    }

}